/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.action.menu;

import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.rt.client.ui.action.menu.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.action.menu.ISwingScoutContextMenu;

public class SwingScoutContextMenu
extends MouseAdapter
implements FocusListener,
ISwingScoutContextMenu {
    protected final BasicPropertySupport m_propertySupport;
    private final ISwingEnvironment m_environment;
    private final JComponent m_target;
    private Set<JTextComponent> m_copyPasteMenuOwner;
    private IContextMenu m_scoutContextMenu;

    public SwingScoutContextMenu(JComponent target, IContextMenu scoutContextMenu, ISwingEnvironment environment) {
        this(target, scoutContextMenu, environment, true);
    }

    public SwingScoutContextMenu(JComponent target, IContextMenu scoutContextMenu, ISwingEnvironment environment, boolean callInitializer) {
        this.m_target = target;
        this.m_scoutContextMenu = scoutContextMenu;
        this.m_environment = environment;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.m_copyPasteMenuOwner = new HashSet<JTextComponent>();
    }

    public ISwingEnvironment getEnvironment() {
        return this.m_environment;
    }

    public JComponent getTarget() {
        return this.m_target;
    }

    public IContextMenu getScoutContextMenu() {
        return this.m_scoutContextMenu;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && this.isLocationOnText(e.getPoint())) {
            this.showSwingPopup(this.getTarget(), e.getX(), e.getY(), true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && this.isLocationOnText(e.getPoint())) {
            this.showSwingPopup(this.getTarget(), e.getX(), e.getY(), true);
        }
    }

    private boolean isLocationOnText(Point p) {
        if (this.getTarget() instanceof JTextComponent) {
            JTextComponent textComp = (JTextComponent)this.getTarget();
            Insets insets = textComp.getBorder().getBorderInsets(textComp);
            if (insets == null) {
                return true;
            }
            return p.x >= insets.left && p.y >= insets.top && p.x <= textComp.getWidth() - insets.right && p.y <= textComp.getHeight() - insets.bottom;
        }
        return false;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.getTarget().setComponentPopupMenu(null);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.getTarget().setComponentPopupMenu(null);
    }

    public void showSwingPopup(int x, int y, boolean showSystemMenus) {
        this.showSwingPopup(this.getTarget(), x, y, showSystemMenus);
    }

    public void showSwingPopup(JComponent comp, int x, int y, boolean showSystemMenus) {
        JTextComponent systemMenuOwner = null;
        if (this.m_copyPasteMenuOwner.contains(comp) && showSystemMenus) {
            systemMenuOwner = (JTextComponent)comp;
        }
        comp.requestFocus();
        new SwingPopupWorker(this.getEnvironment(), this.getTarget(), systemMenuOwner, new Point(x, y), MenuUtility.consolidateMenus((List)this.getScoutContextMenu().getChildActions())).run();
    }

    public void addCopyPasteMenuOwner(JTextComponent target) {
        this.m_copyPasteMenuOwner.add(target);
    }

    public boolean removeCopyPasteMenuOwner(JTextComponent target) {
        return this.m_copyPasteMenuOwner.remove(target);
    }

    public static SwingScoutContextMenu installContextMenuWithSystemMenus(JTextComponent target, IContextMenu scoutContextMenu, ISwingEnvironment environment) {
        SwingScoutContextMenu contextMenu = SwingScoutContextMenu.installContextMenu(target, scoutContextMenu, environment);
        contextMenu.addCopyPasteMenuOwner(target);
        return contextMenu;
    }

    public static SwingScoutContextMenu installContextMenu(final JComponent target, IContextMenu scoutContextMenu, ISwingEnvironment environment) {
        SwingScoutContextMenu contextMenu = new SwingScoutContextMenu(target, scoutContextMenu, environment);
        target.addMouseListener(contextMenu);
        target.addFocusListener(contextMenu);
        target.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (525 == e.getKeyCode()) {
                    SwingScoutContextMenu.this.showSwingPopup(target, target.getLocation().x, target.getLocation().y, target.isEnabled() && target.isShowing());
                }
            }
        });
        return contextMenu;
    }
}

