/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.tree;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.ui.swing.SwingPopupWorker;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.basic.tree.ISwingScoutTree;
import org.eclipse.scout.rt.ui.swing.basic.tree.SwingTreeCellRenderer;
import org.eclipse.scout.rt.ui.swing.basic.tree.SwingTreeModel;
import org.eclipse.scout.rt.ui.swing.basic.tree.TreeHtmlLinkDetector;
import org.eclipse.scout.rt.ui.swing.dnd.TransferHandlerEx;
import org.eclipse.scout.rt.ui.swing.ext.JScrollPaneEx;
import org.eclipse.scout.rt.ui.swing.ext.JTreeEx;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;

public class SwingScoutTree
extends SwingScoutComposite<ITree>
implements ISwingScoutTree {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutTree.class);
    private P_ScoutTreeListener m_scoutTreeListener;
    private JScrollPane m_swingScrollPane;
    private List<IKeyStroke> m_installedScoutKs;

    @Override
    protected void initializeSwing() {
        JTreeEx tree = new JTreeEx();
        this.m_swingScrollPane = new JScrollPaneEx(tree);
        this.m_swingScrollPane.setBackground(tree.getBackground());
        this.setSwingField(tree);
        tree.setDragEnabled(true);
        tree.setModel(new SwingTreeModel(this));
        tree.setSelectionModel(new DefaultTreeSelectionModel());
        tree.setCellRenderer(new SwingTreeCellRenderer(this.getSwingEnvironment(), tree.getCellRenderer(), this));
        tree.addMouseListener(new P_SwingMouseListener());
        tree.addTreeSelectionListener(new P_SwingSelectionListener());
        tree.addTreeExpansionListener(new P_SwingExpansionListener());
        P_SwingDragAndDropTransferHandler th = new P_SwingDragAndDropTransferHandler();
        tree.setTransferHandler(th);
        try {
            tree.getDropTarget().addDropTargetListener(new P_DropTargetListener());
        }
        catch (TooManyListenersException e1) {
            LOG.error(e1.getMessage());
        }
        this.m_swingScrollPane.addComponentListener(new ComponentAdapter(){
            private int m_oldHeight = -1;

            @Override
            public void componentResized(ComponentEvent e) {
                int newHeight = e.getComponent().getHeight();
                if (this.m_oldHeight >= 0 && this.m_oldHeight == newHeight) {
                    return;
                }
                this.m_oldHeight = newHeight;
                ITree t = (ITree)SwingScoutTree.this.getScoutObject();
                if (t != null && t.isScrollToSelection() && e.getComponent().isShowing()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingScoutTree.this.scrollToSelection();
                        }
                    });
                }
            }
        });
        tree.getInputMap(0).put(SwingUtility.createKeystroke("CONTEXT_MENU"), "contextMenu");
        tree.getActionMap().put("contextMenu", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath selectedPath;
                if (SwingScoutTree.this.getUpdateSwingFromScoutLock().isAcquired()) {
                    return;
                }
                if (SwingScoutTree.this.getScoutObject() != null && (selectedPath = SwingScoutTree.this.getSwingTree().getSelectionPath()) != null) {
                    final Point p = SwingScoutTree.this.getSwingTree().getPathBounds(selectedPath).getLocation();
                    final JTreeEx source = SwingScoutTree.this.getSwingTree();
                    p.translate(2, 2);
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            List scoutMenus = ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().fireNodePopupFromUI();
                            new SwingPopupWorker(SwingScoutTree.this.getSwingEnvironment(), source, p, scoutMenus).enqueue();
                        }
                    };
                    SwingScoutTree.this.getSwingEnvironment().invokeScoutLater(t, 5678L);
                }
            }
        });
    }

    @Override
    public JTreeEx getSwingTree() {
        return (JTreeEx)this.getSwingField();
    }

    protected TreeSelectionModel getSwingTreeSelectionModel() {
        return this.getSwingTree().getSelectionModel();
    }

    @Override
    public JScrollPane getSwingScrollPane() {
        return this.m_swingScrollPane;
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        this.saveScrollbarValues();
        if (this.m_scoutTreeListener != null) {
            ((ITree)this.getScoutObject()).removeTreeListener((TreeListener)this.m_scoutTreeListener);
            this.m_scoutTreeListener = null;
        }
    }

    @Override
    protected void attachScout() {
        IEventHistory h;
        super.attachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTreeListener == null) {
            this.m_scoutTreeListener = new P_ScoutTreeListener();
            ((ITree)this.getScoutObject()).addUITreeListener((TreeListener)this.m_scoutTreeListener);
        }
        this.setMultiSelectFromScout(((ITree)this.getScoutObject()).isMultiSelect());
        this.setRootNodeVisibleFromScout();
        this.setRootHandlesVisibleFromScout();
        this.setExpansionFromScout(((ITree)this.getScoutObject()).getRootNode());
        this.setSelectionFromScout(((ITree)this.getScoutObject()).getSelectedNodes());
        this.setKeyStrokesFromScout();
        if (((ITree)this.getScoutObject()).isCheckable()) {
            this.getSwingTree().getInputMap(0).put(SwingUtility.createKeystroke("SPACE"), "toggleRow");
            this.getSwingTree().getActionMap().put("toggleRow", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingScoutTree.this.handleSwingNodeClick(SwingScoutTree.this.getSwingTree().getSelectionPath());
                }
            });
        }
        if ((h = ((ITree)this.getScoutObject()).getEventHistory()) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (TreeEvent e : h.getRecentEvents()) {
                        SwingScoutTree.this.handleScoutTreeEventInSwing(e);
                    }
                }
            });
        }
        this.restoreScrollbarValues();
    }

    protected void setMultiSelectFromScout(boolean on) {
        if (on) {
            this.getSwingTree().getSelectionModel().setSelectionMode(4);
        } else {
            this.getSwingTree().getSelectionModel().setSelectionMode(1);
        }
    }

    protected void setExpansionFromScout(ITreeNode scoutNode) {
        this.setExpansionFromScoutRec(scoutNode);
        this.revertSelectionFromScout();
        if (this.getSwingTree().getLeadSelectionPath() == null) {
            TreeModel swingModel = this.getSwingTree().getModel();
            Object leadNode = null;
            if (this.getSwingTree().isRootVisible()) {
                leadNode = swingModel.getRoot();
            } else {
                Object root = swingModel.getRoot();
                if (root != null) {
                    leadNode = swingModel.getChild(root, 0);
                }
            }
            if (leadNode != null) {
                this.getSwingTree().setLeadSelectionPath(SwingScoutTree.scoutNodeToTreePath((ITreeNode)leadNode));
            }
        }
    }

    private void setExpansionFromScoutRec(ITreeNode scoutNode) {
        boolean expanded = scoutNode.getParentNode() == null ? true : scoutNode.isExpanded();
        TreePath path = SwingScoutTree.scoutNodeToTreePath(scoutNode);
        if (expanded) {
            this.getSwingTree().expandPath(path);
        } else if (this.getSwingTree().isExpanded(path)) {
            this.getSwingTree().collapsePath(path);
        }
        if (expanded) {
            List childs = scoutNode.getFilteredChildNodes();
            for (ITreeNode node : childs) {
                this.setExpansionFromScoutRec(node);
            }
        }
    }

    protected void setExpansionFromSwing(TreePath path, final boolean b) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            final ITreeNode scoutNode = SwingScoutTree.treePathToScoutNode(path);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().setNodeExpandedFromUI(scoutNode, b);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void setRootNodeVisibleFromScout() {
        this.getSwingTree().setRootVisible(((ITree)this.getScoutObject()).isRootNodeVisible());
        this.getSwingTree().repaint();
    }

    protected void setRootHandlesVisibleFromScout() {
        this.getSwingTree().setShowsRootHandles(((ITree)this.getScoutObject()).isRootHandlesVisible());
        this.getSwingTree().repaint();
    }

    protected void setSelectionFromScout(Collection<ITreeNode> newScoutNodes) {
        List<ITreeNode> oldScoutNodes = SwingScoutTree.treePathsToScoutNodes(CollectionUtility.arrayList((Object[])this.getSwingTree().getSelectionPaths()));
        if (!CollectionUtility.equalsCollection(oldScoutNodes, newScoutNodes)) {
            ITreeNode leadScoutNode;
            List<TreePath> paths = SwingScoutTree.scoutNodesToTreePaths(newScoutNodes);
            TreePath anchorPath = this.getSwingTree().getAnchorSelectionPath();
            TreePath leadPath = this.getSwingTree().getLeadSelectionPath();
            this.getSwingTree().setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
            ITreeNode anchorScoutNode = SwingScoutTree.treePathToScoutNode(anchorPath);
            if (anchorScoutNode != null && anchorScoutNode.getTree() != null && anchorScoutNode.isVisible() && anchorScoutNode.isFilterAccepted()) {
                this.getSwingTree().setAnchorSelectionPath(anchorPath);
            }
            if ((leadScoutNode = SwingScoutTree.treePathToScoutNode(leadPath)) != null && leadScoutNode.getTree() != null && leadScoutNode.isVisible() && leadScoutNode.isFilterAccepted()) {
                this.getSwingTree().setLeadSelectionPath(leadPath);
            }
        }
    }

    protected void revertSelectionFromScout() {
        Set newScoutNodes = ((ITree)this.getScoutObject()).getSelectedNodes();
        List<ITreeNode> oldScoutNodes = SwingScoutTree.treePathsToScoutNodes(CollectionUtility.arrayList((Object[])this.getSwingTree().getSelectionPaths()));
        if (!CollectionUtility.equalsCollection(oldScoutNodes, (Collection)newScoutNodes)) {
            List<TreePath> paths = SwingScoutTree.scoutNodesToTreePaths(newScoutNodes);
            this.getSwingTree().setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
        }
    }

    protected void setKeyStrokesFromScout() {
        JComponent component = this.getSwingContainer();
        if (component == null) {
            component = this.getSwingField();
        }
        if (component != null) {
            if (this.m_installedScoutKs != null) {
                for (IKeyStroke scoutKs : this.m_installedScoutKs) {
                    KeyStroke swingKs = SwingUtility.createKeystroke(scoutKs);
                    InputMap imap = component.getInputMap(1);
                    imap.remove(swingKs);
                    ActionMap amap = component.getActionMap();
                    amap.remove(scoutKs.getActionId());
                }
            }
            this.m_installedScoutKs = null;
            List scoutKeyStrokes = ((ITree)this.getScoutObject()).getKeyStrokes();
            for (IKeyStroke scoutKs : scoutKeyStrokes) {
                int swingWhen = 1;
                KeyStroke swingKs = SwingUtility.createKeystroke(scoutKs);
                SwingScoutAction<IKeyStroke> action = new SwingScoutAction<IKeyStroke>();
                action.createField(scoutKs, this.getSwingEnvironment());
                InputMap imap = component.getInputMap(swingWhen);
                imap.put(swingKs, scoutKs.getActionId());
                ActionMap amap = component.getActionMap();
                amap.put(scoutKs.getActionId(), action.getSwingAction());
            }
            this.m_installedScoutKs = scoutKeyStrokes;
        }
    }

    protected void setSelectionFromSwing(TreePath[] paths) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            if (paths != null && paths.length > 0) {
                final List<ITreeNode> scoutNodes = SwingScoutTree.treePathsToScoutNodes(CollectionUtility.arrayList((Object[])paths));
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwingScoutTree.this.addIgnoredScoutEvent(TreeEvent.class, "40");
                            ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().setNodesSelectedFromUI(scoutNodes);
                        }
                        finally {
                            SwingScoutTree.this.removeIgnoredScoutEvent(TreeEvent.class, "40");
                        }
                    }
                };
                this.getSwingEnvironment().invokeScoutLater(t, 0L);
            } else {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwingScoutTree.this.addIgnoredScoutEvent(TreeEvent.class, "40");
                            ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().setNodesSelectedFromUI(null);
                        }
                        finally {
                            SwingScoutTree.this.removeIgnoredScoutEvent(TreeEvent.class, "40");
                        }
                    }
                };
                this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        }
    }

    protected void setScrollToSelectionFromScout() {
        if (((ITree)this.getScoutObject()).isScrollToSelection()) {
            this.scrollToSelection();
        }
    }

    protected void scrollToSelection() {
        int[] selectedRows = this.getSwingTree().getSelectionRows();
        if (selectedRows != null && selectedRows.length > 0) {
            int index = selectedRows[0];
            int rowCount = this.getSwingTree().getRowCount();
            if (index >= 0 && index < rowCount) {
                TreePath selectedPath = this.getSwingTree().getPathForRow(index);
                int nextIndex = index;
                while (nextIndex + 1 < rowCount) {
                    TreePath path = this.getSwingTree().getPathForRow(nextIndex + 1);
                    if (path.getPathCount() <= selectedPath.getPathCount()) break;
                    ++nextIndex;
                }
                if (nextIndex != index) {
                    this.getSwingTree().scrollRowToVisible(nextIndex);
                }
                this.getSwingTree().scrollRowToVisible(index);
            }
        }
    }

    protected void saveScrollbarValues() {
        if (this.getScoutObject() == null || !((ITree)this.getScoutObject()).isSaveAndRestoreScrollbars()) {
            return;
        }
        final int verticalValue = this.m_swingScrollPane.getVerticalScrollBar() != null ? this.m_swingScrollPane.getVerticalScrollBar().getValue() : 0;
        final int horizontalValue = this.m_swingScrollPane.getHorizontalScrollBar() != null ? this.m_swingScrollPane.getHorizontalScrollBar().getValue() : 0;
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ClientJob.getCurrentSession().setData(String.valueOf(Scrollbar.VERTICAL.getType()) + "_" + ((ITree)SwingScoutTree.this.getScoutObject()).toString(), (Object)verticalValue);
                ClientJob.getCurrentSession().setData(String.valueOf(Scrollbar.HORIZONTAL.getType()) + "_" + ((ITree)SwingScoutTree.this.getScoutObject()).toString(), (Object)horizontalValue);
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 1234L);
    }

    protected void restoreScrollbarValues() {
        if (this.getScoutObject() == null || !((ITree)this.getScoutObject()).isSaveAndRestoreScrollbars()) {
            return;
        }
        final AtomicReference scrollbarValues = new AtomicReference();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                Integer verticalValue = (Integer)ClientJob.getCurrentSession().getData(String.valueOf(Scrollbar.VERTICAL.getType()) + "_" + ((ITree)SwingScoutTree.this.getScoutObject()).toString());
                Integer horizontalValue = (Integer)ClientJob.getCurrentSession().getData(String.valueOf(Scrollbar.HORIZONTAL.getType()) + "_" + ((ITree)SwingScoutTree.this.getScoutObject()).toString());
                if (horizontalValue != null || verticalValue != null) {
                    scrollbarValues.set(new ScrollbarValues(horizontalValue, verticalValue));
                }
            }
        };
        try {
            this.getSwingEnvironment().invokeScoutLater(t, 1234L).join(1234L);
        }
        catch (InterruptedException e) {
            LOG.debug("exception occured while joining on model thread: " + e);
        }
        if (scrollbarValues.get() != null) {
            this.scrollToSelection();
            Integer horizontal = ((ScrollbarValues)scrollbarValues.get()).horizontal;
            Integer vertical = ((ScrollbarValues)scrollbarValues.get()).vertical;
            JScrollBar horizontalScrollBar = this.m_swingScrollPane.getHorizontalScrollBar();
            if (horizontal != null && horizontalScrollBar != null && horizontalScrollBar.isVisible()) {
                horizontalScrollBar.setValue(horizontal);
            }
            JScrollBar verticalScrollBar = this.m_swingScrollPane.getVerticalScrollBar();
            if (vertical != null && verticalScrollBar != null && verticalScrollBar.isVisible()) {
                verticalScrollBar.setValue(vertical);
            }
        }
    }

    @Override
    protected void handleScoutPropertyChange(String propName, Object newValue) {
        if (propName.equals("multiSelect")) {
            this.setMultiSelectFromScout((Boolean)newValue);
        } else if (propName.equals("rootNodeVisible")) {
            this.setRootNodeVisibleFromScout();
        } else if (propName.equals("rootHandlesVisible")) {
            this.setRootHandlesVisibleFromScout();
        } else if (propName.equals("keyStroks")) {
            this.setKeyStrokesFromScout();
        } else if (propName.equals("scrollToSelection")) {
            this.setScrollToSelectionFromScout();
        }
    }

    protected boolean isHandleScoutTreeEvent(List<? extends TreeEvent> events) {
        for (TreeEvent treeEvent : events) {
            switch (treeEvent.getType()) {
                case 10: 
                case 20: 
                case 30: 
                case 40: 
                case 50: 
                case 100: 
                case 101: 
                case 400: 
                case 800: 
                case 830: 
                case 850: {
                    return true;
                }
            }
        }
        return false;
    }

    protected void handleScoutTreeEventInSwing(TreeEvent e) {
        switch (e.getType()) {
            case 10: {
                this.updateTreeStructureAndKeepSelectionFromScout(e.getCommonParentNode());
                this.setExpansionFromScout(e.getCommonParentNode());
                break;
            }
            case 20: {
                this.updateTreeStructureAndKeepSelectionFromScout(e.getCommonParentNode());
                this.setExpansionFromScout(e.getCommonParentNode());
                break;
            }
            case 850: {
                this.updateTreeNode(e.getNode());
                break;
            }
            case 30: {
                this.updateTreeStructureAndKeepSelectionFromScout(e.getCommonParentNode());
                this.setExpansionFromScout(e.getCommonParentNode());
                break;
            }
            case 50: {
                this.updateTreeStructureAndKeepSelectionFromScout(e.getCommonParentNode());
                this.setExpansionFromScout(e.getCommonParentNode());
                break;
            }
            case 400: {
                this.updateTreeStructureAndKeepSelectionFromScout(((ITree)this.getScoutObject()).getRootNode());
                this.setExpansionFromScout(((ITree)this.getScoutObject()).getRootNode());
                break;
            }
            case 800: {
                this.getSwingTree().requestFocus();
                break;
            }
            case 100: 
            case 101: {
                this.setExpansionFromScout(e.getNode());
                break;
            }
            case 40: {
                this.setSelectionFromScout(e.getNodes());
                break;
            }
            case 830: {
                this.scrollToSelection();
            }
        }
    }

    protected void handleScoutTreeEventBatchInSwing(List<TreeEvent> eventList) {
        HashSet<ITreeNode> processedParentNodes = new HashSet<ITreeNode>();
        for (TreeEvent e : eventList) {
            ITreeNode parentNode = null;
            switch (e.getType()) {
                case 10: 
                case 20: 
                case 30: 
                case 50: {
                    parentNode = e.getCommonParentNode();
                    break;
                }
                case 400: {
                    parentNode = ((ITree)this.getScoutObject()).getRootNode();
                }
            }
            if (parentNode == null || processedParentNodes.contains(parentNode)) continue;
            processedParentNodes.add(parentNode);
            this.updateTreeStructureAndKeepSelectionFromScout(parentNode);
            this.setExpansionFromScout(parentNode);
        }
        for (TreeEvent e : eventList) {
            switch (e.getType()) {
                case 800: {
                    this.getSwingTree().requestFocus();
                    break;
                }
                case 100: 
                case 101: {
                    this.setExpansionFromScout(e.getNode());
                    break;
                }
                case 40: {
                    this.setSelectionFromScout(e.getNodes());
                    break;
                }
                case 830: {
                    this.scrollToSelection();
                    break;
                }
                case 850: {
                    this.updateTreeNode(e.getNode());
                }
            }
        }
    }

    protected void updateTreeNode(ITreeNode node) {
        if (this.getScoutObject() != null) {
            SwingTreeModel swingTreeModel = (SwingTreeModel)this.getSwingTree().getModel();
            swingTreeModel.updateNode(node);
        }
    }

    private void updateTreeStructureAndKeepSelectionFromScout(ITreeNode node) {
        if (this.getScoutObject() != null) {
            SwingTreeModel swingTreeModel = (SwingTreeModel)this.getSwingTree().getModel();
            swingTreeModel.fireStructureChanged(node);
            List<TreePath> paths = SwingScoutTree.scoutNodesToTreePaths(((ITree)this.getScoutObject()).getSelectedNodes());
            this.getSwingTree().setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
        }
    }

    protected Transferable handleSwingDragRequest() {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return null;
        }
        final Holder result = new Holder(TransferObject.class, null);
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().fireNodesDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            try {
                this.getSwingEnvironment().invokeScoutLater(t, 20000L).join(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        TransferObject scoutTransferable = (TransferObject)result.getValue();
        Transferable swingTransferable = SwingUtility.createSwingTransferable(scoutTransferable);
        return swingTransferable;
    }

    protected void handleSwingDropAction(TreePath path, Transferable swingTransferable) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (swingTransferable != null && this.getScoutObject() != null) {
            final ITreeNode scoutNode = SwingScoutTree.treePathToScoutNode(path);
            final TransferObject scoutTransferable = SwingUtility.createScoutTransferable(swingTransferable);
            if (scoutTransferable != null) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().fireNodeDropActionFromUI(scoutNode, scoutTransferable);
                    }
                };
                this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        }
    }

    protected void handleSwingDropTargetChanged(TreePath path, Transferable swingTransferable) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (swingTransferable != null && this.getScoutObject() != null) {
            final ITreeNode scoutNode = SwingScoutTree.treePathToScoutNode(path);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().fireNodeDropTargetChangedFromUI(scoutNode);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleSwingDragFinished() {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().fireDragFinishedFromUI();
            }
        };
        this.getSwingEnvironment().invokeScoutLater(t, 0L);
    }

    protected void handleSwingNodePopup(final MouseEvent e) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            this.ensurePathSelected(path);
            final ITreeNode node = path != null ? (ITreeNode)path.getLastPathComponent() : null;
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    List scoutMenus = node != null ? ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().fireNodePopupFromUI() : ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().fireEmptySpacePopupFromUI();
                    new SwingPopupWorker(SwingScoutTree.this.getSwingEnvironment(), e.getComponent(), null, e.getPoint(), scoutMenus, false).enqueue();
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 5678L);
        }
    }

    protected void handleSwingNodeClick(TreePath path) {
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            this.ensurePathSelected(path);
            final ITreeNode scoutNode = SwingScoutTree.treePathToScoutNode(path);
            if (scoutNode != null) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().fireNodeClickFromUI(scoutNode);
                    }
                };
                this.getSwingEnvironment().invokeScoutLater(t, 0L);
            }
        }
    }

    private void ensurePathSelected(TreePath path) {
        if (path != null && !this.getSwingTree().isPathSelected(path)) {
            this.getSwingTree().setSelectionPath(path);
        }
    }

    private TreePath getPathForLocation(int x, int y) {
        TreePath closestPath = this.getSwingTree().getClosestPathForLocation(x, y);
        Rectangle pathBounds = this.getSwingTree().getPathBounds(closestPath);
        TreePath path = null;
        if (closestPath != null && pathBounds != null && pathBounds.contains(pathBounds.x, y)) {
            path = closestPath;
        }
        return path;
    }

    protected void handleSwingNodeAction(TreePath path) {
        ITreeNode scoutNode;
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null && (scoutNode = SwingScoutTree.treePathToScoutNode(path)) != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().fireNodeActionFromUI(scoutNode);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 400L);
        }
    }

    protected void handleSwingHyperlinkAction(TreePath path, final URL url) {
        ITreeNode scoutNode;
        if (this.getUpdateSwingFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null && path != null && (scoutNode = SwingScoutTree.treePathToScoutNode(path)) != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITree)SwingScoutTree.this.getScoutObject()).getUIFacade().fireHyperlinkActionFromUI(scoutNode, url);
                }
            };
            this.getSwingEnvironment().invokeScoutLater(t, 0L);
        }
    }

    public static ITreeNode treePathToScoutNode(TreePath path) {
        if (path == null) {
            return null;
        }
        return (ITreeNode)path.getLastPathComponent();
    }

    public static List<ITreeNode> treePathsToScoutNodes(Collection<? extends TreePath> paths) {
        if (!CollectionUtility.hasElements(paths)) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList<ITreeNode> scoutNodes = new ArrayList<ITreeNode>(paths.size());
        for (TreePath treePath : paths) {
            scoutNodes.add(SwingScoutTree.treePathToScoutNode(treePath));
        }
        return scoutNodes;
    }

    public static TreePath scoutNodeToTreePath(ITreeNode scoutNode) {
        if (scoutNode == null) {
            return null;
        }
        Object[] path = SwingScoutTree.getPathToRoot(scoutNode, 0);
        return new TreePath(path);
    }

    public static List<TreePath> scoutNodesToTreePaths(Collection<? extends ITreeNode> scoutNodes) {
        if (!CollectionUtility.hasElements(scoutNodes)) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList<TreePath> paths = new ArrayList<TreePath>(scoutNodes.size());
        for (ITreeNode iTreeNode : scoutNodes) {
            paths.add(SwingScoutTree.scoutNodeToTreePath(iTreeNode));
        }
        return paths;
    }

    public static ITreeNode[] getPathToRoot(ITreeNode scoutNode, int depth) {
        ITreeNode[] retNodes;
        if (scoutNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new ITreeNode[depth];
        } else {
            retNodes = scoutNode.getParentNode() == null ? new ITreeNode[depth] : SwingScoutTree.getPathToRoot(scoutNode.getParentNode(), ++depth);
            retNodes[retNodes.length - depth] = scoutNode;
        }
        return retNodes;
    }

    private class P_DropTargetListener
    extends DropTargetAdapter {
        private static final long serialVersionUID = 1L;

        private P_DropTargetListener() {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            DataFlavor[] currentFlavors = dtde.getCurrentDataFlavors();
            JComponent jcomponent = (JComponent)dtde.getDropTargetContext().getComponent();
            TransferHandler transferHandler = jcomponent.getTransferHandler();
            if (transferHandler != null && transferHandler.canImport(jcomponent, currentFlavors)) {
                Point location = dtde.getLocation();
                TreePath path = SwingScoutTree.this.getSwingTree().getPathForLocation(location.x, location.y);
                Transferable t = dtde.getTransferable();
                SwingScoutTree.this.handleSwingDropTargetChanged(path, t);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
        }
    }

    private class P_ScoutTreeListener
    implements TreeListener {
        private P_ScoutTreeListener() {
        }

        public void treeChanged(final TreeEvent e) {
            if (SwingScoutTree.this.isHandleScoutTreeEvent(CollectionUtility.arrayList((Object)e))) {
                if (SwingScoutTree.this.isIgnoredScoutEvent(TreeEvent.class, "" + e.getType())) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwingScoutTree.this.getUpdateSwingFromScoutLock().acquire();
                            SwingScoutTree.this.handleScoutTreeEventInSwing(e);
                        }
                        finally {
                            SwingScoutTree.this.getUpdateSwingFromScoutLock().release();
                        }
                    }
                };
                SwingScoutTree.this.getSwingEnvironment().invokeSwingLater(t);
            }
        }

        public void treeChangedBatch(List<? extends TreeEvent> a) {
            if (SwingScoutTree.this.isHandleScoutTreeEvent(a)) {
                final ArrayList<TreeEvent> filteredList = new ArrayList<TreeEvent>();
                for (TreeEvent treeEvent : a) {
                    if (SwingScoutTree.this.isIgnoredScoutEvent(TreeEvent.class, "" + treeEvent.getType())) continue;
                    filteredList.add(treeEvent);
                }
                if (CollectionUtility.hasElements(filteredList)) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwingScoutTree.this.getUpdateSwingFromScoutLock().acquire();
                                SwingScoutTree.this.handleScoutTreeEventBatchInSwing(filteredList);
                            }
                            finally {
                                SwingScoutTree.this.getUpdateSwingFromScoutLock().release();
                            }
                        }
                    };
                    SwingScoutTree.this.getSwingEnvironment().invokeSwingLater(runnable);
                }
            }
        }
    }

    private class P_SwingDragAndDropTransferHandler
    extends TransferHandlerEx {
        private static final long serialVersionUID = 1L;

        private P_SwingDragAndDropTransferHandler() {
        }

        @Override
        public boolean canDrag() {
            return ((ITree)SwingScoutTree.this.getScoutObject()).isDragEnabled();
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            TreePath[] paths = SwingScoutTree.this.getSwingTree().getSelectionPaths();
            if (paths != null && paths.length > 0) {
                return SwingScoutTree.this.handleSwingDragRequest();
            }
            return null;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return SwingUtility.isSupportedTransfer(((ITree)SwingScoutTree.this.getScoutObject()).getDropType(), transferFlavors);
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            super.exportDone(source, data, action);
            SwingScoutTree.this.handleSwingDragFinished();
        }

        @Override
        public boolean importDataEx(JComponent comp, Transferable t, Point location) {
            if (location != null) {
                TreePath dropPath = SwingScoutTree.this.getSwingTree().getPathForLocation(location.x, location.y);
                SwingScoutTree.this.handleSwingDropAction(dropPath, t);
                return true;
            }
            return false;
        }
    }

    private class P_SwingExpansionListener
    implements TreeExpansionListener {
        private P_SwingExpansionListener() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            if (path != null) {
                SwingScoutTree.this.setExpansionFromSwing(path, false);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            TreePath path = e.getPath();
            if (path != null) {
                SwingScoutTree.this.setExpansionFromSwing(path, true);
            }
        }
    }

    private class P_SwingMouseListener
    extends MouseAdapter {
        private Point m_pressedLocation;
        MouseClickedBugFix fix;

        private P_SwingMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.fix = new MouseClickedBugFix(e);
            this.m_pressedLocation = e.getPoint();
            e.getComponent().requestFocus();
            if (e.isMetaDown()) {
                TreePath path = SwingScoutTree.this.getPathForLocation(e.getPoint().x, e.getPoint().y);
                SwingScoutTree.this.ensurePathSelected(path);
            }
            if (e.isPopupTrigger()) {
                SwingScoutTree.this.handleSwingNodePopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SwingScoutTree.this.handleSwingNodePopup(e);
            } else {
                TreeHtmlLinkDetector detector = new TreeHtmlLinkDetector();
                if (detector.detect((JTree)e.getComponent(), e.getPoint())) {
                    SwingScoutTree.this.handleSwingHyperlinkAction(detector.getTreePath(), detector.getHyperlink());
                }
            }
            if (this.fix != null) {
                this.fix.mouseReleased(this, e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.fix.mouseClicked()) {
                return;
            }
            if (e.getButton() == 1) {
                TreePath path;
                if (e.getClickCount() == 1) {
                    TreePath path2 = SwingScoutTree.this.getPathForLocation(this.m_pressedLocation.x, this.m_pressedLocation.y);
                    if (path2 != null && e.getPoint().x >= SwingScoutTree.this.getSwingTree().getPathBounds((TreePath)path2).x) {
                        SwingScoutTree.this.handleSwingNodeClick(path2);
                    }
                } else if (e.getClickCount() == 2 && (path = SwingScoutTree.this.getPathForLocation(this.m_pressedLocation.x, this.m_pressedLocation.y)) != null) {
                    Rectangle pathBounds = SwingScoutTree.this.getSwingTree().getPathBounds(path);
                    if (this.m_pressedLocation.x > pathBounds.x + pathBounds.width) {
                        SwingScoutTree.this.getSwingTree().toggleExpandState(path);
                    }
                    SwingScoutTree.this.handleSwingNodeAction(path);
                }
            }
        }
    }

    private class P_SwingSelectionListener
    implements TreeSelectionListener {
        private P_SwingSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            SwingScoutTree.this.setSelectionFromSwing(SwingScoutTree.this.getSwingTree().getSelectionPaths());
        }
    }

    private static enum Scrollbar {
        HORIZONTAL("HORIZONTAL_SCROLLBAR"),
        VERTICAL("VERTICAL_SCROLLBAR");

        private final String m_scrollbarType;

        private Scrollbar(String scrollbarType) {
            this.m_scrollbarType = scrollbarType;
        }

        public String getType() {
            return this.m_scrollbarType;
        }
    }

    private static class ScrollbarValues {
        protected final Integer horizontal;
        protected final Integer vertical;

        public ScrollbarValues(Integer horizontal, Integer vertical) {
            this.horizontal = horizontal;
            this.vertical = vertical;
        }
    }
}

