/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.dnd.DefaultDropTarget;
import org.eclipse.scout.rt.ui.swing.ext.DynamicRowHeightCache;
import org.eclipse.scout.rt.ui.swing.ext.JTableHeaderEx;

public class JTableEx
extends JTable {
    private static final long serialVersionUID = 1L;
    private TableModelListener m_tableModelListener;
    private TableColumnModelListener m_tableColumnModelListener;
    private boolean m_dynamicRowHeight = false;
    private DynamicRowHeightCache m_dynamicRowHeightCache;

    public JTableEx() {
        int rowHeight;
        if (UIManager.get("Table.rowHeight") != null && (rowHeight = UIManager.getInt("Table.rowHeight")) > 0) {
            this.setRowHeight(rowHeight);
        }
        this.setTableHeader(new JTableHeaderEx());
        if (UIManager.get("Table.showGrid") != null) {
            this.setShowGrid(UIManager.getBoolean("Table.showGrid"));
        }
        if (UIManager.get("Table.showHorizontalLines") != null) {
            this.setShowHorizontalLines(UIManager.getBoolean("Table.showHorizontalLines"));
        }
        if (UIManager.get("Table.showVerticalLines") != null) {
            this.setShowVerticalLines(UIManager.getBoolean("Table.showVerticalLines"));
        }
        this.adjustFocusHandling();
        this.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "no-event");
        this.getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "no-event");
        this.setVerifyInputWhenFocusTarget(true);
        this.setAutoscrolls(true);
        this.setAutoResizeMode(0);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.setOpaque(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.m_tableColumnModelListener = new P_TableColumnModelListener();
        this.getColumnModel().addColumnModelListener(this.m_tableColumnModelListener);
        this.getInputMap(1).put(KeyStroke.getKeyStroke("HOME"), "selectFirstRow");
        this.getInputMap(1).put(KeyStroke.getKeyStroke("END"), "selectLastRow");
        this.addFocusListener(new P_FocusListener());
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (c instanceof JLabel) {
            JLabel label = (JLabel)c;
            if (this.isDynamicRowHeight()) {
                label.setVerticalAlignment(1);
                label.setVerticalTextPosition(1);
            } else {
                label.setVerticalAlignment(0);
                label.setVerticalTextPosition(0);
            }
        }
        return c;
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        int oldAnchor = this.getSelectionModel().getAnchorSelectionIndex();
        int oldLead = this.getSelectionModel().getLeadSelectionIndex();
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        this.repaintFocusRow(oldAnchor, oldLead);
        this.repaintFocusRow(this.getSelectionModel().getAnchorSelectionIndex(), this.getSelectionModel().getLeadSelectionIndex());
    }

    protected void adjustFocusHandling() {
        SwingUtility.installDefaultFocusHandling(this);
        this.setFocusable(true);
        this.setFocusCycleRoot(false);
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        if (this.getToolTipText(event) != null) {
            return new Point(event.getX() + 4, event.getY() + 16);
        }
        return null;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        if (text == null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    @Override
    public void setModel(TableModel newModel) {
        TableModel oldModel = this.getModel();
        super.setModel(newModel);
        if (oldModel != newModel) {
            if (oldModel != null && this.m_tableModelListener != null) {
                oldModel.removeTableModelListener(this.m_tableModelListener);
            }
            this.m_tableModelListener = null;
            if (newModel != null) {
                if (this.m_tableModelListener == null) {
                    this.m_tableModelListener = new P_TableModelListener();
                }
                newModel.addTableModelListener(this.m_tableModelListener);
            }
        }
        this.m_dynamicRowHeightCache = this.isDynamicRowHeight() ? new DynamicRowHeightCache(this) : null;
    }

    @Override
    public void setColumnModel(TableColumnModel newModel) {
        TableColumnModel oldModel = this.getColumnModel();
        super.setColumnModel(newModel);
        if (oldModel != newModel) {
            if (oldModel != null && this.m_tableColumnModelListener != null) {
                oldModel.removeColumnModelListener(this.m_tableColumnModelListener);
            }
            this.m_tableColumnModelListener = null;
            if (newModel != null) {
                if (this.m_tableColumnModelListener == null) {
                    this.m_tableColumnModelListener = new P_TableColumnModelListener();
                }
                newModel.addColumnModelListener(this.m_tableColumnModelListener);
                JTableHeader header = this.getTableHeader();
                if (header instanceof JTableHeaderEx) {
                    ((JTableHeaderEx)header).updatePreferredHeight();
                }
            }
        }
    }

    public void setDynamicRowHeight(boolean b) {
        if (this.m_dynamicRowHeight != b) {
            this.m_dynamicRowHeight = b;
            this.m_dynamicRowHeightCache = this.m_dynamicRowHeight ? new DynamicRowHeightCache(this) : null;
            this.resizeAndRepaint();
        }
    }

    public boolean isDynamicRowHeight() {
        return this.m_dynamicRowHeight;
    }

    @Override
    public void setRowHeight(int height) {
        this.m_dynamicRowHeightCache = this.isDynamicRowHeight() ? new DynamicRowHeightCache(this, height) : null;
        super.setRowHeight(height);
    }

    @Override
    public void setRowHeight(int row, int height) {
        if (!this.isDynamicRowHeight()) {
            super.setRowHeight(row, height);
        }
    }

    @Override
    public int getRowHeight(int row) {
        if (this.isDynamicRowHeight()) {
            return this.m_dynamicRowHeightCache.getRowHeight(row);
        }
        return super.getRowHeight(row);
    }

    public Dimension getPreferredContentSize(int maxRowCount) {
        Dimension max = new Dimension();
        int r = 0;
        int nr = this.getRowCount();
        while (r < nr && r < maxRowCount) {
            int w = 0;
            int h = 0;
            int c = 0;
            int nc = this.getColumnCount();
            while (c < nc) {
                TableCellRenderer renderer = this.getCellRenderer(r, c);
                JComponent comp = (JComponent)this.prepareRenderer(renderer, r, c);
                comp.setSize(Integer.MAX_VALUE, Integer.MAX_VALUE);
                Dimension d = comp.getPreferredSize();
                w += d.width;
                h = Math.max(h, d.height);
                ++c;
            }
            h = Math.max(h, this.getRowHeight(r));
            max.height += h;
            max.width = Math.max(max.width, w);
            ++r;
        }
        return max;
    }

    @Override
    public int rowAtPoint(Point p) {
        if (this.isDynamicRowHeight()) {
            return this.m_dynamicRowHeightCache.getRowAtPoint(p);
        }
        return super.rowAtPoint(p);
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle r = super.getCellRect(row, column, includeSpacing);
        if (this.isDynamicRowHeight()) {
            r.y = this.m_dynamicRowHeightCache.getPointForRow(row);
            if (r.height > 0 && !includeSpacing) {
                r.y += this.getRowMargin() / 2;
            }
        }
        return r;
    }

    protected void repaintFocusRow(int anchor, int lead) {
        int r = anchor;
        if (r < 0) {
            r = lead;
        }
        if (r >= 0) {
            Rectangle rect1 = this.getCellRect(r, 0, false);
            Rectangle rectn = this.getCellRect(r, this.getColumnCount() - 1, false);
            this.repaint(rect1.union(rectn));
        }
    }

    @Override
    public void setTransferHandler(TransferHandler newHandler) {
        TransferHandler oldHandler = (TransferHandler)this.getClientProperty("TransferHandler");
        this.putClientProperty("TransferHandler", newHandler);
        DropTarget dropHandler = this.getDropTarget();
        if (dropHandler == null || dropHandler instanceof UIResource) {
            if (newHandler == null) {
                this.setDropTarget(null);
            } else if (!GraphicsEnvironment.isHeadless()) {
                this.setDropTarget(new DefaultDropTarget(this));
            }
        }
        this.firePropertyChange("transferHandler", oldHandler, newHandler);
    }

    @Override
    public TransferHandler getTransferHandler() {
        return (TransferHandler)this.getClientProperty("TransferHandler");
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.getModel().isCellEditable(row, column);
    }

    private class P_FocusListener
    extends FocusAdapter {
        private P_FocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JTableEx.this.repaintFocusRow(JTableEx.this.getSelectionModel().getAnchorSelectionIndex(), JTableEx.this.getSelectionModel().getLeadSelectionIndex());
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTableEx.this.repaintFocusRow(JTableEx.this.getSelectionModel().getAnchorSelectionIndex(), JTableEx.this.getSelectionModel().getLeadSelectionIndex());
        }
    }

    private class P_TableColumnModelListener
    implements TableColumnModelListener {
        private P_TableColumnModelListener() {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            JTableHeader header = JTableEx.this.getTableHeader();
            if (header instanceof JTableHeaderEx) {
                ((JTableHeaderEx)header).updatePreferredHeight();
            }
            if (JTableEx.this.isDynamicRowHeight()) {
                JTableEx.this.m_dynamicRowHeightCache = new DynamicRowHeightCache(JTableEx.this);
                JTableEx.this.resizeAndRepaint();
            } else {
                JTableEx.this.m_dynamicRowHeightCache = null;
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }
    }

    private class P_TableModelListener
    implements TableModelListener {
        private P_TableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            JTableHeader header = JTableEx.this.getTableHeader();
            if (header instanceof JTableHeaderEx) {
                ((JTableHeaderEx)header).updatePreferredHeight();
            }
            if (JTableEx.this.isDynamicRowHeight()) {
                JTableEx.this.m_dynamicRowHeightCache = new DynamicRowHeightCache(JTableEx.this);
                JTableEx.this.resizeAndRepaint();
            } else {
                JTableEx.this.m_dynamicRowHeightCache = null;
            }
        }
    }
}

