/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.border.Border;

public class ScrollPaneLayoutEx
extends ScrollPaneLayout {
    private static final long serialVersionUID = 1L;

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Border borderOfViewport;
        super.preferredLayoutSize(parent);
        JScrollPane spParent = (JScrollPane)parent;
        Insets insets = parent.getInsets();
        int prefW = insets.left + insets.right;
        int prefH = insets.top + insets.bottom;
        Dimension sizeOfExtent = null;
        Dimension sizeOfView = null;
        Component viewComponent = null;
        if (this.viewport != null) {
            sizeOfExtent = this.viewport.getExtentSize();
            sizeOfView = this.viewport.getPreferredSize();
            viewComponent = this.viewport.getView();
        }
        if (sizeOfView != null) {
            prefW += sizeOfView.width;
            prefH += sizeOfView.height;
        }
        if ((borderOfViewport = spParent.getViewportBorder()) != null) {
            Insets localInsets = borderOfViewport.getBorderInsets(parent);
            prefW += localInsets.left + localInsets.right;
            prefH += localInsets.top + localInsets.bottom;
        }
        if (this.rowHead != null && this.rowHead.isVisible()) {
            prefW += this.rowHead.getPreferredSize().width;
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            prefH += this.colHead.getPreferredSize().height;
        }
        if (this.vsb != null && this.vsbPolicy != 21) {
            if (this.vsbPolicy == 22) {
                prefW += this.vsb.getPreferredSize().width;
            } else if (sizeOfView != null && sizeOfExtent != null) {
                boolean scrollEnabled = true;
                if (viewComponent instanceof Scrollable) {
                    boolean bl = scrollEnabled = !((Scrollable)((Object)viewComponent)).getScrollableTracksViewportHeight();
                }
                if (scrollEnabled && sizeOfView.height > sizeOfExtent.height) {
                    prefW += this.vsb.getPreferredSize().width;
                }
            }
        }
        if (this.hsb != null && this.hsbPolicy != 31) {
            if (this.hsbPolicy == 32) {
                prefH += this.hsb.getPreferredSize().height;
            } else if (sizeOfView != null && sizeOfExtent != null) {
                boolean scrollEnabled = true;
                if (viewComponent instanceof Scrollable) {
                    boolean bl = scrollEnabled = !((Scrollable)((Object)viewComponent)).getScrollableTracksViewportWidth();
                }
                if (scrollEnabled && sizeOfView.width > sizeOfExtent.width) {
                    prefH += this.hsb.getPreferredSize().height;
                }
            }
        }
        return new Dimension(prefW, prefH);
    }
}

