/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.decoration;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.ext.decoration.AbstractDecorationItem;

public class DropDownDecorationItem
extends AbstractDecorationItem {
    private IconGroup m_iconGroup = new IconGroup();

    public DropDownDecorationItem(JComponent owner, ISwingEnvironment environment) {
        super(owner, environment, true);
        this.setMouseOverCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    protected void init() {
        super.init();
        this.m_iconGroup = new IconGroup(this.getEnvironment(), "smartfield_browse");
    }

    @Override
    protected Rectangle paintInternal(Component c, Graphics g, int x, int y) {
        if (!this.isVisible()) {
            return NULL_RECTANGLE;
        }
        int xx = x;
        int yy = y;
        int width = this.getWidth();
        int height = this.getHeight();
        if (c.getHeight() > height) {
            yy = y;
        }
        this.getIconForState().paintIcon(c, g, xx, yy);
        return new Rectangle(xx, yy, width, height);
    }

    @Override
    public int getWidth() {
        if (!this.isVisible()) {
            return 0;
        }
        Icon icon = this.getIconForState();
        if (icon == null) {
            return 0;
        }
        return icon.getIconWidth();
    }

    @Override
    public int getHeight() {
        if (!this.isVisible()) {
            return 0;
        }
        Icon icon = this.getIconForState();
        if (icon == null) {
            return 0;
        }
        return icon.getIconHeight();
    }

    public void setIconGroup(IconGroup iconGroup) {
        this.m_iconGroup = iconGroup == null ? new IconGroup(this.getEnvironment(), "smartfield_browse") : iconGroup;
    }

    private Icon getIconForState() {
        IconGroup.IconState iconState;
        switch (this.getState()) {
            case Disabled: {
                iconState = IconGroup.IconState.DISABLED;
                break;
            }
            case Rollover: {
                iconState = IconGroup.IconState.ROLLOVER;
                break;
            }
            case Selected: {
                iconState = IconGroup.IconState.SELECTED;
                break;
            }
            default: {
                iconState = IconGroup.IconState.NORMAL;
            }
        }
        return this.m_iconGroup.getIcon(iconState);
    }
}

