/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.ext.decoration;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import org.eclipse.scout.rt.ui.swing.ext.JTextFieldEx;
import org.eclipse.scout.rt.ui.swing.ext.MouseClickedBugFix;
import org.eclipse.scout.rt.ui.swing.ext.decoration.DecorationMouseEvent;
import org.eclipse.scout.rt.ui.swing.ext.decoration.IDecoration;

public class JTextFieldWithDecorationIcons
extends JTextFieldEx {
    private static final long serialVersionUID = 1L;
    private IDecoration m_decorationIcon;
    private int m_originalMarginRight = -1;
    private int m_insetsRight = 0;
    private Cursor m_defaultCursor;

    public JTextFieldWithDecorationIcons() {
        this.registerMouseMotionListener();
        this.m_defaultCursor = this.getCursor();
    }

    @Override
    public void paint(Graphics g) {
        this.setTextFieldMargin();
        super.paint(g);
        if (this.m_decorationIcon != null) {
            int x = this.getWidth() - this.m_decorationIcon.getWidth() - 6;
            int y = (this.getHeight() - this.m_decorationIcon.getHeight()) / 2;
            this.m_decorationIcon.paint(this, g, x, y);
        }
    }

    public void setDecorationIcon(IDecoration decorationIcon) {
        this.m_decorationIcon = decorationIcon;
        this.setTextFieldMargin();
    }

    public IDecoration getDecorationIcon() {
        return this.m_decorationIcon;
    }

    private void registerMouseMotionListener() {
        this.addMouseListener(new MouseAdapter(){
            MouseClickedBugFix fix;

            @Override
            public void mouseExited(MouseEvent e) {
                JTextFieldWithDecorationIcons.this.handleDecorationMouseExit(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.fix = new MouseClickedBugFix(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.fix != null) {
                    this.fix.mouseReleased(this, e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (this.fix != null && this.fix.mouseClicked()) {
                    return;
                }
                if (JTextFieldWithDecorationIcons.this.isDecorationIconRegion(e.getPoint())) {
                    JTextFieldWithDecorationIcons.this.getDecorationIcon().handleMouseChlicked(e);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JTextFieldWithDecorationIcons.this.handleDecorationMouseMoved(e);
            }
        });
    }

    protected void handleDecorationMouseExit(MouseEvent e) {
        if (this.getDecorationIcon() != null) {
            DecorationMouseEvent ex = new DecorationMouseEvent(e);
            this.getDecorationIcon().handleMouseExit(ex);
            this.processChangesFromDecoration(ex);
        }
    }

    protected void handleDecorationMouseMoved(MouseEvent e) {
        if (this.getDecorationIcon() != null) {
            DecorationMouseEvent ex = new DecorationMouseEvent(e);
            this.getDecorationIcon().handleMouseMoved(ex);
            this.processChangesFromDecoration(ex);
        }
    }

    protected void processChangesFromDecoration(DecorationMouseEvent ex) {
        Cursor newCursor = ex.getCursorToApply();
        if (this.getCursor() != newCursor) {
            if (newCursor == null) {
                newCursor = this.m_defaultCursor;
            }
            this.setCursor(newCursor);
        }
        if (ex.isRepaintNeeded()) {
            this.repaint();
        }
    }

    public boolean isDecorationIconRegion(Point cursorPosition) {
        if (this.getDecorationIcon() == null) {
            return false;
        }
        return cursorPosition.x >= this.getWidth() - this.getDecorationIcon().getWidth() - this.m_insetsRight;
    }

    private void setTextFieldMargin() {
        Insets marginAndBorderInsets = this.getInsets();
        Insets marginInsets = this.getMargin();
        if (this.m_originalMarginRight == -1) {
            this.m_originalMarginRight = marginInsets.right;
        }
        this.m_insetsRight = marginAndBorderInsets.right - marginInsets.right;
        int iconWidth = 0;
        if (this.getDecorationIcon() != null) {
            iconWidth = this.getDecorationIcon().getWidth();
        }
        this.setMargin(new Insets(0, 0, 0, this.m_originalMarginRight + iconWidth));
    }
}

