/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.ValueFieldEvent;
import org.eclipse.scout.rt.client.ui.form.fields.ValueFieldListener;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutFieldComposite;

public abstract class SwingScoutValueFieldComposite<T extends IValueField<?>>
extends SwingScoutFieldComposite<T> {
    private ValueFieldListener m_valueFieldListener;
    private boolean m_menuOpened;

    @Override
    protected void attachScout() {
        super.attachScout();
        IValueField f = (IValueField)this.getScoutObject();
        this.setValueFromScout(f.getValue());
        this.setDisplayTextFromScout(f.getDisplayText());
        this.updateContextMenuFromScout();
        this.m_valueFieldListener = new P_ValueFieldListener();
        f.addValueFieldListener(this.m_valueFieldListener);
    }

    @Override
    protected void detachScout() {
        ((IValueField)this.getScoutObject()).removeValueFieldListener(this.m_valueFieldListener);
        this.m_valueFieldListener = null;
        super.detachScout();
    }

    protected void valueFieldChangedFromScout(ValueFieldEvent<?> event) {
        Runnable r = null;
        switch (event.getType()) {
            case 200: {
                r = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutValueFieldComposite.this.handleCopy();
                    }
                };
                break;
            }
            case 300: {
                r = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutValueFieldComposite.this.handlePaste();
                    }
                };
                break;
            }
            case 100: {
                r = new Runnable(){

                    @Override
                    public void run() {
                        SwingScoutValueFieldComposite.this.handleCut();
                    }
                };
            }
        }
        if (r != null) {
            this.getSwingEnvironment().invokeSwingLater(r);
        }
    }

    protected void setValueFromScout(Object o) {
    }

    protected void setDisplayTextFromScout(String s) {
    }

    protected void updateContextMenuFromScout() {
    }

    protected void handleCopy() {
        JComponent swingField = this.getSwingField();
        if (swingField instanceof JTextComponent) {
            JTextComponent txt = (JTextComponent)swingField;
            if (txt.isEnabled() && txt.isEditable()) {
                txt.copy();
            } else {
                boolean hasSelection = StringUtility.hasText((String)txt.getSelectedText());
                if (hasSelection) {
                    txt.copy();
                } else {
                    txt.selectAll();
                    txt.copy();
                    txt.select(0, 0);
                }
            }
        }
    }

    protected void handleCut() {
        JComponent swingField = this.getSwingField();
        if (swingField instanceof JTextComponent) {
            ((JTextComponent)swingField).cut();
        }
    }

    protected void handlePaste() {
        JComponent swingField = this.getSwingField();
        if (swingField instanceof JTextComponent) {
            ((JTextComponent)swingField).paste();
        }
    }

    protected void setDisabledTextColor(Color c, JTextComponent fld) {
        if (fld != null) {
            c = c == null ? fld.getDisabledTextColor() : this.getDisabledColor(c);
            fld.setDisabledTextColor(c);
        }
    }

    @Override
    protected void setSwingField(JComponent swingField) {
        super.setSwingField(swingField);
    }

    protected Color getDisabledColor(Color origColor) {
        Color w = Color.white;
        Color cLight = new Color((origColor.getRed() * 2 + w.getRed()) / 3, (origColor.getGreen() * 2 + w.getGreen()) / 3, (origColor.getBlue() * 2 + w.getBlue()) / 3);
        return cLight;
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("value")) {
            this.setValueFromScout(newValue);
        } else if (name.equals("displayText")) {
            this.setDisplayTextFromScout((String)newValue);
        } else if (name.equals("contextMenu")) {
            this.updateContextMenuFromScout();
        }
    }

    protected boolean isMenuOpened() {
        return this.m_menuOpened;
    }

    protected void setMenuOpened(boolean menuOpened) {
        this.m_menuOpened = menuOpened;
    }

    private final class P_ValueFieldListener
    implements ValueFieldListener {
        private P_ValueFieldListener() {
        }

        public void valueFieldChanged(ValueFieldEvent event) throws ProcessingException {
            SwingScoutValueFieldComposite.this.valueFieldChangedFromScout(event);
        }
    }
}

