/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.button;

import javax.swing.JComponent;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.IRadioButton;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.extension.IFormFieldFactory;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.button.SwingScoutButton;
import org.eclipse.scout.rt.ui.swing.form.fields.button.SwingScoutLink;
import org.eclipse.scout.rt.ui.swing.form.fields.button.SwingScoutRadioButton;

public class ButtonFactory
implements IFormFieldFactory {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ButtonFactory.class);

    @Override
    public ISwingScoutFormField<?> createFormField(JComponent parent, IFormField field, ISwingEnvironment environment) {
        if (field instanceof IRadioButton) {
            IRadioButton scoutField = (IRadioButton)field;
            SwingScoutRadioButton uiField = new SwingScoutRadioButton();
            uiField.createField(scoutField, environment);
            return uiField;
        }
        if (field instanceof IButton) {
            IButton scoutField = (IButton)field;
            switch (scoutField.getDisplayStyle()) {
                case 1: {
                    SwingScoutButton<IButton> uiField = new SwingScoutButton<IButton>();
                    uiField.createField(scoutField, environment);
                    return uiField;
                }
                case 2: {
                    LOG.warn("It seems your RadioButton extends from AbstractButton with getConfiguredDisplayStyle set to DISPLAY_STYLE_RADIO. Please use the class AbstractRadioButton instead.");
                    SwingScoutButton<IButton> uiField = new SwingScoutButton<IButton>();
                    uiField.createField(scoutField, environment);
                    return uiField;
                }
                case 3: {
                    SwingScoutLink uiField = new SwingScoutLink();
                    uiField.createField(scoutField, environment);
                    return uiField;
                }
            }
            SwingScoutButton<IButton> uiField = new SwingScoutButton<IButton>();
            uiField.createField(scoutField, environment);
            return uiField;
        }
        return null;
    }
}

