/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.colorpickerfield;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.ColorUtility;
import org.eclipse.scout.commons.RunnableWithData;
import org.eclipse.scout.rt.client.ui.form.fields.colorpickerfield.IColorField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.ui.swing.LogicalGridData;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.menu.SwingScoutContextMenu;
import org.eclipse.scout.rt.ui.swing.basic.IconGroup;
import org.eclipse.scout.rt.ui.swing.basic.document.BasicDocumentFilter;
import org.eclipse.scout.rt.ui.swing.ext.BorderLayoutEx;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.decoration.ContextMenuDecorationItem;
import org.eclipse.scout.rt.ui.swing.ext.decoration.DecorationGroup;
import org.eclipse.scout.rt.ui.swing.ext.decoration.DropDownDecorationItem;
import org.eclipse.scout.rt.ui.swing.ext.decoration.JTextFieldWithDecorationIcons;
import org.eclipse.scout.rt.ui.swing.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutBasicFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.colorpickerfield.ISwingScoutColorField;

public class SwingScoutColorField
extends SwingScoutBasicFieldComposite<IColorField>
implements ISwingScoutColorField {
    private JTextField m_colorPreview;
    private ContextMenuDecorationItem m_contextMenuMarker;
    private SwingScoutContextMenu m_contextMenu;
    private DropDownDecorationItem m_dropdownIcon;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx(new BorderLayoutEx());
        container.setOpaque(false);
        JStatusLabelEx label = new JStatusLabelEx();
        container.add((Component)label, "Center");
        this.m_colorPreview = new JTextField();
        this.m_colorPreview.setEditable(false);
        container.add(this.m_colorPreview);
        JTextComponent textField = this.createTextField(container);
        Document doc = textField.getDocument();
        this.addInputListenersForBasicField(textField, doc);
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(new BasicDocumentFilter(60));
        }
        doc.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingScoutColorField.this.setInputDirty(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingScoutColorField.this.setInputDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingScoutColorField.this.setInputDirty(true);
            }
        });
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(textField);
        InputMap inputMap = textField.getInputMap(0);
        inputMap.put(SwingUtility.createKeystroke("F2"), "colorPicker");
        inputMap.put(SwingUtility.createKeystroke("DOWN"), "colorPicker");
        ActionMap actionMap = textField.getActionMap();
        actionMap.put("colorPicker", new P_SwingColorPickerAction());
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
        LogicalGridData data = LogicalGridDataBuilder.createButton1(this.getSwingEnvironment());
        data.gridx = 1;
        data.widthHint = 20;
        data.fillVertical = true;
        this.m_colorPreview.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, data);
        data = LogicalGridDataBuilder.createField(this.getSwingEnvironment(), ((IColorField)this.getScoutObject()).getGridData());
        ++data.gridx;
        textField.putClientProperty(LogicalGridData.CLIENT_PROPERTY_NAME, data);
    }

    protected JTextComponent createTextField(JComponent container) {
        JTextFieldWithDecorationIcons textField = new JTextFieldWithDecorationIcons();
        container.add(textField);
        DecorationGroup decorationGroup = new DecorationGroup(textField, this.getSwingEnvironment());
        this.m_contextMenuMarker = new ContextMenuDecorationItem(((IColorField)this.getScoutObject()).getContextMenu(), textField, this.getSwingEnvironment());
        this.m_contextMenuMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingScoutColorField.this.m_contextMenu.showSwingPopup(e.getX(), e.getY(), false);
            }
        });
        decorationGroup.addDecoration(this.m_contextMenuMarker);
        this.m_dropdownIcon = new DropDownDecorationItem(textField, this.getSwingEnvironment());
        this.m_dropdownIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    SwingScoutColorField.this.m_contextMenu.showSwingPopup(e.getX(), e.getY(), false);
                } else {
                    SwingScoutColorField.this.getSwingField().requestFocus();
                    SwingScoutColorField.this.handleUiPickColor();
                }
            }
        });
        decorationGroup.addDecoration(this.m_dropdownIcon);
        textField.setDecorationIcon(decorationGroup);
        return textField;
    }

    @Override
    protected void installContextMenu() {
        ((IColorField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    SwingScoutColorField.this.m_contextMenuMarker.setMarkerVisible(((IColorField)SwingScoutColorField.this.getScoutObject()).getContextMenu().isVisible());
                }
            }
        });
        this.m_contextMenuMarker.setMarkerVisible(((IColorField)this.getScoutObject()).getContextMenu().isVisible());
        this.m_contextMenu = SwingScoutContextMenu.installContextMenuWithSystemMenus(this.getSwingField(), ((IColorField)this.getScoutObject()).getContextMenu(), this.getSwingEnvironment());
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.updateIconIdFromScout();
    }

    @Override
    public JTextComponent getSwingField() {
        return super.getSwingField();
    }

    protected void handleUiPickColor() {
        Color color = org.eclipse.scout.rt.ui.swing.basic.ColorUtility.createColor((String)((IColorField)this.getScoutObject()).getValue());
        Color selectedColor = JColorChooser.showDialog(this.getSwingField(), ScoutTexts.get((String)"ColorPickerSelectColor", (String[])new String[0]), color);
        if (selectedColor != null) {
            final String colorString = ColorUtility.rgbToText((int)selectedColor.getRed(), (int)selectedColor.getGreen(), (int)selectedColor.getBlue()).toUpperCase();
            RunnableWithData t = new RunnableWithData(){

                public void run() {
                    ((IColorField)SwingScoutColorField.this.getScoutObject()).getUIFacade().setValueFromUi(colorString);
                }
            };
            this.getSwingEnvironment().invokeScoutLater((Runnable)t, 2345L);
        }
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_dropdownIcon.setEnabled(b);
    }

    @Override
    protected void setValueFromScout(Object o) {
        String value = (String)((IColorField)this.getScoutObject()).getValue();
        if (value == null) {
            value = "";
        }
        Color c = org.eclipse.scout.rt.ui.swing.basic.ColorUtility.createColor(value);
        this.m_colorPreview.setBackground(c);
        this.getSwingField().setText(value);
    }

    protected void updateIconIdFromScout() {
        String iconId = ((IColorField)this.getScoutObject()).getIconId();
        if (iconId == null) {
            this.m_dropdownIcon.setVisible(false);
        } else {
            this.m_dropdownIcon.setIconGroup(new IconGroup(this.getSwingEnvironment(), iconId));
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("iconId")) {
            this.updateIconIdFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    @Override
    protected void setSelectionFromSwing() {
    }

    @Override
    protected boolean isSelectAllOnFocusInScout() {
        return true;
    }

    private class P_SwingColorPickerAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private P_SwingColorPickerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingScoutColorField.this.handleUiPickColor();
        }
    }
}

