/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.numberfield;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberField;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.SwingUtility;
import org.eclipse.scout.rt.ui.swing.action.menu.SwingScoutContextMenu;
import org.eclipse.scout.rt.ui.swing.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.ext.decoration.ContextMenuDecorationItem;
import org.eclipse.scout.rt.ui.swing.ext.decoration.JTextFieldWithDecorationIcons;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutBasicFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.numberfield.ISwingScoutNumberField;

public class SwingScoutNumberField
extends SwingScoutBasicFieldComposite<INumberField<?>>
implements ISwingScoutNumberField {
    private static final long serialVersionUID = 1L;
    private ContextMenuDecorationItem m_contextMenuMarker;
    private SwingScoutContextMenu m_contextMenu;

    @Override
    protected void initializeSwing() {
        JPanelEx container = new JPanelEx();
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JTextFieldWithDecorationIcons textField = new JTextFieldWithDecorationIcons();
        this.m_contextMenuMarker = new ContextMenuDecorationItem(((INumberField)this.getScoutObject()).getContextMenu(), textField, this.getSwingEnvironment());
        this.m_contextMenuMarker.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingScoutNumberField.this.m_contextMenu.showSwingPopup(e.getX(), e.getY(), false);
            }
        });
        textField.setDecorationIcon(this.m_contextMenuMarker);
        Document doc = textField.getDocument();
        if (doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).setDocumentFilter(new P_DocumentFilter());
        }
        this.addInputListenersForBasicField(textField, doc);
        container.add(textField);
        this.setSwingContainer(container);
        this.setSwingLabel(label);
        this.setSwingField(textField);
        this.getSwingContainer().setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    protected void installContextMenu() {
        ((INumberField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    SwingScoutNumberField.this.m_contextMenuMarker.setMarkerVisible(((INumberField)SwingScoutNumberField.this.getScoutObject()).getContextMenu().isVisible());
                }
            }
        });
        this.m_contextMenuMarker.setMarkerVisible(((INumberField)this.getScoutObject()).getContextMenu().isVisible());
        this.m_contextMenu = SwingScoutContextMenu.installContextMenuWithSystemMenus(this.getSwingTextField(), ((INumberField)this.getScoutObject()).getContextMenu(), this.getSwingEnvironment());
    }

    @Override
    public JTextField getSwingTextField() {
        return (JTextField)this.getSwingField();
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        JTextComponent fld = this.getSwingField();
        if (fld != null && scoutColor != null && fld instanceof JTextComponent) {
            this.setDisabledTextColor(ColorUtility.createColor(scoutColor), fld);
        }
        super.setForegroundFromScout(scoutColor);
    }

    @Override
    protected void setHorizontalAlignmentFromScout(int scoutAlign) {
        int swingAlign = SwingUtility.createHorizontalAlignment(scoutAlign);
        this.getSwingTextField().setHorizontalAlignment(swingAlign);
    }

    @Override
    protected void setSelectionFromSwing() {
    }

    @Override
    protected boolean isSelectAllOnFocusInScout() {
        return true;
    }

    private final class P_DocumentFilter
    extends DocumentFilter {
        private P_DocumentFilter() {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            Document doc = fb.getDocument();
            if (StringUtility.isWithinNumberFormatLimits((DecimalFormat)((INumberField)SwingScoutNumberField.this.getScoutObject()).getFormat(), (String)doc.getText(0, doc.getLength()), (int)offset, (int)length, (String)text)) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            Document doc = fb.getDocument();
            if (StringUtility.isWithinNumberFormatLimits((DecimalFormat)((INumberField)SwingScoutNumberField.this.getScoutObject()).getFormat(), (String)doc.getText(0, doc.getLength()), (int)offset, (int)0, (String)string)) {
                super.insertString(fb, offset, string, attr);
            }
        }
    }
}

