/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.form.fields.radiobuttongroup;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.radiobuttongroup.IRadioButtonGroup;
import org.eclipse.scout.rt.ui.swing.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swing.ext.JPanelEx;
import org.eclipse.scout.rt.ui.swing.ext.JStatusLabelEx;
import org.eclipse.scout.rt.ui.swing.form.fields.ISwingScoutFormField;
import org.eclipse.scout.rt.ui.swing.form.fields.SwingScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swing.form.fields.radiobuttongroup.ISwingScoutRadioButtonGroup;
import org.eclipse.scout.rt.ui.swing.form.fields.radiobuttongroup.layout.RadioButtonGroupLayout;

public class SwingScoutRadioButtonGroup
extends SwingScoutValueFieldComposite<IRadioButtonGroup<?>>
implements ISwingScoutRadioButtonGroup {
    private ArrayList<JRadioButton> m_swingRadioButtons = new ArrayList();

    @Override
    protected void initializeSwing() {
        boolean usesLogicalGrid;
        super.initializeSwing();
        JPanelEx container = new JPanelEx();
        container.setName("SwingScoutRadioButtonGroup.container");
        container.setOpaque(false);
        JStatusLabelEx label = this.getSwingEnvironment().createStatusLabel((IFormField)this.getScoutObject());
        container.add(label);
        JPanelEx buttonPanel = new JPanelEx();
        buttonPanel.setName("SwingScoutRadioButtonGroup.buttonPanel");
        buttonPanel.setOpaque(false);
        GridData scoutGridData = ((IRadioButtonGroup)this.getScoutObject()).getGridData();
        boolean bl = usesLogicalGrid = ((IRadioButtonGroup)this.getScoutObject()).getGridRowCount() == scoutGridData.h && !scoutGridData.useUiHeight;
        if (usesLogicalGrid) {
            buttonPanel.setLayout(new RadioButtonGroupLayout((IRadioButtonGroup)this.getScoutObject(), this.getSwingEnvironment().getFormColumnGap(), this.getSwingEnvironment().getFormRowGap()));
        } else {
            buttonPanel.setLayout(new RadioButtonGroupLayout((IRadioButtonGroup)this.getScoutObject(), 0, 0));
        }
        for (IFormField scoutField : ((IRadioButtonGroup)this.getScoutObject()).getFields()) {
            ISwingScoutFormField comp = this.getSwingEnvironment().createFormField(buttonPanel, scoutField);
            buttonPanel.add(comp.getSwingContainer());
            if (!(comp.getSwingField() instanceof JRadioButton)) continue;
            JRadioButton radioButton = (JRadioButton)comp.getSwingField();
            radioButton.addKeyListener(new P_SwingButtonKeyListener());
            this.m_swingRadioButtons.add(radioButton);
        }
        container.add(buttonPanel);
        this.setSwingLabel(label);
        this.setSwingField(buttonPanel);
        this.setSwingContainer(container);
        container.setLayout(new LogicalGridLayout(this.getSwingEnvironment(), 1, 0));
    }

    @Override
    public JPanel getSwingRadioButtonPanel() {
        return (JPanel)this.getSwingField();
    }

    private class P_SwingButtonKeyListener
    extends KeyAdapter {
        private P_SwingButtonKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent event) {
            int index = SwingScoutRadioButtonGroup.this.m_swingRadioButtons.indexOf(event.getComponent());
            if (index < 0) {
                return;
            }
            switch (event.getKeyCode()) {
                case 39: 
                case 40: {
                    this.selectNextPossibleRadioButton(index);
                    break;
                }
                case 37: 
                case 38: {
                    this.selectPreviousPossibleRadioButton(index);
                    break;
                }
                case 36: {
                    this.selectFirstPossibleRadioButton();
                    break;
                }
                case 35: {
                    this.selectLastPossibleRadioButton();
                }
            }
        }

        protected void selectNextPossibleRadioButton(int currentIndex) {
            int i = 1;
            while (i < SwingScoutRadioButtonGroup.this.m_swingRadioButtons.size()) {
                int nextIndex = (currentIndex + i) % SwingScoutRadioButtonGroup.this.m_swingRadioButtons.size();
                JRadioButton newRadioButton = (JRadioButton)SwingScoutRadioButtonGroup.this.m_swingRadioButtons.get(nextIndex);
                if (this.acceptsFocus(newRadioButton)) {
                    newRadioButton.setSelected(true);
                    return;
                }
                ++i;
            }
        }

        protected void selectPreviousPossibleRadioButton(int currentIndex) {
            int i = 1;
            while (i < SwingScoutRadioButtonGroup.this.m_swingRadioButtons.size()) {
                JRadioButton newRadioButton;
                int nextIndex = (currentIndex - i) % SwingScoutRadioButtonGroup.this.m_swingRadioButtons.size();
                if (nextIndex < 0) {
                    nextIndex += SwingScoutRadioButtonGroup.this.m_swingRadioButtons.size();
                }
                if (this.acceptsFocus(newRadioButton = (JRadioButton)SwingScoutRadioButtonGroup.this.m_swingRadioButtons.get(nextIndex))) {
                    newRadioButton.setSelected(true);
                    return;
                }
                ++i;
            }
        }

        protected void selectLastPossibleRadioButton() {
            int i = SwingScoutRadioButtonGroup.this.m_swingRadioButtons.size() - 1;
            while (i >= 0) {
                JRadioButton newRadioButton = (JRadioButton)SwingScoutRadioButtonGroup.this.m_swingRadioButtons.get(i);
                if (newRadioButton.hasFocus()) {
                    return;
                }
                if (this.acceptsFocus(newRadioButton)) {
                    newRadioButton.setSelected(true);
                    return;
                }
                --i;
            }
        }

        protected void selectFirstPossibleRadioButton() {
            for (JRadioButton newRadioButton : SwingScoutRadioButtonGroup.this.m_swingRadioButtons) {
                if (newRadioButton.hasFocus()) {
                    return;
                }
                if (!this.acceptsFocus(newRadioButton)) continue;
                newRadioButton.setSelected(true);
                return;
            }
        }

        protected boolean acceptsFocus(JRadioButton radioButton) {
            return radioButton.isFocusable() && radioButton.isVisible() && radioButton.isEnabled() && radioButton.requestFocusInWindow();
        }
    }
}

