/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.inject;

import javax.swing.JComponent;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutAction;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutCheckBoxMenu;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutMenu;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutMenuItem;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutToolTab;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutViewTab;

public class ActionInjector {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ActionInjector.class);

    public ISwingScoutAction<?> inject(ISwingEnvironment env, JComponent parent, IAction action) {
        if (action instanceof IToolButton) {
            return this.createSwingScoutToolButton((IToolButton)action, env);
        }
        if (action instanceof IViewButton) {
            return this.createSwingScoutViewButton((IViewButton)action, env);
        }
        if (action instanceof IMenu && action.isToggleAction()) {
            SwingScoutCheckBoxMenu<IMenu> ui = new SwingScoutCheckBoxMenu<IMenu>();
            ui.createField((IMenu)action, env);
            return ui;
        }
        if (action instanceof IActionNode) {
            IActionNode node = (IActionNode)action;
            if (node.hasChildActions()) {
                SwingScoutMenu<IActionNode> ui = new SwingScoutMenu<IActionNode>();
                ui.createField((IActionNode)action, env);
                return ui;
            }
            SwingScoutMenuItem<IActionNode> ui = new SwingScoutMenuItem<IActionNode>();
            ui.createField((IActionNode)action, env);
            return ui;
        }
        SwingScoutAction<IAction> ui = new SwingScoutAction<IAction>();
        ui.createField(action, env);
        return ui;
    }

    protected ISwingScoutAction<IToolButton> createSwingScoutToolButton(IToolButton toolButton, ISwingEnvironment env) {
        SwingScoutToolTab ui = new SwingScoutToolTab();
        ui.createField(toolButton, env);
        return ui;
    }

    protected ISwingScoutAction<IViewButton> createSwingScoutViewButton(IViewButton viewButton, ISwingEnvironment env) {
        SwingScoutViewTab ui = new SwingScoutViewTab();
        ui.createField(viewButton, env);
        return ui;
    }
}

