/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.layout;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.CellElement;

class Cell {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(Cell.class);
    private int m_row;
    private int m_col;
    private boolean m_multiView;
    private ArrayList<CellElement> m_elements = new ArrayList();

    public Cell(int row, int col, boolean multiView) {
        this.m_row = row;
        this.m_col = col;
        this.m_multiView = multiView;
    }

    public int getRow() {
        return this.m_row;
    }

    public int getColumn() {
        return this.m_col;
    }

    public boolean isMultiView() {
        return this.m_multiView;
    }

    public void setMultiView(boolean b) {
        this.m_multiView = b;
    }

    public int getCellElementCount() {
        return this.m_elements.size();
    }

    public CellElement getCellElement(int index) {
        return this.m_elements.get(index);
    }

    public void setView(Component c, float[][] distributionMap3x3) {
        this.m_elements.clear();
        this.addView(c, distributionMap3x3);
    }

    public void addView(Component c, float[][] distributionMap3x3) {
        for (CellElement v : this.m_elements) {
            if (v.getComponent() != c) continue;
            return;
        }
        if (this.m_multiView) {
            this.m_elements.add(new CellElement(c, distributionMap3x3));
        } else {
            this.m_elements.clear();
            this.m_elements.add(new CellElement(c, distributionMap3x3));
        }
    }

    public void removeView(Component c) {
        Iterator<CellElement> it = this.m_elements.iterator();
        while (it.hasNext()) {
            CellElement v = it.next();
            if (v.getComponent() != c) continue;
            it.remove();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.m_row + ", " + this.m_col + ", elements=" + VerboseUtility.dumpObject(this.m_elements) + "]";
    }
}

