/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.layout;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import org.eclipse.scout.rt.ui.swing.SwingLayoutUtility;
import org.eclipse.scout.rt.ui.swing.window.desktop.layout.MultiSplitLayout;

public class MultiSplitDesktopManager
extends DefaultDesktopManager {
    private static final long serialVersionUID = 1L;
    private ArrayList<WeakReference<JInternalFrame>> m_activationHistory = new ArrayList();

    @Override
    public void iconifyFrame(JInternalFrame f) {
        Action a;
        boolean wasSelected = f.isSelected();
        f.putClientProperty("sizeBeforeIconify", f.getSize());
        JDesktopPane pane = f.getDesktopPane();
        LayoutManager layout = pane.getLayout();
        if (layout instanceof MultiSplitLayout) {
            MultiSplitLayout pLayout = (MultiSplitLayout)layout;
            Dimension prefSize = f.getPreferredSize();
            Dimension d = new Dimension(f.getWidth(), prefSize.height);
            pLayout.getModel(pane).iconify(f, new Rectangle(f.getLocation(), d));
            this.reassignFrameSizes(pane);
        }
        if (wasSelected && (a = f.getDesktopPane().getActionMap().get("selectNextFrame")) != null) {
            a.actionPerformed(new ActionEvent(this, 1001, null));
        }
        f.getDesktopPane().revalidate();
    }

    @Override
    public void deiconifyFrame(JInternalFrame f) {
        JDesktopPane pane = f.getDesktopPane();
        LayoutManager layout = pane.getLayout();
        if (layout instanceof MultiSplitLayout) {
            MultiSplitLayout pLayout = (MultiSplitLayout)layout;
            Dimension d = (Dimension)f.getClientProperty("sizeBeforeIconify");
            if (d != null) {
                Dimension curSize = f.getSize();
                Dimension minSize = f.getMinimumSize();
                Dimension maxSize = f.getMaximumSize();
                d.width = Math.max(minSize.width, Math.min(curSize.width, maxSize.width));
                d.height = Math.max(minSize.height, Math.min(d.height, maxSize.height));
            } else {
                Dimension prefSize = f.getPreferredSize();
                Dimension maxSize = f.getMaximumSize();
                d = new Dimension(f.getWidth(), Math.max(prefSize.height, Math.min(maxSize.height, 64)));
            }
            pLayout.getModel(pane).fitSize(f, d);
            this.reassignFrameSizes(pane);
        }
    }

    @Override
    public void activateFrame(JInternalFrame f) {
        super.activateFrame(f);
        this.addToActiveHistory(f);
    }

    @Override
    public void deactivateFrame(JInternalFrame f) {
        super.deactivateFrame(f);
    }

    @Override
    public void openFrame(JInternalFrame f) {
        super.openFrame(f);
        JDesktopPane pane = f.getDesktopPane();
        this.reassignFrameSizes(pane);
    }

    public void fitFrames(JInternalFrame[] frames) {
        JDesktopPane pane;
        LayoutManager layout;
        if (frames != null && frames.length > 0 && (layout = (pane = frames[0].getDesktopPane()).getLayout()) instanceof MultiSplitLayout) {
            MultiSplitLayout pLayout = (MultiSplitLayout)layout;
            JInternalFrame[] jInternalFrameArray = frames;
            int n = frames.length;
            int n2 = 0;
            while (n2 < n) {
                JInternalFrame f = jInternalFrameArray[n2];
                Dimension cur = f.getSize();
                Dimension[] sizes = SwingLayoutUtility.getValidatedSizes(f);
                Dimension d = new Dimension(Math.max(sizes[0].width, Math.min(cur.width, sizes[2].width)), Math.max(sizes[0].height, Math.min(cur.height, sizes[2].height)));
                d.width = Math.max(d.width, sizes[1].width);
                d.height = Math.max(d.height, sizes[1].height);
                pLayout.getModel(pane).fitSize(f, d);
                ++n2;
            }
            this.reassignFrameSizes(pane);
        }
    }

    @Override
    public void closeFrame(JInternalFrame f) {
        JDesktopPane pane = f.getDesktopPane();
        super.closeFrame(f);
        if (pane != null) {
            pane.revalidate();
        }
        this.removeFromActiveHistory(f);
        JInternalFrame lastActiveFrame = this.getLastActivatedFrame();
        if (lastActiveFrame != null && !lastActiveFrame.isSelected()) {
            try {
                lastActiveFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private JInternalFrame getLastActivatedFrame() {
        if (this.m_activationHistory.size() > 0) {
            return (JInternalFrame)this.m_activationHistory.get(0).get();
        }
        return null;
    }

    private void removeFromActiveHistory(JInternalFrame f) {
        Iterator<WeakReference<JInternalFrame>> it = this.m_activationHistory.iterator();
        while (it.hasNext()) {
            WeakReference<JInternalFrame> ref = it.next();
            if (ref.get() == f) {
                it.remove();
                continue;
            }
            if (ref.get() != null) continue;
            it.remove();
        }
    }

    private void addToActiveHistory(JInternalFrame f) {
        this.removeFromActiveHistory(f);
        Iterator<WeakReference<JInternalFrame>> it = this.m_activationHistory.iterator();
        while (it.hasNext()) {
            WeakReference<JInternalFrame> ref = it.next();
            if (ref.get() == f) {
                it.remove();
                continue;
            }
            if (ref.get() != null) continue;
            it.remove();
        }
        if (f != null) {
            this.m_activationHistory.add(0, new WeakReference<JInternalFrame>(f));
        }
    }

    @Override
    public void minimizeFrame(JInternalFrame f) {
        super.minimizeFrame(f);
        f.getDesktopPane().revalidate();
    }

    @Override
    public void beginDraggingFrame(JComponent f) {
    }

    @Override
    public void dragFrame(JComponent f, int newX, int newY) {
    }

    @Override
    public void endDraggingFrame(JComponent f) {
    }

    @Override
    public void beginResizingFrame(JComponent f, int direction) {
        super.beginResizingFrame(f, direction);
    }

    @Override
    public void resizeFrame(JComponent f, int x, int y, int w, int h) {
        JDesktopPane pane = this.getDesktopPane2(f);
        LayoutManager layout = pane.getLayout();
        if (layout instanceof MultiSplitLayout) {
            MultiSplitLayout pLayout = (MultiSplitLayout)layout;
            pLayout.getModel(pane).resize((JInternalFrame)f, new Rectangle(x, y, w, h));
            this.reassignFrameSizes(pane);
        }
    }

    @Override
    public void endResizingFrame(JComponent f) {
        super.endResizingFrame(f);
    }

    protected void reassignFrameSizes(JDesktopPane pane) {
        pane.getRootPane().revalidate();
        pane.doLayout();
    }

    @Override
    public void setBoundsForFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
        super.setBoundsForFrame(f, newX, newY, newWidth, newHeight);
    }

    private JDesktopPane getDesktopPane2(JComponent frame) {
        JDesktopPane pane = null;
        Container c = frame.getParent();
        while (pane == null) {
            if (c instanceof JDesktopPane) {
                pane = (JDesktopPane)c;
                continue;
            }
            if (c == null) break;
            c = c.getParent();
        }
        return pane;
    }
}

