/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractFormToolButton;
import org.eclipse.scout.rt.ui.swing.ISwingEnvironment;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.AbstractJToolTabsBar;
import org.eclipse.scout.rt.ui.swing.window.desktop.toolbar.SwingScoutHeaderPanel;

public class JToolTabsBar
extends AbstractJToolTabsBar {
    private static final long serialVersionUID = 1L;
    private final ISwingEnvironment m_env;
    private SwingScoutHeaderPanel m_swingScoutHeaderPanel;
    private final OptimisticLock m_syncLock;

    public JToolTabsBar(ISwingEnvironment env) {
        this.m_env = env;
        this.m_syncLock = new OptimisticLock();
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
    }

    @Override
    public void rebuild(IDesktop desktop) {
        this.removeAll();
        JToolBar swingToolBar = new JToolBar(0);
        swingToolBar.setFloatable(false);
        swingToolBar.setBorder(new EmptyBorder(0, 0, 0, 3));
        swingToolBar.setOpaque(false);
        swingToolBar.setLayout(new GridBagLayout());
        for (IToolButton scoutToolButton : desktop.getToolButtons()) {
            ISwingScoutAction<IToolButton> swingScoutToolButton;
            if (!(scoutToolButton instanceof AbstractFormToolButton) || (swingScoutToolButton = this.createSwingScoutToolButton(scoutToolButton)) == null) continue;
            AbstractButton swingButton = (AbstractButton)swingScoutToolButton.getSwingField();
            this.addActiveTabListener(swingButton);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 2, 0, 0);
            gbc.fill = 3;
            swingToolBar.add((Component)swingButton, gbc);
        }
        JPanel filler = new JPanel();
        filler.setPreferredSize(new Dimension(-1, 0));
        filler.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        this.add((Component)filler, gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.anchor = 15;
        this.add((Component)swingToolBar, gbc);
        swingToolBar.addComponentListener(new ComponentAdapter(){
            private int m_width;

            @Override
            public void componentResized(ComponentEvent e) {
                try {
                    int newWidth;
                    if (JToolTabsBar.this.m_syncLock.acquire() && this.m_width != (newWidth = JToolTabsBar.this.getPreferredSize().width)) {
                        this.m_width = newWidth;
                        JToolTabsBar.this.m_swingScoutHeaderPanel.adjustToolButtonPanelWidth(JToolTabsBar.this.getPreferredSize().width, false);
                    }
                }
                finally {
                    JToolTabsBar.this.m_syncLock.release();
                }
            }
        });
    }

    @Override
    public void setSwingScoutHeaderPanel(SwingScoutHeaderPanel swingScoutHeaderPanel) {
        this.m_swingScoutHeaderPanel = swingScoutHeaderPanel;
    }

    private ISwingScoutAction<IToolButton> createSwingScoutToolButton(IToolButton scoutToolButton) {
        return this.m_env.createAction(this, (IAction)scoutToolButton);
    }
}

