/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.window.desktop.tray;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swing.Activator;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;
import org.eclipse.scout.rt.ui.swing.window.desktop.tray.ISwingScoutTray;

public class SwingScoutTray
extends SwingScoutComposite<IDesktop>
implements ISwingScoutTray {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwingScoutTray.class);
    private TrayIcon m_trayIcon;

    @Override
    protected void initializeSwing() {
        this.m_trayIcon = this.createTrayIcon();
        if (this.m_trayIcon != null) {
            PopupMenu pm = this.createPopupMenu();
            if (pm != null) {
                this.updatePopupMenus(pm);
                this.m_trayIcon.setPopupMenu(pm);
            }
            try {
                SystemTray.getSystemTray().add(this.m_trayIcon);
            }
            catch (AWTException e) {
                LOG.warn("Failed attaching tray icon", (Throwable)e);
            }
        }
    }

    protected TrayIcon createTrayIcon() {
        Image icon = Activator.getImage("window");
        if (icon == null) {
            icon = Activator.getImage("tray");
        }
        return new TrayIcon(icon);
    }

    protected PopupMenu createPopupMenu() {
        return new PopupMenu();
    }

    protected void updatePopupMenus(PopupMenu pm) {
        pm.removeAll();
        if (this.getScoutObject() != null) {
            final AtomicReference scoutMenusRef = new AtomicReference();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    scoutMenusRef.set(((IDesktop)SwingScoutTray.this.getScoutObject()).getUIFacade().fireTrayPopupFromUI());
                }
            };
            try {
                this.getSwingEnvironment().invokeScoutLater(t, 5678L).join(5678L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (CollectionUtility.hasElements((Collection)((Collection)scoutMenusRef.get()))) {
                for (IAction a : (List)scoutMenusRef.get()) {
                    MenuItem mi;
                    if (a.isSeparator()) {
                        pm.addSeparator();
                        continue;
                    }
                    if (!(a instanceof IMenu)) continue;
                    IMenu menu = (IMenu)a;
                    SwingScoutAction<IAction> actionComposite = new SwingScoutAction<IAction>();
                    actionComposite.createField(a, this.getSwingEnvironment());
                    if (menu.getChildActionCount() > 0) {
                        mi = new Menu();
                        mi.setLabel(menu.getText());
                        mi.setEnabled(menu.isEnabled());
                        mi.addActionListener(actionComposite.getSwingAction());
                        pm.add(mi);
                        continue;
                    }
                    mi = new MenuItem();
                    mi.setLabel(menu.getText());
                    mi.setEnabled(menu.isEnabled());
                    mi.addActionListener(actionComposite.getSwingAction());
                    pm.add(mi);
                }
            }
        }
    }

    @Override
    public TrayIcon getSwingTrayIcon() {
        return this.m_trayIcon;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IDesktop desktop = (IDesktop)this.getScoutObject();
        this.setTooltipFromScout(desktop.getTitle());
    }

    protected void setTooltipFromScout(String tooltip) {
        if (this.m_trayIcon != null) {
            this.m_trayIcon.setToolTip(tooltip);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("title".equals(name)) {
            this.setTooltipFromScout((String)newValue);
        }
    }
}

