/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.calendar.ICalendar;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class SwtMenuUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtMenuUtility.class);

    private SwtMenuUtility() {
    }

    public static MenuItem createSwtMenuItem(Menu parentMenu, IMenu scoutMenu, ISwtEnvironment environment) {
        MenuItem swtMenuItem = null;
        if (scoutMenu.isSeparator()) {
            swtMenuItem = new MenuItem(parentMenu, 2);
        } else if (scoutMenu.hasChildActions()) {
            swtMenuItem = new MenuItem(parentMenu, 64);
            SwtMenuUtility.createChildMenu(swtMenuItem, scoutMenu.getChildActions(), environment);
        } else {
            swtMenuItem = scoutMenu.isToggleAction() ? new MenuItem(parentMenu, 32) : new MenuItem(parentMenu, 8);
        }
        return swtMenuItem;
    }

    public static Menu createChildMenu(MenuItem swtMenuItem, List<IMenu> childActions, ISwtEnvironment environment) {
        Menu menu = new Menu(swtMenuItem);
        SwtMenuUtility.fillMenu(menu, childActions, environment);
        swtMenuItem.setMenu(menu);
        return menu;
    }

    public static void fillMenu(Menu menu, List<IMenu> childActions, ISwtEnvironment environment) {
        SwtMenuUtility.fillMenu(menu, childActions, environment, false);
    }

    public static void fillMenu(Menu menu, List<IMenu> childActions, ISwtEnvironment environment, boolean separatorFirstIfHasMenus) {
        List visibleNormalizedActions = ActionUtility.visibleNormalizedActions(childActions);
        if (separatorFirstIfHasMenus && visibleNormalizedActions.size() > 0) {
            new MenuItem(menu, 2);
        }
        for (IMenu childMenu : visibleNormalizedActions) {
            environment.createMenuItem(menu, childMenu);
        }
    }

    public static List<IMenu> collectMenus(final ITree tree, final boolean emptySpaceActions, final boolean nodeActions, ISwtEnvironment uiEnvironment) {
        final LinkedList<IMenu> menuList = new LinkedList<IMenu>();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                if (emptySpaceActions) {
                    menuList.addAll(tree.getUIFacade().fireEmptySpacePopupFromUI());
                }
                if (nodeActions) {
                    menuList.addAll(tree.getUIFacade().fireNodePopupFromUI());
                }
            }
        };
        JobEx job = uiEnvironment.invokeScoutLater(t, 5000L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException ex) {
            LOG.warn("Exception occured while collecting menus.", (Throwable)ex);
        }
        return menuList;
    }

    public static List<IMenu> collectMenus(final ITable table, final boolean emptySpaceActions, final boolean rowActions, ISwtEnvironment uiEnvironment) {
        final LinkedList<IMenu> menuList = new LinkedList<IMenu>();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                if (emptySpaceActions) {
                    menuList.addAll(table.getUIFacade().fireEmptySpacePopupFromUI());
                }
                if (rowActions) {
                    menuList.addAll(table.getUIFacade().fireRowPopupFromUI());
                }
            }
        };
        JobEx job = uiEnvironment.invokeScoutLater(t, 5000L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException ex) {
            LOG.warn("Exception occured while collecting menus.", (Throwable)ex);
        }
        return menuList;
    }

    public static List<IMenu> collectMenus(final ICalendar calendar, final boolean emptySpaceActions, final boolean componentActions, ISwtEnvironment swtEnvironment) {
        final LinkedList<IMenu> menuList = new LinkedList<IMenu>();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                if (emptySpaceActions) {
                    menuList.addAll(calendar.getUIFacade().fireNewPopupFromUI());
                }
                if (componentActions) {
                    menuList.addAll(calendar.getUIFacade().fireComponentPopupFromUI());
                }
            }
        };
        JobEx job = swtEnvironment.invokeScoutLater(t, 5000L);
        try {
            job.join(1200L);
        }
        catch (InterruptedException ex) {
            LOG.warn("Exception occured while collecting menus.", (Throwable)ex);
        }
        return menuList;
    }

    public static List<IMenu> collectRowMenus(ITable table, ISwtEnvironment uiEnvironment) {
        return SwtMenuUtility.collectMenus(table, false, true, uiEnvironment);
    }

    public static List<IMenu> collectEmptySpaceMenus(ITable table, ISwtEnvironment uiEnvironment) {
        return SwtMenuUtility.collectMenus(table, true, false, uiEnvironment);
    }

    public static List<IMenu> collectNodeMenus(ITree tree, ISwtEnvironment uiEnvironment) {
        return SwtMenuUtility.collectMenus(tree, false, true, uiEnvironment);
    }

    public static List<IMenu> collectEmptySpaceMenus(ITree tree, ISwtEnvironment uiEnvironment) {
        return SwtMenuUtility.collectMenus(tree, true, false, uiEnvironment);
    }

    public static List<IMenu> collectComponentMenus(ICalendar calendar, ISwtEnvironment swtEnvironment) {
        return SwtMenuUtility.collectMenus(calendar, false, true, swtEnvironment);
    }

    public static List<IMenu> collectEmptySpaceMenus(ICalendar calendar, ISwtEnvironment swtEnvironment) {
        return SwtMenuUtility.collectMenus(calendar, true, false, swtEnvironment);
    }
}

