/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.action.menu;

import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.menu.IContextMenu;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.SwtMenuUtility;
import org.eclipse.scout.rt.ui.swt.action.menu.ISwtScoutMenu;
import org.eclipse.scout.rt.ui.swt.action.menu.text.ITextAccess;
import org.eclipse.scout.rt.ui.swt.action.menu.text.SwtCopyMenuItem;
import org.eclipse.scout.rt.ui.swt.action.menu.text.SwtCutMenuItem;
import org.eclipse.scout.rt.ui.swt.action.menu.text.SwtPasteMenuItem;
import org.eclipse.scout.rt.ui.swt.action.menu.text.SwtRedoMenuItem;
import org.eclipse.scout.rt.ui.swt.action.menu.text.SwtUndoMenuItem;
import org.eclipse.scout.rt.ui.swt.internal.StyledTextFieldUndoRedoSupport;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class SwtScoutContextMenu
implements ISwtScoutMenu {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutContextMenu.class);
    public static final String DATA_SYSTEM_MENU = "dataSystemMenu";
    protected final BasicPropertySupport m_propertySupport;
    private final ISwtEnvironment m_environment;
    private final Shell m_parentShell;
    private Menu m_swtMenu;
    private IContextMenu m_scoutContextMenu;
    private Listener m_uiMenuListener;
    private Boolean m_childrenCreated = false;
    private final ITextAccess m_systemMenuOwner;
    private final StyledText m_undoRedoMenuOwner;

    public SwtScoutContextMenu(Shell parentShell, IContextMenu scoutContextMenu, ISwtEnvironment environment) {
        this(parentShell, scoutContextMenu, environment, null, null, true);
    }

    public SwtScoutContextMenu(Shell parentShell, IContextMenu scoutContextMenu, ISwtEnvironment environment, ITextAccess systemMenuOwner) {
        this(parentShell, scoutContextMenu, environment, systemMenuOwner, null, true);
    }

    public SwtScoutContextMenu(Shell parentShell, IContextMenu scoutContextMenu, ISwtEnvironment environment, ITextAccess systemMenuOwner, StyledText undoRedoMenuOwner) {
        this(parentShell, scoutContextMenu, environment, systemMenuOwner, undoRedoMenuOwner, true);
    }

    public SwtScoutContextMenu(Shell parentShell, IContextMenu scoutContextMenu, ISwtEnvironment environment, ITextAccess systemMenuOwner, StyledText undoRedoMenuOwner, boolean callInitializer) {
        this.m_parentShell = parentShell;
        this.m_scoutContextMenu = scoutContextMenu;
        this.m_systemMenuOwner = systemMenuOwner;
        this.m_undoRedoMenuOwner = undoRedoMenuOwner;
        this.m_environment = environment;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        if (callInitializer) {
            this.initMenu();
        }
    }

    protected void initMenu() {
        this.m_swtMenu = new Menu((Decorations)this.getParentShell().getShell(), 8);
        this.createSystemMenuItems(this.m_swtMenu);
        this.m_uiMenuListener = new P_UiMenuListener();
        this.m_swtMenu.addListener(22, this.m_uiMenuListener);
        this.m_swtMenu.addListener(23, this.m_uiMenuListener);
        this.m_swtMenu.addListener(12, this.m_uiMenuListener);
    }

    protected void createSystemMenuItems(Menu swtMenu) {
        if (this.getSystemMenuOwner() != null) {
            new SwtCutMenuItem(swtMenu, this.getSystemMenuOwner());
            new SwtCopyMenuItem(swtMenu, this.getSystemMenuOwner());
            new SwtPasteMenuItem(swtMenu, this.getSystemMenuOwner());
        }
        if (this.getUndoRedoMenuOwner() != null) {
            StyledTextFieldUndoRedoSupport undoRedoSupport = new StyledTextFieldUndoRedoSupport(this.getUndoRedoMenuOwner());
            new SwtUndoMenuItem(swtMenu, undoRedoSupport);
            new SwtRedoMenuItem(swtMenu, undoRedoSupport);
        }
    }

    protected void updateUiMenu() {
        MenuItem[] menuItemArray = this.getSwtMenu().getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            if (item.getData(DATA_SYSTEM_MENU) == null) {
                item.dispose();
            }
            ++n2;
        }
        SwtMenuUtility.fillMenu(this.getSwtMenu(), this.getScoutContextMenu().getChildActions(), this.getEnvironment(), this.getSwtMenu().getItemCount() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureChildrenLoaded() {
        Boolean bl = this.m_childrenCreated;
        synchronized (bl) {
            if (!this.m_childrenCreated.booleanValue()) {
                this.m_childrenCreated = true;
            }
        }
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    public Shell getParentShell() {
        return this.m_parentShell;
    }

    public IContextMenu getScoutContextMenu() {
        return this.m_scoutContextMenu;
    }

    public ITextAccess getSystemMenuOwner() {
        return this.m_systemMenuOwner;
    }

    public StyledText getUndoRedoMenuOwner() {
        return this.m_undoRedoMenuOwner;
    }

    public Menu getSwtMenu() {
        return this.m_swtMenu;
    }

    protected void handleSwtMenuHide() {
    }

    protected void handleSwtMenuShow() {
        this.updateUiMenu();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                SwtScoutContextMenu.this.getScoutContextMenu().prepareAction();
            }
        };
        JobEx prepareJob = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            prepareJob.join(800L);
        }
        catch (InterruptedException e) {
            LOG.error("error during prepare menus.", (Throwable)e);
        }
    }

    protected void handleSwtMenuDispose() {
        this.m_swtMenu.removeListener(22, this.m_uiMenuListener);
        this.m_swtMenu.removeListener(23, this.m_uiMenuListener);
        this.m_swtMenu.removeListener(12, this.m_uiMenuListener);
        this.m_uiMenuListener = null;
    }

    private class P_UiMenuListener
    implements Listener {
        private P_UiMenuListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 22: {
                    SwtScoutContextMenu.this.handleSwtMenuShow();
                    break;
                }
                case 23: {
                    SwtScoutContextMenu.this.handleSwtMenuHide();
                    break;
                }
                case 12: {
                    SwtScoutContextMenu.this.handleSwtMenuDispose();
                }
            }
        }
    }
}

