/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.action.menu.text;

import org.eclipse.scout.rt.ui.swt.action.menu.text.ITextAccess;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;

public class StyledTextAccess
implements ITextAccess {
    private StyledText m_textControl;

    public StyledTextAccess(StyledText textControl) {
        this.m_textControl = textControl;
    }

    @Override
    public boolean isEnabled() {
        return this.m_textControl.getEnabled();
    }

    @Override
    public boolean isEditable() {
        return this.m_textControl.getEditable();
    }

    @Override
    public boolean hasSelection() {
        return this.m_textControl.getSelectionCount() > 0;
    }

    @Override
    public Point getSelection() {
        return this.m_textControl.getSelection();
    }

    @Override
    public String getText() {
        return this.m_textControl.getText();
    }

    @Override
    public String getSelectedText() {
        return this.m_textControl.getSelectionText();
    }

    public StyledText getTextControl() {
        return this.m_textControl;
    }

    @Override
    public boolean isMasked() {
        return (this.m_textControl.getStyle() & 0x400000) != 0;
    }

    @Override
    public void copy() {
        this.m_textControl.copy();
    }

    @Override
    public boolean hasTextOnClipboard() {
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.m_textControl.getDisplay());
            String contents = (String)clipboard.getContents((Transfer)plainTextTransfer, 1);
            boolean bl = contents != null && contents.length() > 0;
            return bl;
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    @Override
    public void paste() {
        this.m_textControl.paste();
    }

    @Override
    public void cut() {
        this.m_textControl.cut();
    }
}

