/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar;

import java.util.Date;
import org.eclipse.scout.rt.ui.swt.basic.calendar.CalendarModel;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.AbstractCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;

public class CalendarItemContainer
implements Comparable {
    private Object m_item;
    private boolean m_labeled;
    private long m_fromRelative;
    private long m_toRelative;
    private Rectangle m_bounds;
    private boolean m_fullDay;
    private float m_x0;
    private float m_x1;
    private AbstractCell m_cell;

    public CalendarItemContainer(Object item, AbstractCell cell) {
        Date d2;
        this.m_cell = cell;
        this.m_item = item;
        this.m_bounds = new Rectangle(1, 2, 3, 4);
        long repTimeOfDayStart = AbstractCell.getTimeOfDayMillis(this.m_cell.getDate().getTime());
        long displayInterval = 3600000L * (long)(cell.getCalendar().getEndHour() - cell.getCalendar().getStartHour());
        CalendarModel model = this.m_cell.getCalendar().getModel();
        this.m_fullDay = model.isFullDay(item);
        this.m_fromRelative = AbstractCell.getTimeOfDayMillis(model.getFromDate(item)) - repTimeOfDayStart - 3600000L * (long)cell.getCalendar().getStartHour();
        if (this.m_fromRelative < 0L) {
            this.m_fromRelative = 0L;
        }
        if (this.m_fromRelative > displayInterval) {
            this.m_fromRelative = displayInterval;
        }
        this.m_toRelative = (d2 = model.getToDate(item)) == null ? this.m_fromRelative : AbstractCell.getTimeOfDayMillis(d2) - repTimeOfDayStart - 3600000L * (long)cell.getCalendar().getStartHour();
        if (this.m_toRelative < 0L) {
            this.m_toRelative = 0L;
        }
        if (this.m_toRelative > displayInterval) {
            this.m_toRelative = displayInterval;
        }
        if (this.m_fromRelative >= displayInterval - 3600000L && this.m_toRelative >= displayInterval - (long)cell.getCalendar().getEndHour() * 3600000L) {
            this.m_fromRelative = displayInterval - 3600000L;
            this.m_toRelative = displayInterval;
        }
        if (this.m_toRelative == this.m_fromRelative) {
            this.m_toRelative = this.m_fromRelative + 3600000L;
        }
    }

    public void setHorizontalExtents(float x0, float x1) {
        this.m_x0 = x0;
        this.m_x1 = x1;
    }

    public float getX0() {
        return this.m_x0;
    }

    public float getX1() {
        return this.m_x1;
    }

    public Object getItem() {
        return this.m_item;
    }

    public void setBounds(int x, int y, int w, int h) {
        this.m_bounds.x = x;
        this.m_bounds.y = y;
        this.m_bounds.width = w;
        this.m_bounds.height = h;
    }

    public boolean contains(int x, int y) {
        return this.m_bounds.contains(x, y);
    }

    public void setLabeled(boolean on) {
        this.m_labeled = on;
    }

    public boolean isLabeled() {
        return this.m_labeled;
    }

    public boolean isTimed() {
        return !this.m_fullDay;
    }

    public String toString() {
        return this.m_item.toString();
    }

    public boolean intersects(CalendarItemContainer other) {
        if (this.m_fromRelative <= other.m_fromRelative && other.m_fromRelative < this.m_toRelative) {
            return true;
        }
        return this.m_fromRelative < other.m_toRelative && other.m_toRelative <= this.m_toRelative;
    }

    public long getFromRelative() {
        return this.m_fromRelative;
    }

    public long getToRelative() {
        return this.m_toRelative;
    }

    public Color getColor() {
        Color c = this.m_cell.getCalendar().getModel().getColor(this.m_item);
        if (c == null) {
            c = new Color((Device)SwtColors.getStandardDisplay(), this.m_cell.getBackground().getRed(), this.m_cell.getBackground().getGreen(), this.m_cell.getBackground().getBlue());
        }
        return c;
    }

    protected Date getCompareDate() {
        return this.m_cell.getCalendar().getModel().getFromDate(this.m_item);
    }

    protected Integer getCompareId() {
        return this.m_item.hashCode();
    }

    public int compareTo(Object o) {
        if (this.m_item instanceof Comparable) {
            return ((Comparable)this.m_item).compareTo(((CalendarItemContainer)o).getItem());
        }
        int i = this.getCompareDate().compareTo(((CalendarItemContainer)o).getCompareDate());
        if (i == 0) {
            i = this.getCompareId().compareTo(((CalendarItemContainer)o).getCompareId());
        }
        return i;
    }

    public boolean equals(Object o) {
        if (o == null && this.m_item == null) {
            return true;
        }
        if (o == null || this.m_item == null || !o.getClass().isAssignableFrom(this.m_item.getClass())) {
            return false;
        }
        return this.m_item.equals(o);
    }

    public int hashCode() {
        return this.m_item.hashCode();
    }
}

