/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.calendar.widgets;

import java.util.Calendar;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swt.basic.calendar.SwtColors;
import org.eclipse.scout.rt.ui.swt.basic.calendar.widgets.SwtCalendar;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class SelectionScopeBar
extends Composite {
    protected static final IScoutLogger LOG = ScoutLogManager.getLogger(SelectionScopeBar.class);
    private SwtCalendar m_calendar;
    private Button m_dayWidget;
    private Button m_workWeekWidget;
    private Button m_weekWidget;
    private Button m_monthWidget;
    private Button m_condensedWidget;
    private int m_scope;
    private int m_firstDay;
    private boolean m_condensed;

    public SelectionScopeBar(SwtCalendar parent, int style) {
        super((Composite)parent, style);
        this.m_calendar = parent;
        this.m_firstDay = Calendar.getInstance().getFirstDayOfWeek();
        this.createControls(parent);
        this.addListeners();
        this.setDisplayMode(3);
    }

    protected void createControls(Composite parent) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.setLayoutData(gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 8;
        layout.marginHeight = 8;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 0;
        layout.numColumns = 6;
        this.setLayout((Layout)layout);
        this.m_dayWidget = new Button((Composite)this, 16);
        this.m_dayWidget.setText(SwtUtility.getNlsText(Display.getCurrent(), "Day", new String[0]));
        this.m_dayWidget.setBackground(SwtColors.getInstance().getWhite());
        gd = new GridData();
        gd.horizontalAlignment = 32;
        this.m_dayWidget.setLayoutData((Object)gd);
        this.m_workWeekWidget = new Button((Composite)this, 16);
        this.m_workWeekWidget.setText(SwtUtility.getNlsText(Display.getCurrent(), "WorkWeek", new String[0]));
        this.m_workWeekWidget.setBackground(SwtColors.getInstance().getWhite());
        gd = new GridData();
        gd.horizontalAlignment = 32;
        this.m_workWeekWidget.setLayoutData((Object)gd);
        this.m_weekWidget = new Button((Composite)this, 16);
        this.m_weekWidget.setText(SwtUtility.getNlsText(Display.getCurrent(), "Week", new String[0]));
        this.m_weekWidget.setBackground(SwtColors.getInstance().getWhite());
        gd = new GridData();
        gd.horizontalAlignment = 32;
        this.m_weekWidget.setLayoutData((Object)gd);
        this.m_monthWidget = new Button((Composite)this, 16);
        this.m_monthWidget.setText(SwtUtility.getNlsText(Display.getCurrent(), "Month", new String[0]));
        this.m_monthWidget.setBackground(SwtColors.getInstance().getWhite());
        gd = new GridData();
        gd.horizontalAlignment = 32;
        this.m_monthWidget.setLayoutData((Object)gd);
        this.m_condensedWidget = new Button((Composite)this, 32);
        this.m_condensedWidget.setText(SwtUtility.getNlsText(Display.getCurrent(), "Condensed", new String[0]));
        this.m_condensedWidget.setBackground(SwtColors.getInstance().getWhite());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 3;
        this.m_condensedWidget.setLayoutData((Object)gd);
        this.setBackground(SwtColors.getInstance().getWhite());
    }

    public void setDisplayMode(int scope) {
        this.m_scope = scope;
        switch (scope) {
            case 1: {
                this.resetDisplayMode();
                this.m_dayWidget.setSelection(true);
                break;
            }
            case 4: {
                this.resetDisplayMode();
                this.m_workWeekWidget.setSelection(true);
                break;
            }
            case 2: {
                this.resetDisplayMode();
                this.m_weekWidget.setSelection(true);
                break;
            }
            case 3: {
                this.resetDisplayMode();
                this.m_monthWidget.setSelection(true);
            }
        }
    }

    public int getDisplayMode() {
        return this.m_scope;
    }

    protected void resetDisplayMode() {
        this.m_dayWidget.setSelection(false);
        this.m_workWeekWidget.setSelection(false);
        this.m_weekWidget.setSelection(false);
        this.m_monthWidget.setSelection(false);
    }

    public int getFirstDayOfWeek() {
        return this.m_firstDay;
    }

    public void setCondensedMode(boolean condensed) {
        this.m_condensed = condensed;
        this.m_condensedWidget.setSelection(condensed);
    }

    public boolean getCondensedMode() {
        return this.m_condensed;
    }

    protected void addListeners() {
        this.m_dayWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionScopeBar.this.m_calendar.setDisplayMode(1);
            }
        });
        this.m_workWeekWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionScopeBar.this.m_calendar.setDisplayMode(4);
            }
        });
        this.m_weekWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionScopeBar.this.m_calendar.setDisplayMode(2);
            }
        });
        this.m_monthWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionScopeBar.this.m_calendar.setDisplayMode(3);
            }
        });
        this.m_condensedWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionScopeBar.this.m_calendar.setCondensedMode(((Button)e.getSource()).getSelection());
            }
        });
    }

    public void dispose() {
        if (this.m_dayWidget != null && !this.m_dayWidget.isDisposed()) {
            this.m_dayWidget.dispose();
        }
        if (this.m_workWeekWidget != null && !this.m_workWeekWidget.isDisposed()) {
            this.m_workWeekWidget.dispose();
        }
        if (this.m_weekWidget != null && !this.m_weekWidget.isDisposed()) {
            this.m_weekWidget.dispose();
        }
        if (this.m_monthWidget != null && !this.m_monthWidget.isDisposed()) {
            this.m_monthWidget.dispose();
        }
        super.dispose();
    }
}

