/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.basic.tree;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.SwtMenuUtility;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.tree.ISwtScoutTree;
import org.eclipse.scout.rt.ui.swt.basic.tree.SwtScoutTreeModel;
import org.eclipse.scout.rt.ui.swt.ext.tree.TreeEx;
import org.eclipse.scout.rt.ui.swt.form.fields.AbstractSwtScoutDndSupport;
import org.eclipse.scout.rt.ui.swt.keystroke.ISwtKeyStroke;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutTree
extends SwtScoutComposite<ITree>
implements ISwtScoutTree {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutTree.class);
    private P_ScoutTreeListener m_scoutTreeListener;
    private Menu m_contextMenu;
    private TreeViewer m_treeViewer;
    private boolean m_enabledFromScout = true;
    private ISwtKeyStroke[] m_keyStrokes;
    private boolean m_ignoreSelectionEventsFromSwtToScout;

    @Override
    protected void initializeSwt(Composite parent) {
        TreeViewer viewer = this.createSwtTree(parent);
        this.setSwtTreeViewer(viewer);
        this.initializeSwtTreeModel();
        this.setSwtField((Control)viewer.getTree());
        viewer.addSelectionChangedListener((ISelectionChangedListener)new P_SwtSelectionListener());
        viewer.addTreeListener((ITreeViewerListener)new P_SwtExpansionListener());
        viewer.addDoubleClickListener((IDoubleClickListener)new P_SwtDoubleClickListener());
        P_SwtTreeListener swtTreeListener = new P_SwtTreeListener();
        viewer.getTree().addListener(4, (Listener)swtTreeListener);
        viewer.getTree().addListener(2, (Listener)swtTreeListener);
        viewer.getTree().addKeyListener((KeyListener)new P_SwtKeyReturnAvoidDoubleClickListener());
        this.m_contextMenu = new Menu((Decorations)viewer.getTree().getShell(), 8);
        this.m_contextMenu.addMenuListener((MenuListener)new P_ContextMenuListener());
        viewer.getTree().setMenu(this.m_contextMenu);
    }

    protected TreeViewer createSwtTree(Composite parent) {
        int style = this.isMultiSelect() ? 2 : 4;
        TreeEx tree = this.getEnvironment().getFormToolkit().createTree(parent, style |= 0xB00);
        tree.setLayoutDeferred(true);
        TreeViewer viewer = new TreeViewer((Tree)tree);
        viewer.setUseHashlookup(true);
        return viewer;
    }

    @Override
    public boolean isDisposed() {
        return this.getSwtField() == null || this.getSwtField().isDisposed();
    }

    protected void initializeSwtTreeModel() {
        SwtScoutTreeModel model = this.createTreeModel();
        this.getSwtTreeViewer().setContentProvider((IContentProvider)model);
        this.getSwtTreeViewer().setLabelProvider((IBaseLabelProvider)model);
        this.getSwtTreeViewer().setInput((Object)model);
    }

    protected SwtScoutTreeModel createTreeModel() {
        return new SwtScoutTreeModel((ITree)this.getScoutObject(), this.getEnvironment(), this.getSwtTreeViewer());
    }

    protected boolean isMultiSelect() {
        if (this.getScoutObject() != null) {
            return ((ITree)this.getScoutObject()).isMultiSelect();
        }
        return false;
    }

    protected boolean isDragEnabled() {
        return ((ITree)this.getScoutObject()).isDragEnabled();
    }

    protected void setSwtTreeViewer(TreeViewer viewer) {
        this.m_treeViewer = viewer;
    }

    public TreeViewer getSwtTreeViewer() {
        return this.m_treeViewer;
    }

    protected ITreeContentProvider getContentProvider() {
        return (ITreeContentProvider)this.getSwtTreeViewer().getContentProvider();
    }

    public TreeEx getSwtField() {
        return (TreeEx)super.getSwtField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTreeListener == null) {
            this.m_scoutTreeListener = new P_ScoutTreeListener();
            ((ITree)this.getScoutObject()).addUITreeListener((TreeListener)this.m_scoutTreeListener);
        }
        if (((ITree)this.getScoutObject()).isRootNodeVisible()) {
            this.setExpansionFromScout(((ITree)this.getScoutObject()).getRootNode());
        } else {
            for (ITreeNode node : ((ITree)this.getScoutObject()).getRootNode().getFilteredChildNodes()) {
                this.setExpansionFromScout(node);
            }
        }
        this.setSelectionFromScout(((ITree)this.getScoutObject()).getSelectedNodes());
        this.setKeyStrokeFormScout();
        new P_DndSupport((IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getSwtField(), this.getEnvironment());
        final IEventHistory h = ((ITree)this.getScoutObject()).getEventHistory();
        if (h != null) {
            this.getEnvironment().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (TreeEvent e : h.getRecentEvents()) {
                        SwtScoutTree.this.handleScoutTreeEventInSwt(e);
                    }
                }
            });
        }
    }

    @Override
    protected void detachScout() {
        super.detachScout();
        if (this.getScoutObject() == null) {
            return;
        }
        if (this.m_scoutTreeListener != null) {
            ((ITree)this.getScoutObject()).removeTreeListener((TreeListener)this.m_scoutTreeListener);
            this.m_scoutTreeListener = null;
        }
    }

    public void setEnabledFromScout(boolean enabled) {
        this.m_enabledFromScout = enabled;
        if (this.getSwtField() instanceof TreeEx) {
            this.getSwtField().setReadOnly(!enabled);
        } else {
            this.getSwtField().setEnabled(enabled);
        }
    }

    public boolean isEnabledFromScout() {
        return this.m_enabledFromScout;
    }

    protected void setExpansionFromScout(ITreeNode scoutNode) {
        if (scoutNode != null) {
            this.setExpansionFromScoutRec(scoutNode);
        }
    }

    private void setExpansionFromScoutRec(ITreeNode scoutNode) {
        boolean expand = scoutNode.getParentNode() == null ? true : scoutNode.isExpanded();
        List filteredChildNodes = scoutNode.getFilteredChildNodes();
        if (CollectionUtility.hasElements((Collection)filteredChildNodes) && expand != this.getSwtTreeViewer().getExpandedState((Object)scoutNode)) {
            this.getSwtTreeViewer().setExpandedState((Object)scoutNode, expand);
        }
        if (expand) {
            for (ITreeNode childNode : filteredChildNodes) {
                this.setExpansionFromScoutRec(childNode);
            }
        }
    }

    protected void setSelectionFromScout(Collection<ITreeNode> scoutNodes) {
        if (this.getSwtField().isDisposed()) {
            return;
        }
        this.getSwtTreeViewer().setSelection((ISelection)new StructuredSelection(new ArrayList<ITreeNode>(scoutNodes)));
        this.getSwtField().showSelection();
    }

    protected void setKeyStrokeFormScout() {
        if (this.m_keyStrokes != null) {
            ISwtKeyStroke[] iSwtKeyStrokeArray = this.m_keyStrokes;
            int n = this.m_keyStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                ISwtKeyStroke swtKeyStroke = iSwtKeyStrokeArray[n2];
                this.getEnvironment().removeKeyStroke((Widget)this.getSwtField(), swtKeyStroke);
                ++n2;
            }
        }
        ArrayList<ISwtKeyStroke> newSwtKeyStrokes = new ArrayList<ISwtKeyStroke>();
        for (IKeyStroke scoutKeyStroke : ((ITree)this.getScoutObject()).getKeyStrokes()) {
            ISwtKeyStroke[] swtStrokes;
            ISwtKeyStroke[] iSwtKeyStrokeArray = swtStrokes = SwtUtility.getKeyStrokes(scoutKeyStroke, this.getEnvironment());
            int n = swtStrokes.length;
            int n3 = 0;
            while (n3 < n) {
                ISwtKeyStroke swtStroke = iSwtKeyStrokeArray[n3];
                this.getEnvironment().addKeyStroke((Widget)this.getSwtField(), swtStroke);
                newSwtKeyStrokes.add(swtStroke);
                ++n3;
            }
        }
        this.m_keyStrokes = newSwtKeyStrokes.toArray(new ISwtKeyStroke[newSwtKeyStrokes.size()]);
    }

    private void updateTreeStructureAndKeepSelection(ITreeNode node) {
        if (node == ((ITree)this.getScoutObject()).getRootNode()) {
            this.getSwtTreeViewer().refresh();
        } else {
            this.getSwtTreeViewer().refresh((Object)node);
        }
    }

    protected void setSelectionFromSwt(final List<ITreeNode> nodes) {
        if (this.m_ignoreSelectionEventsFromSwtToScout) {
            return;
        }
        if (this.getUpdateSwtFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    try {
                        SwtScoutTree.this.addIgnoredScoutEvent(TreeEvent.class, "40");
                        ((ITree)SwtScoutTree.this.getScoutObject()).getUIFacade().setNodesSelectedFromUI(nodes);
                    }
                    finally {
                        SwtScoutTree.this.removeIgnoredScoutEvent(TreeEvent.class, "40");
                    }
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void setScrollToSelectionFromScout() {
        if (((ITree)this.getScoutObject()).isScrollToSelection()) {
            this.scrollToSelection();
        }
    }

    protected void scrollToSelection() {
        this.getSwtField().showSelection();
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("keyStroks")) {
            this.setKeyStrokeFormScout();
        } else if (name.equals("scrollToSelection")) {
            this.setScrollToSelectionFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }

    protected void setExpansionFromSwt(final ITreeNode node, final boolean b) {
        if (this.getUpdateSwtFromScoutLock().isAcquired()) {
            return;
        }
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    if (node.isExpanded() != b) {
                        ((ITree)SwtScoutTree.this.getScoutObject()).getUIFacade().setNodeExpandedFromUI(node, b);
                    }
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    private void ignoreSelectionEventsFromSwtToScoutUntilNextDisplayPost() {
        this.m_ignoreSelectionEventsFromSwtToScout = true;
        this.getSwtField().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SwtScoutTree.this.m_ignoreSelectionEventsFromSwtToScout = false;
            }
        });
    }

    protected boolean isHandleScoutTreeEvent(List<? extends TreeEvent> events) {
        for (TreeEvent treeEvent : events) {
            switch (treeEvent.getType()) {
                case 10: 
                case 20: 
                case 30: 
                case 40: 
                case 50: 
                case 100: 
                case 101: 
                case 400: 
                case 800: 
                case 830: 
                case 850: {
                    return true;
                }
            }
        }
        return false;
    }

    protected void handleScoutTreeEventInSwt(TreeEvent e) {
        if (this.isDisposed()) {
            return;
        }
        this.ignoreSelectionEventsFromSwtToScoutUntilNextDisplayPost();
        switch (e.getType()) {
            case 800: {
                this.getSwtField().setFocus();
                break;
            }
            case 100: 
            case 101: {
                this.setExpansionFromScout(e.getNode());
                break;
            }
            case 10: {
                this.updateTreeStructureAndKeepSelection(e.getCommonParentNode());
                this.setExpansionFromScout(e.getCommonParentNode());
                break;
            }
            case 850: {
                this.updateTreeNode(e.getNode());
                break;
            }
            case 20: {
                ISelection oldSelection = this.getSwtTreeViewer().getSelection();
                StructuredSelection newSelection = new StructuredSelection((List)CollectionUtility.arrayList((Collection)((ITree)this.getScoutObject()).getSelectedNodes()));
                this.updateTreeStructureAndKeepSelection(e.getCommonParentNode());
                if (!newSelection.equals(oldSelection)) {
                    this.getSwtTreeViewer().setSelection((ISelection)newSelection);
                }
                this.setExpansionFromScout(e.getCommonParentNode());
                break;
            }
            case 30: {
                this.updateTreeStructureAndKeepSelection(e.getCommonParentNode());
                this.setExpansionFromScout(e.getCommonParentNode());
                break;
            }
            case 400: {
                this.updateTreeStructureAndKeepSelection(((ITree)this.getScoutObject()).getRootNode());
                this.setExpansionFromScout(((ITree)this.getScoutObject()).getRootNode());
                if (this.getSwtField().getSelectionCount() != 0 || this.getSwtField().getItemCount() <= 0) break;
                this.getSwtField().showItem(this.getSwtField().getItem(0));
                break;
            }
            case 50: {
                this.updateTreeStructureAndKeepSelection(e.getCommonParentNode());
                this.setExpansionFromScout(e.getCommonParentNode());
                break;
            }
            case 40: {
                this.setSelectionFromScout(e.getNodes());
                break;
            }
            case 830: {
                this.scrollToSelection();
            }
        }
    }

    protected void updateTreeNode(ITreeNode node) {
        this.getSwtTreeViewer().update((Object)node, null);
    }

    protected void handleSwtNodeClick(final ITreeNode node) {
        if (this.getScoutObject() != null && node != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITree)SwtScoutTree.this.getScoutObject()).getUIFacade().fireNodeClickFromUI(node);
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    protected void handleSwtNodeAction(final ITreeNode node) {
        if (this.getScoutObject() != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITree)SwtScoutTree.this.getScoutObject()).getUIFacade().fireNodeActionFromUI(node);
                }
            };
            this.getEnvironment().invokeScoutLater(t, 400L);
        }
    }

    protected void handleSwtHyperlinkAction(final ITreeNode node, final URL url) {
        if (this.getScoutObject() != null && node != null) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITree)SwtScoutTree.this.getScoutObject()).getUIFacade().fireHyperlinkActionFromUI(node, url);
                }
            };
            this.getEnvironment().invokeScoutLater(t, 0L);
        }
    }

    public static TreePath scoutNodeToTreePath(ITreeNode scoutNode) {
        if (scoutNode == null) {
            return null;
        }
        Object[] path = SwtScoutTree.getPathToRoot(scoutNode, 0);
        return new TreePath(path);
    }

    public static TreePath[] scoutNodesToTreePaths(ITreeNode[] scoutNodes) {
        if (scoutNodes == null) {
            return new TreePath[0];
        }
        TreePath[] paths = new TreePath[scoutNodes.length];
        int i = 0;
        while (i < scoutNodes.length) {
            paths[i] = SwtScoutTree.scoutNodeToTreePath(scoutNodes[i]);
            ++i;
        }
        return paths;
    }

    public static ITreeNode[] getPathToRoot(ITreeNode scoutNode, int depth) {
        ITreeNode[] retNodes;
        if (scoutNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new ITreeNode[depth];
        } else {
            retNodes = scoutNode.getParentNode() == null ? new ITreeNode[depth] : SwtScoutTree.getPathToRoot(scoutNode.getParentNode(), ++depth);
            retNodes[retNodes.length - depth] = scoutNode;
        }
        return retNodes;
    }

    private class P_ContextMenuListener
    extends MenuAdapter {
        private P_ContextMenuListener() {
        }

        public void menuShown(MenuEvent e) {
            if (SwtScoutTree.this.m_contextMenu != null) {
                MenuItem[] menuItemArray = SwtScoutTree.this.m_contextMenu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    this.disposeMenuItem(item);
                    ++n2;
                }
            }
            if (SwtScoutTree.this.getScoutObject() == null || !SwtScoutTree.this.isEnabledFromScout()) {
                return;
            }
            boolean emptySpace = SwtScoutTree.this.getSwtField().getContextItem() == null;
            List<IMenu> menus = SwtMenuUtility.collectMenus((ITree)SwtScoutTree.this.getScoutObject(), emptySpace, !emptySpace, SwtScoutTree.this.getEnvironment());
            SwtMenuUtility.fillMenu(SwtScoutTree.this.m_contextMenu, menus, SwtScoutTree.this.getEnvironment());
        }

        private void disposeMenuItem(MenuItem item) {
            Menu menu = item.getMenu();
            if (menu != null) {
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem childItem = menuItemArray[n2];
                    this.disposeMenuItem(childItem);
                    ++n2;
                }
                menu.dispose();
            }
            item.dispose();
        }
    }

    private class P_DndSupport
    extends AbstractSwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control, ISwtEnvironment environment) {
            super(scoutObject, scoutDndSupportable, control, environment);
        }

        @Override
        protected DragSource createDragSource(Control control) {
            if (SwtScoutTree.this.isDragEnabled()) {
                return new DragSource(control, 3);
            }
            return null;
        }

        @Override
        protected TransferObject handleSwtDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((ITree)SwtScoutTree.this.getScoutObject()).getUIFacade().fireNodesDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            try {
                SwtScoutTree.this.getEnvironment().invokeScoutLater(t, 20000L).join(20000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Exception occurred while drag request: ", (Throwable)e);
            }
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleSwtDragFinished() {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    ((ITree)SwtScoutTree.this.getScoutObject()).getUIFacade().fireDragFinishedFromUI();
                }
            };
            try {
                SwtScoutTree.this.getEnvironment().invokeScoutLater(t, 20000L).join(20000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Exception occurred while drag finished: ", (Throwable)e);
            }
        }

        @Override
        protected void handleSwtDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Object dropTarget = event.item != null ? event.item.getData() : null;
            final ITreeNode node = dropTarget instanceof ITreeNode ? (ITreeNode)dropTarget : null;
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    ((ITree)SwtScoutTree.this.getScoutObject()).getUIFacade().fireNodeDropActionFromUI(node, scoutTransferObject);
                }
            };
            SwtScoutTree.this.getEnvironment().invokeScoutLater(job, 200L);
        }

        @Override
        protected void handleSwtDropTargetChanged(DropTargetEvent event) {
            Object dropTarget = event.item != null ? event.item.getData() : null;
            final ITreeNode node = dropTarget instanceof ITreeNode ? (ITreeNode)dropTarget : null;
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    ((ITree)SwtScoutTree.this.getScoutObject()).getUIFacade().fireNodeDropTargetChangedFromUI(node);
                }
            };
            SwtScoutTree.this.getEnvironment().invokeScoutLater(job, 200L);
        }
    }

    private class P_ScoutTreeListener
    implements TreeListener {
        private P_ScoutTreeListener() {
        }

        public void treeChanged(final TreeEvent e) {
            if (SwtScoutTree.this.isHandleScoutTreeEvent(CollectionUtility.arrayList((Object)e))) {
                if (SwtScoutTree.this.isIgnoredScoutEvent(TreeEvent.class, "" + e.getType())) {
                    return;
                }
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SwtScoutTree.this.getUpdateSwtFromScoutLock().acquire();
                            SwtScoutTree.this.handleScoutTreeEventInSwt(e);
                        }
                        finally {
                            SwtScoutTree.this.getUpdateSwtFromScoutLock().release();
                        }
                    }
                };
                SwtScoutTree.this.getEnvironment().invokeSwtLater(t);
            }
        }

        public void treeChangedBatch(List<? extends TreeEvent> events) {
            if (SwtScoutTree.this.isHandleScoutTreeEvent(events)) {
                final ArrayList<TreeEvent> filteredList = new ArrayList<TreeEvent>();
                for (TreeEvent treeEvent : events) {
                    if (SwtScoutTree.this.isIgnoredScoutEvent(TreeEvent.class, "" + treeEvent.getType())) continue;
                    filteredList.add(treeEvent);
                }
                if (CollectionUtility.hasElements(filteredList)) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SwtScoutTree.this.getUpdateSwtFromScoutLock().acquire();
                                if (!SwtScoutTree.this.getSwtField().isDisposed()) {
                                    SwtScoutTree.this.getSwtField().setRedraw(false);
                                }
                                for (TreeEvent element : filteredList) {
                                    SwtScoutTree.this.handleScoutTreeEventInSwt(element);
                                }
                            }
                            finally {
                                SwtScoutTree.this.getUpdateSwtFromScoutLock().release();
                                if (!SwtScoutTree.this.getSwtField().isDisposed()) {
                                    SwtScoutTree.this.getSwtField().setRedraw(true);
                                }
                            }
                        }
                    };
                    SwtScoutTree.this.getEnvironment().invokeSwtLater(runnable);
                }
            }
        }
    }

    private class P_SwtDoubleClickListener
    implements IDoubleClickListener {
        private P_SwtDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            StructuredSelection sel;
            ITreeNode[] nodes;
            if (event.getSelection() instanceof StructuredSelection && (nodes = (sel = (StructuredSelection)event.getSelection()).toList().toArray(new ITreeNode[sel.size()])) != null && nodes.length == 1) {
                if (!nodes[0].isLeaf()) {
                    SwtScoutTree.this.setExpansionFromSwt(nodes[0], !SwtScoutTree.this.getSwtTreeViewer().getExpandedState((Object)nodes[0]));
                } else {
                    SwtScoutTree.this.handleSwtNodeAction(nodes[0]);
                    if (((ITree)SwtScoutTree.this.getScoutObject()).isCheckable()) {
                        SwtScoutTree.this.handleSwtNodeClick(nodes[0]);
                    }
                }
            }
        }
    }

    private class P_SwtExpansionListener
    implements ITreeViewerListener {
        private P_SwtExpansionListener() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            SwtScoutTree.this.setExpansionFromSwt((ITreeNode)event.getElement(), false);
        }

        public void treeExpanded(TreeExpansionEvent event) {
            SwtScoutTree.this.setExpansionFromSwt((ITreeNode)event.getElement(), true);
        }
    }

    private class P_SwtKeyReturnAvoidDoubleClickListener
    implements KeyListener {
        private P_SwtKeyReturnAvoidDoubleClickListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e != null && (e.keyCode == 13 || e.keyCode == 0x1000050)) {
                e.doit = false;
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }

    private class P_SwtSelectionListener
    implements ISelectionChangedListener {
        private P_SwtSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (SwtScoutTree.this.isEnabledFromScout()) {
                StructuredSelection sel = (StructuredSelection)event.getSelection();
                SwtScoutTree.this.setSelectionFromSwt(sel.toList());
            }
        }
    }

    private class P_SwtTreeListener
    implements Listener {
        private P_SwtTreeListener() {
        }

        public void handleEvent(Event e) {
            switch (e.type) {
                case 4: {
                    ViewerCell cell;
                    if (e.count != 1 || (cell = SwtScoutTree.this.getSwtTreeViewer().getCell(new Point(e.x, e.y))) == null || !(cell.getElement() instanceof ITreeNode)) break;
                    ITreeNode nodeToClick = (ITreeNode)cell.getElement();
                    if (((ITree)SwtScoutTree.this.getScoutObject()).isCheckable()) {
                        Rectangle imgBounds = cell.getImageBounds();
                        if (imgBounds == null || e.x < imgBounds.x || e.x > imgBounds.x + imgBounds.width) break;
                        SwtScoutTree.this.handleSwtNodeClick(nodeToClick);
                        break;
                    }
                    SwtScoutTree.this.handleSwtNodeClick(nodeToClick);
                    break;
                }
                case 2: {
                    if (!((ITree)SwtScoutTree.this.getScoutObject()).isCheckable() || e.stateMask != 0) break;
                    switch (e.keyCode) {
                        case 32: {
                            StructuredSelection sel = (StructuredSelection)SwtScoutTree.this.getSwtTreeViewer().getSelection();
                            ITreeNode[] nodes = sel.toList().toArray(new ITreeNode[sel.size()]);
                            if (nodes != null && nodes.length > 0) {
                                SwtScoutTree.this.handleSwtNodeClick(nodes[0]);
                            }
                            e.doit = false;
                        }
                    }
                }
            }
        }
    }
}

