/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import java.util.EventListener;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SnapButtonMaximized
extends Canvas {
    private String m_text;
    private Image m_image;
    private boolean m_selected;
    private EventListenerList m_eventListener = new EventListenerList();
    private boolean m_mouseHover;
    private boolean m_focussed;
    private Listener m_controlListener = new P_ControlListener();
    private int m_gap = 5;
    private int m_insets = 2;
    private int m_borderInsets = 3;
    private int m_borderWidth = 1;
    private Color m_borderColor;
    private Color m_selectedBackground;

    public SnapButtonMaximized(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new P_PaintListener());
        this.attachListeners();
        this.m_borderColor = new Color((Device)this.getDisplay(), 52, 1, 197);
        this.m_selectedBackground = new Color((Device)this.getDisplay(), 200, 212, 249);
        this.setCursor(this.getDisplay().getSystemCursor(21));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SnapButtonMaximized.this.freeResources();
            }
        });
    }

    public void freeResources() {
        this.detachListeners();
        this.m_borderColor.dispose();
        this.m_selectedBackground.dispose();
    }

    protected void attachListeners() {
        this.addListener(15, this.m_controlListener);
        this.addListener(16, this.m_controlListener);
        this.addListener(6, this.m_controlListener);
        this.addListener(7, this.m_controlListener);
        this.addListener(4, this.m_controlListener);
    }

    protected void detachListeners() {
        this.removeListener(15, this.m_controlListener);
        this.removeListener(16, this.m_controlListener);
        this.removeListener(6, this.m_controlListener);
        this.removeListener(7, this.m_controlListener);
        this.removeListener(4, this.m_controlListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.m_eventListener.add(SelectionListener.class, (EventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.m_eventListener.remove(SelectionListener.class, (EventListener)listener);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
    }

    public Image getImage() {
        return this.m_image;
    }

    public void setImage(Image image) {
        this.m_image = image;
        this.redraw();
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
        this.redraw();
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        int x = 0;
        int y = 0;
        if (this.getImage() != null) {
            Rectangle imgBounds = this.getImage().getBounds();
            x += imgBounds.width;
            y = Math.max(y, imgBounds.height);
        }
        if (this.getText() != null) {
            GC gc = null;
            try {
                gc = new GC((Drawable)this);
                Point textSize = gc.stringExtent(this.getText());
                x += textSize.x + this.m_gap;
                y = Math.max(textSize.y, y);
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
            }
        }
        return new Point(x += this.m_insets * 2 + this.m_borderInsets * 2 + this.m_borderWidth * 2, y += this.m_insets * 2 + this.m_borderInsets * 2 + this.m_borderWidth * 2);
    }

    private void handleSwtSelecion(Event e) {
        SelectionListener[] selectionListenerArray = (SelectionListener[])this.m_eventListener.getListeners(SelectionListener.class);
        int n = selectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SelectionListener listener = selectionListenerArray[n2];
            listener.widgetSelected(new SelectionEvent(e));
            ++n2;
        }
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public void setSelected(boolean selected) {
        this.m_selected = selected;
        this.redraw();
    }

    private class P_ControlListener
    implements Listener {
        private P_ControlListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 15: {
                    SnapButtonMaximized.this.m_focussed = true;
                    break;
                }
                case 16: {
                    SnapButtonMaximized.this.m_focussed = false;
                    break;
                }
                case 6: {
                    SnapButtonMaximized.this.m_mouseHover = true;
                    break;
                }
                case 7: {
                    SnapButtonMaximized.this.m_mouseHover = false;
                    break;
                }
                case 4: {
                    SnapButtonMaximized.this.handleSwtSelecion(event);
                }
            }
            SnapButtonMaximized.this.redraw();
        }
    }

    private class P_PaintListener
    implements PaintListener {
        private P_PaintListener() {
        }

        public void paintControl(PaintEvent e) {
            Rectangle bounds = SnapButtonMaximized.this.getClientArea();
            GC gc = e.gc;
            gc.setAdvanced(true);
            int inset = SnapButtonMaximized.this.m_insets;
            int borderWidth = SnapButtonMaximized.this.m_borderWidth;
            if (SnapButtonMaximized.this.m_mouseHover) {
                --inset;
                ++borderWidth;
            }
            gc.setBackground(SnapButtonMaximized.this.m_borderColor);
            gc.fillRoundRectangle(inset, inset, bounds.width - inset, bounds.height - inset, 5, 5);
            gc.setBackground(SnapButtonMaximized.this.getBackground());
            if (SnapButtonMaximized.this.isSelected()) {
                gc.setBackground(SnapButtonMaximized.this.m_selectedBackground);
            }
            gc.fillRoundRectangle(inset + borderWidth, inset + borderWidth, bounds.width - inset - 2 * borderWidth, bounds.height - inset - 2 * borderWidth, 5, 5);
            bounds.x = bounds.x + inset + borderWidth + SnapButtonMaximized.this.m_borderInsets;
            bounds.y = bounds.y + inset + borderWidth + SnapButtonMaximized.this.m_borderInsets;
            bounds.width -= 2 * (inset + borderWidth + SnapButtonMaximized.this.m_borderInsets);
            bounds.height -= 2 * (inset + borderWidth + SnapButtonMaximized.this.m_borderInsets);
            if (SnapButtonMaximized.this.getImage() != null) {
                gc.drawImage(SnapButtonMaximized.this.getImage(), bounds.x, bounds.y);
                bounds.x += SnapButtonMaximized.this.getImage().getBounds().width + SnapButtonMaximized.this.m_gap;
            }
            if (SnapButtonMaximized.this.getText() != null) {
                gc.drawText(SnapButtonMaximized.this.getText(), bounds.x, bounds.y);
            }
        }
    }
}

