/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.ext;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.ScoutFieldStatus;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.basic.comp.CLabelEx;
import org.eclipse.scout.rt.ui.swt.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.swt.extension.UiDecorationExtensionPoint;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class StatusLabelEx
extends Composite
implements ILabelComposite {
    private final ISwtEnvironment m_environment;
    private IProcessingStatus m_status;
    private boolean m_mandatory;
    private boolean m_enabled;
    private Control m_label;
    private Label m_statusLabel;
    private final Image m_infoImg;
    private final Image m_warningImg;
    private final Image m_errorImg;
    private String m_preMarker = "";
    private String m_postMarker = "";
    private Font m_nonMandatoryFont;
    protected Font m_mandatoryFont;
    private Color m_nonMandatoryForegroundColor;
    protected Color m_mandatoryForegroundColor;
    private String m_nonMandatoryText = "";
    private Control m_mnemonicFocusControl;

    public StatusLabelEx(Composite parent, int style, ISwtEnvironment environment) {
        super(parent, 524288);
        this.m_environment = environment;
        this.m_infoImg = Activator.getIcon("status_info");
        this.m_warningImg = Activator.getIcon("status_warning");
        this.m_errorImg = Activator.getIcon("status_error");
        this.createContent(this, style);
        this.createLayout();
        this.m_nonMandatoryFont = this.m_label.getFont();
        this.m_nonMandatoryForegroundColor = this.m_label.getForeground();
        this.m_enabled = super.getEnabled();
    }

    protected void createLayout() {
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.horizontalSpacing = 0;
        containerLayout.marginHeight = 0;
        containerLayout.marginWidth = 0;
        containerLayout.verticalSpacing = 0;
        this.setLayout((Layout)containerLayout);
    }

    protected void createContent(Composite parent, int style) {
        this.m_label = new CLabelEx(parent, style | this.m_environment.getFormToolkit().getFormToolkit().getOrientation());
        this.m_label.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == StatusLabelEx.this.m_label && event.detail == 128) {
                    char mnemonic = StatusLabelEx.this.findMnemonicCharakter(StatusLabelEx.this.getText());
                    if (mnemonic == '\u0000') {
                        return;
                    }
                    if (Character.toUpperCase(event.character) != Character.toUpperCase(mnemonic)) {
                        return;
                    }
                    event.doit = false;
                    if (StatusLabelEx.this.getMnemonicFocusControl() != null && !StatusLabelEx.this.getMnemonicFocusControl().isDisposed()) {
                        StatusLabelEx.this.getMnemonicFocusControl().setFocus();
                    }
                }
            }
        });
        this.m_environment.getFormToolkit().getFormToolkit().adapt(this.m_label, false, false);
        this.m_statusLabel = new Label(parent, 0);
        this.m_environment.getFormToolkit().getFormToolkit().adapt((Control)this.m_statusLabel, false, false);
        GridData data = new GridData(131072, 0x1000000, false, false);
        this.m_statusLabel.setLayoutData((Object)data);
        data = new GridData(4, 4, true, true);
        this.m_label.setLayoutData((Object)data);
    }

    protected void initMandatorySettings() {
        int starPos;
        String labelTextColor;
        FontSpec labelFontSpec;
        if (this.m_mandatoryFont == null && (labelFontSpec = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryLabelFont()) != null) {
            this.m_mandatoryFont = this.getEnvironment().getFont(labelFontSpec, this.getNonMandatoryFont());
        }
        if (this.m_mandatoryForegroundColor == null && (labelTextColor = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryLabelTextColor()) != null) {
            this.m_mandatoryForegroundColor = this.getEnvironment().getColor(labelTextColor);
        }
        if (!StringUtility.hasText((String)this.m_postMarker) && !StringUtility.hasText((String)this.m_preMarker) && (starPos = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryStarMarkerPosition()) != 0) {
            switch (starPos) {
                case 2: {
                    this.m_postMarker = "*";
                    break;
                }
                case 1: {
                    this.m_preMarker = "*";
                }
            }
        }
    }

    protected char findMnemonicCharakter(String string) {
        int index = 0;
        if (StringUtility.isNullOrEmpty((String)string)) {
            return '\u0000';
        }
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    @Override
    public Control getMnemonicFocusControl() {
        return this.m_mnemonicFocusControl;
    }

    @Override
    public void setMnemonicFocusControl(Control mnemonicFocusControl) {
        this.m_mnemonicFocusControl = mnemonicFocusControl;
    }

    @Override
    public void setLayoutWidthHint(int w) {
        Object o = this.getLayoutData();
        if (o instanceof LogicalGridData) {
            LogicalGridData data = (LogicalGridData)o;
            data.widthHint = w;
        }
    }

    @Override
    public boolean setMandadatory(boolean mandatory) {
        if (this.isMandatory() == mandatory) {
            return false;
        }
        this.m_mandatory = mandatory;
        if (mandatory) {
            this.initMandatorySettings();
        }
        boolean updateLayout = false;
        if (this.getMandatoryFont() != null) {
            this.updateLabelFont();
            updateLayout = true;
        }
        if (this.getMandatoryForegroundColor() != null) {
            this.updateLabelForeground();
            updateLayout = true;
        }
        if (this.getPostMarker() != null || this.getPreMarker() != null) {
            this.updateText();
            updateLayout = true;
        }
        return updateLayout;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        if (enabled) {
            this.setForeground(null);
        } else {
            this.setForeground(this.getEnvironment().getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled()));
        }
    }

    @Override
    public boolean getEnabled() {
        return this.m_enabled;
    }

    protected void updateLabelForeground() {
        if (this.isEnabled() && this.isMandatory()) {
            this.m_label.setForeground(this.getMandatoryForegroundColor());
        } else {
            this.m_label.setForeground(this.getNonMandatoryForegroundColor());
        }
    }

    protected void updateLabelFont() {
        if (this.isMandatory()) {
            this.m_label.setFont(this.getMandatoryFont());
        } else {
            this.m_label.setFont(this.getNonMandatoryFont());
        }
    }

    protected void updateText() {
        if (this.isMandatory()) {
            this.setLabelText(String.valueOf(this.m_preMarker) + this.getNonMandatoryText() + this.m_postMarker);
        } else {
            this.setLabelText(this.getNonMandatoryText());
        }
    }

    protected void setLabelText(String text) {
        if (this.m_label instanceof CLabel) {
            ((CLabel)this.m_label).setText(text);
        }
    }

    protected String getLabelText() {
        if (this.m_label instanceof CLabel) {
            return ((CLabel)this.m_label).getText();
        }
        return null;
    }

    @Override
    public void setStatus(IProcessingStatus status) {
        this.m_status = status;
        if (this.m_status == null) {
            this.getStatusLabel().setToolTipText("");
            this.getStatusLabel().setImage(null);
            this.getStatusLabel().setVisible(false);
            if (this.getStatusLabel().getLayoutData() instanceof GridData) {
                ((GridData)this.getStatusLabel().getLayoutData()).exclude = true;
            }
        } else {
            String iconId;
            String string = iconId = this.m_status instanceof ScoutFieldStatus ? ((ScoutFieldStatus)this.m_status).getIconId() : null;
            if (iconId != null) {
                this.getStatusLabel().setImage(this.getEnvironment().getIcon(iconId));
            } else {
                switch (this.m_status.getSeverity()) {
                    case 4: 
                    case 16: {
                        this.getStatusLabel().setImage(this.m_errorImg);
                        break;
                    }
                    case 2: {
                        this.getStatusLabel().setImage(this.m_warningImg);
                        break;
                    }
                    default: {
                        this.getStatusLabel().setImage(this.m_infoImg);
                    }
                }
            }
            StringBuffer buf = new StringBuffer();
            if (this.m_status.getTitle() != null) {
                buf.append(this.m_status.getTitle());
            }
            if (this.m_status.getMessage() != null) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(this.m_status.getMessage());
            }
            this.getStatusLabel().setToolTipText(buf.toString());
            this.getStatusLabel().setVisible(true);
            if (this.getStatusLabel().getLayoutData() instanceof GridData) {
                ((GridData)this.getStatusLabel().getLayoutData()).exclude = false;
            }
        }
        this.layout(true, true);
    }

    @Override
    public String getText() {
        return this.getLabelText();
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.m_nonMandatoryText = text;
        this.updateText();
    }

    public Color getBackground() {
        return this.m_label.getBackground();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.m_label.setBackground(color);
    }

    @Override
    public Color getForeground() {
        return this.m_label.getForeground();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.m_nonMandatoryForegroundColor = color;
        this.updateLabelForeground();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.m_nonMandatoryFont = font;
        this.updateLabelFont();
    }

    @Override
    public Font getFont() {
        return this.m_label.getFont();
    }

    public Font getNonMandatoryFont() {
        return this.m_nonMandatoryFont;
    }

    public void setNonMandatoryFont(Font nonMandatoryFont) {
        this.m_nonMandatoryFont = nonMandatoryFont;
    }

    public Font getMandatoryFont() {
        return this.m_mandatoryFont;
    }

    public void setMandatoryFont(Font mandatoryFont) {
        this.m_mandatoryFont = mandatoryFont;
    }

    public Color getNonMandatoryForegroundColor() {
        return this.m_nonMandatoryForegroundColor;
    }

    public void setNonMandatoryForegroundColor(Color nonMandatoryForegroundColor) {
        this.m_nonMandatoryForegroundColor = nonMandatoryForegroundColor;
    }

    public Color getMandatoryForegroundColor() {
        return this.m_mandatoryForegroundColor;
    }

    public void setMandatoryForegroundColor(Color mandatoryForegroundColor) {
        this.m_mandatoryForegroundColor = mandatoryForegroundColor;
    }

    public String getPreMarker() {
        return this.m_preMarker;
    }

    public String getPostMarker() {
        return this.m_postMarker;
    }

    public Label getStatusLabel() {
        return this.m_statusLabel;
    }

    protected void setStatusLabel(Label statusLabel) {
        this.m_statusLabel = statusLabel;
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public String getNonMandatoryText() {
        return this.m_nonMandatoryText;
    }

    protected void setLabel(Control label) {
        this.m_label = label;
    }

    public Control getLabel() {
        return this.m_label;
    }
}

