/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.extension;

import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.extension.ILookAndFeelDecorations;
import org.eclipse.scout.rt.ui.swt.extension.ILookAndFeelProperties;
import org.eclipse.scout.rt.ui.swt.extension.IUiDecoration;
import org.eclipse.scout.rt.ui.swt.extension.internal.LookAndFeelDecorations;
import org.eclipse.scout.rt.ui.swt.extension.internal.LookAndFeelProperties;
import org.eclipse.scout.rt.ui.swt.extension.internal.UiDecoration;

public final class UiDecorationExtensionPoint {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(UiDecorationExtensionPoint.class);
    private static final UiDecoration LOOK_AND_FEEL = new UiDecoration();
    public static final int SCOPE_DEFAULT = 1;
    public static final int SCOPE_GLOBAL = 2;

    static {
        ArrayList<ILookAndFeelProperties> propertyExtensions = new ArrayList<ILookAndFeelProperties>();
        ArrayList<ILookAndFeelDecorations> decorationExtensions = new ArrayList<ILookAndFeelDecorations>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.rt.ui.swt", "lookAndFeel");
        IExtension[] extensions = xp.getExtensions();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if ("properties".equals(element.getName())) {
                    propertyExtensions.add(UiDecorationExtensionPoint.parseProperties(element));
                } else if ("decorations".equals(element.getName())) {
                    decorationExtensions.add(UiDecorationExtensionPoint.parseDecorations(element));
                }
                ++n4;
            }
            ++n2;
        }
        TreeMap<Integer, ILookAndFeelDecorations> decorations = new TreeMap<Integer, ILookAndFeelDecorations>();
        for (ILookAndFeelDecorations dec : decorationExtensions) {
            int scope = dec.getScope();
            if (decorations.get(scope) != null) {
                LOG.warn("multiple look and feel extension found with scope '" + scope + "'");
                continue;
            }
            decorations.put(scope, dec);
        }
        if (decorations.size() > 0) {
            ILookAndFeelDecorations dec = (ILookAndFeelDecorations)decorations.get(decorations.lastKey());
            if (dec.getMandatoryFieldBackgroundColor() != null) {
                LOOK_AND_FEEL.setMandatoryFieldBackgroundColor(dec.getMandatoryFieldBackgroundColor());
            }
            if (dec.getMandatoryLabelFont() != null) {
                LOOK_AND_FEEL.setMandatoryLabelFont(dec.getMandatoryLabelFont());
            }
            if (dec.getMandatoryLabelTextColor() != null) {
                LOOK_AND_FEEL.setMandatoryLabelTextColor(dec.getMandatoryLabelTextColor());
            }
            if (dec.getStarMarkerPosition() != 0) {
                LOOK_AND_FEEL.setMandatoryStarMarkerPosition(dec.getStarMarkerPosition());
            }
        }
        TreeMap<Integer, ILookAndFeelProperties> properties = new TreeMap<Integer, ILookAndFeelProperties>();
        for (ILookAndFeelProperties props : propertyExtensions) {
            int scope = props.getScope();
            if (properties.get(scope) != null) {
                LOG.warn("multiple look and feel extension found with scope '" + scope + "'");
                continue;
            }
            properties.put(scope, props);
        }
        for (ILookAndFeelProperties props : properties.values()) {
            int gridRowHeight;
            int propActivationButtonHeight;
            if (props.getPropertyInt("dialog.minHeight") != 0) {
                LOOK_AND_FEEL.setDialogMinHeight(props.getPropertyInt("dialog.minHeight"));
            }
            if (props.getPropertyInt("dialog.minWidth") != 0) {
                LOOK_AND_FEEL.setDialogMinWidth(props.getPropertyInt("dialog.minWidth"));
            }
            if ((propActivationButtonHeight = props.getPropertyInt("formfield.activationButton.height")) > 0) {
                LOOK_AND_FEEL.setFormFieldActivationButtonHeight(propActivationButtonHeight);
            } else {
                LOOK_AND_FEEL.setFormFieldActivationButtonHeight(UiDecorationExtensionPoint.getSystemRowHeight());
            }
            if (props.getPropertyInt("formfield.activationButton.width") != 0) {
                LOOK_AND_FEEL.setFormFieldActivationButtonWidth(props.getPropertyInt("formfield.activationButton.width"));
            }
            if (props.getPropertyInt("formfield.activationButtonWithMenu.width") != 0) {
                LOOK_AND_FEEL.setFormFieldActivationButtonWithMenuWidth(props.getPropertyInt("formfield.activationButtonWithMenu.width"));
            }
            if (props.getPropertyInt("formFieldLabel.Width") != 0) {
                LOOK_AND_FEEL.setFormFieldLabelWidth(props.getPropertyInt("formFieldLabel.Width"));
            }
            if (props.getPropertyString("formFieldLabel.alignment") != null) {
                String extFormFieldAlignment = props.getPropertyString("formFieldLabel.alignment");
                if ("center".equalsIgnoreCase(extFormFieldAlignment)) {
                    LOOK_AND_FEEL.setFormFieldLabelAlignment(0x1000000);
                } else if ("left".equalsIgnoreCase(extFormFieldAlignment)) {
                    LOOK_AND_FEEL.setFormFieldLabelAlignment(16384);
                } else if ("right".equalsIgnoreCase(extFormFieldAlignment)) {
                    LOOK_AND_FEEL.setFormFieldLabelAlignment(131072);
                } else {
                    LOG.warn("the value '" + extFormFieldAlignment + "' is not valid for the property '" + "formFieldLabel.alignment" + "'. Expected values are[right,left,center]");
                }
            }
            if (props.getPropertyInt("logicalGridLayout.defaultColumnWidth") != 0) {
                LOOK_AND_FEEL.setLogicalGridLayoutDefaultColumnWidth(props.getPropertyInt("logicalGridLayout.defaultColumnWidth"));
            }
            if (props.getPropertyInt("logicalGridLayout.horizontalGap") != 0) {
                LOOK_AND_FEEL.setLogicalGridLayoutHorizontalGap(props.getPropertyInt("logicalGridLayout.horizontalGap"));
            }
            if ((gridRowHeight = props.getPropertyInt("logicalGridLayout.rowHeight")) > 1) {
                LOOK_AND_FEEL.setLogicalGridLayoutRowHeight(gridRowHeight);
            } else {
                LOOK_AND_FEEL.setLogicalGridLayoutRowHeight(UiDecorationExtensionPoint.getSystemRowHeight());
            }
            if (props.getPropertyInt("logicalGridLayout.verticalGap") != 0) {
                LOOK_AND_FEEL.setLogicalGridLayoutVerticalGap(props.getPropertyInt("logicalGridLayout.verticalGap"));
            }
            if (props.getPropertyInt("processButton.height") != 0) {
                LOOK_AND_FEEL.setProcessButtonHeight(props.getPropertyInt("processButton.height"));
            }
            if (props.getPropertyInt("processButton.maxWidth") != 0) {
                LOOK_AND_FEEL.setProcessButtonMaxWidth(props.getPropertyInt("processButton.maxWidth"));
            }
            if (props.getPropertyInt("processButton.minWidth") != 0) {
                LOOK_AND_FEEL.setProcessButtonMinWidth(props.getPropertyInt("processButton.minWidth"));
            }
            if (props.getPropertyString("color.foreground.disabled") != null) {
                LOOK_AND_FEEL.setColorForegroundDisabled(props.getPropertyString("color.foreground.disabled"));
            }
            if (props.getPropertyString("color.background.disabled") != null && StringUtility.isNullOrEmpty((String)LOOK_AND_FEEL.getMandatoryFieldBackgroundColor())) {
                LOOK_AND_FEEL.setColorBackgroundDisabled(props.getPropertyString("color.background.disabled"));
            }
            if (props.getPropertyString("messageBox.minWidth") != null) {
                LOOK_AND_FEEL.setMessageBoxMinWidth(props.getPropertyInt("messageBox.minWidth"));
            }
            if (props.getPropertyString("messageBox.minHeight") != null) {
                LOOK_AND_FEEL.setMessageBoxMinHeight(props.getPropertyInt("messageBox.minHeight"));
            }
            if (props.getPropertyString("table.mouseMoveSelectionSupport.enabled") != null) {
                LOOK_AND_FEEL.setTableMouseMoveSelectionSupportEnabled(props.getPropertyBool("table.mouseMoveSelectionSupport.enabled"));
            }
            if (props.getPropertyString("table.multilineTooltipSupport.enabled") == null) continue;
            LOOK_AND_FEEL.setTableMultilineTooltipSupportEnabled(props.getPropertyBool("table.multilineTooltipSupport.enabled"));
        }
    }

    private UiDecorationExtensionPoint() {
    }

    public static IUiDecoration getLookAndFeel() {
        return LOOK_AND_FEEL;
    }

    private static ILookAndFeelDecorations parseDecorations(IConfigurationElement decorationsElement) {
        LookAndFeelDecorations decorations = new LookAndFeelDecorations();
        decorations.setScope(UiDecorationExtensionPoint.getScopePriority(decorationsElement.getAttribute("scope")));
        IConfigurationElement[] mandatoryElement = decorationsElement.getChildren("mandatory");
        if (mandatoryElement.length > 0) {
            IConfigurationElement[] starMarker;
            IConfigurationElement[] labelFont;
            IConfigurationElement[] labelTextColor;
            IConfigurationElement[] fieldBackground = mandatoryElement[0].getChildren("fieldBackground");
            if (fieldBackground.length > 0) {
                decorations.setMandatoryFieldBackgroundColor(fieldBackground[0].getAttribute("color"));
            }
            if ((labelTextColor = mandatoryElement[0].getChildren("labelTextColor")).length > 0) {
                decorations.setMandatoryLabelTextColor(labelTextColor[0].getAttribute("color"));
            }
            if ((labelFont = mandatoryElement[0].getChildren("labelFont")).length > 0) {
                FontSpec spec = FontSpec.parse((String)labelFont[0].getAttribute("font"));
                decorations.setMandatoryLabelFont(spec);
            }
            if ((starMarker = mandatoryElement[0].getChildren("starMarker")).length > 0) {
                decorations.setStarMarkerPosition(UiDecorationExtensionPoint.parseStarMarkerPosition(starMarker[0].getAttribute("placement")));
            }
        }
        return decorations;
    }

    private static ILookAndFeelProperties parseProperties(IConfigurationElement propertiesElement) {
        IConfigurationElement[] properties;
        LookAndFeelProperties props = new LookAndFeelProperties();
        props.setScope(UiDecorationExtensionPoint.getScopePriority(propertiesElement.getAttribute("scope")));
        IConfigurationElement[] iConfigurationElementArray = properties = propertiesElement.getChildren("property");
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement prop = iConfigurationElementArray[n2];
            String propName = null;
            String propValue = null;
            propName = prop.getAttribute("name");
            propValue = prop.getAttribute("value");
            props.setProperty(propName, propValue);
            props.setContributor(propertiesElement.getContributor().getName());
            ++n2;
        }
        return props;
    }

    private static int getScopePriority(String scope) {
        int prio = 1;
        if (StringUtility.isNullOrEmpty((String)scope) || scope.equalsIgnoreCase("default")) {
            prio = 1;
        } else if (scope.equalsIgnoreCase("global")) {
            prio = 2;
        }
        return prio;
    }

    private static int parseStarMarkerPosition(String value) {
        int pos = 0;
        if (StringUtility.isNullOrEmpty((String)value) || value.equalsIgnoreCase("beforeLabel")) {
            pos = 1;
        } else if (value.equalsIgnoreCase("afterLabel")) {
            pos = 2;
        }
        return pos;
    }

    private static int getSystemRowHeight() {
        String osName = Activator.getDefault().getBundle().getBundleContext().getProperty("org.osgi.framework.os.name");
        if (StringUtility.equalsIgnoreCase((String)"WindowsXP", (String)osName)) {
            return 21;
        }
        return 23;
    }
}

