/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.colorpickerfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.colorpickerfield.IColorField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtScoutContextMenu;
import org.eclipse.scout.rt.ui.swt.action.menu.text.StyledTextAccess;
import org.eclipse.scout.rt.ui.swt.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutBasicFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.colorpickerfield.ColorCanvas;
import org.eclipse.scout.rt.ui.swt.form.fields.colorpickerfield.ISwtScoutColorField;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutColorField
extends SwtScoutBasicFieldComposite<IColorField>
implements ISwtScoutColorField {
    private ColorCanvas m_colorCanvas;
    private Button m_colorPickButton;
    private SwtContextMenuMarkerComposite m_menuMarkerComposite;
    private SwtScoutContextMenu m_contextMenu;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        this.m_colorCanvas = new ColorCanvas(container, this.getEnvironment());
        this.m_menuMarkerComposite = new SwtContextMenuMarkerComposite(container, this.getEnvironment());
        this.getEnvironment().getFormToolkit().adapt((Composite)this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwtScoutColorField.this.getSwtField().setFocus();
                SwtScoutColorField.this.m_contextMenu.getSwtMenu().setVisible(true);
            }
        });
        StyledText textField = this.getEnvironment().getFormToolkit().createStyledText((Composite)this.m_menuMarkerComposite, 4);
        textField.setAlignment(SwtUtility.getHorizontalAlignment(((IColorField)this.getScoutObject()).getGridData().horizontalAlignment));
        textField.setWrapIndent(textField.getWrapIndent());
        textField.setMargins(2, 2, 2, 2);
        textField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.stateMask == 0) {
                    switch (e.keyCode) {
                        case 0x1000002: 
                        case 0x100000B: {
                            SwtScoutColorField.this.handleSwtPickColor();
                        }
                    }
                }
            }
        });
        this.m_colorPickButton = this.getEnvironment().getFormToolkit().createButton(container, 524296);
        this.m_colorPickButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwtScoutColorField.this.handleSwtPickColor();
            }
        });
        container.setTabList(new Control[]{this.m_menuMarkerComposite});
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)textField);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
        LogicalGridData data = LogicalGridDataBuilder.createButton1();
        data.gridx = 1;
        this.m_colorCanvas.setLayoutData(data);
        data = LogicalGridDataBuilder.createField(((IColorField)this.getScoutObject()).getGridData());
        data.gridx = 2;
        this.m_menuMarkerComposite.setLayoutData(data);
        data = LogicalGridDataBuilder.createButton1();
        data.gridx = 3;
        this.m_colorPickButton.setLayoutData((Object)data);
    }

    @Override
    protected void installContextMenu() {
        this.m_menuMarkerComposite.setMarkerVisible(((IColorField)this.getScoutObject()).getContextMenu().isVisible());
        ((IColorField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    final boolean markerVisible = ((IColorField)SwtScoutColorField.this.getScoutObject()).getContextMenu().isVisible();
                    SwtScoutColorField.this.getEnvironment().invokeSwtLater(new Runnable(){

                        @Override
                        public void run() {
                            SwtScoutColorField.this.m_menuMarkerComposite.setMarkerVisible(markerVisible);
                        }
                    });
                }
            }
        });
        this.m_contextMenu = new SwtScoutContextMenu(this.getSwtField().getShell(), ((IColorField)this.getScoutObject()).getContextMenu(), this.getEnvironment());
        this.getColorPickButton().setMenu(this.m_contextMenu.getSwtMenu());
        SwtScoutContextMenu fieldMenu = new SwtScoutContextMenu(this.getSwtField().getShell(), ((IColorField)this.getScoutObject()).getContextMenu(), this.getEnvironment(), ((IColorField)this.getScoutObject()).isAutoAddDefaultMenus() ? new StyledTextAccess(this.getSwtField()) : null, ((IColorField)this.getScoutObject()).isAutoAddDefaultMenus() ? this.getSwtField() : null);
        this.getSwtField().setMenu(fieldMenu.getSwtMenu());
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.updateIconIdFromScout();
    }

    public StyledText getSwtField() {
        return (StyledText)super.getSwtField();
    }

    @Override
    public Button getColorPickButton() {
        return this.m_colorPickButton;
    }

    @Override
    public ColorCanvas getColorCanvas() {
        return this.m_colorCanvas;
    }

    @Override
    protected String getText() {
        return this.getSwtField().getText();
    }

    @Override
    protected void setText(String text) {
        this.getSwtField().setText(text);
    }

    @Override
    protected Point getSelection() {
        return this.getSwtField().getSelection();
    }

    @Override
    protected void setSelection(int startIndex, int endIndex) {
        this.getSwtField().setSelection(startIndex, endIndex);
    }

    @Override
    protected int getCaretOffset() {
        return this.getSwtField().getCaretOffset();
    }

    @Override
    protected void setCaretOffset(int caretPosition) {
        this.getSwtField().setCaretOffset(caretPosition);
    }

    @Override
    protected TextFieldEditableSupport createEditableSupport() {
        return new TextFieldEditableSupport(this.getSwtField());
    }

    protected void handleSwtPickColor() {
        try {
            RGB selectedColor;
            ColorDialog colorDialog = new ColorDialog(this.getSwtContainer().getShell());
            colorDialog.setText(ScoutTexts.get((String)"ColorPickerSelectColor", (String[])new String[0]));
            RGB rgb = ColorUtility.toRGB((String)((IColorField)this.getScoutObject()).getValue());
            if (rgb != null) {
                colorDialog.setRGB(rgb);
            }
            if ((selectedColor = colorDialog.open()) != null) {
                final String color = org.eclipse.scout.commons.ColorUtility.rgbToText((int)selectedColor.red, (int)selectedColor.green, (int)selectedColor.blue);
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        ((IColorField)SwtScoutColorField.this.getScoutObject()).getUIFacade().setValueFromUi(color);
                    }
                };
                this.getEnvironment().invokeScoutLater(t, 2345L);
            }
        }
        finally {
            if (!this.getSwtField().isDisposed()) {
                this.getSwtField().setFocus();
            }
        }
    }

    @Override
    protected void updateValueFromScout() {
        String value = (String)((IColorField)this.getScoutObject()).getValue();
        if (value == null) {
            value = "";
        }
        this.m_colorCanvas.setColor(value);
        this.getSwtField().setText(value);
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_colorPickButton.setEnabled(b);
    }

    protected void updateIconIdFromScout() {
        this.m_colorPickButton.setImage(this.getEnvironment().getIcon(((IColorField)this.getScoutObject()).getIconId()));
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("iconId")) {
            this.updateIconIdFromScout();
        }
        super.handleScoutPropertyChange(name, newValue);
    }
}

