/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.filechooserfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtScoutContextMenu;
import org.eclipse.scout.rt.ui.swt.action.menu.text.StyledTextAccess;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.filechooserfield.ISwtScoutFileChooserField;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutFileChooserField
extends SwtScoutValueFieldComposite<IFileChooserField>
implements ISwtScoutFileChooserField {
    private Button m_fileChooserButton;
    private TextFieldEditableSupport m_editableSupport;
    private SwtContextMenuMarkerComposite m_menuMarkerComposite;
    private SwtScoutContextMenu m_contextMenu;

    @Override
    protected void initializeSwt(Composite parent) {
        super.initializeSwt(parent);
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        this.m_menuMarkerComposite = new SwtContextMenuMarkerComposite(container, this.getEnvironment());
        this.getEnvironment().getFormToolkit().adapt((Composite)this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwtScoutFileChooserField.this.getSwtField().setFocus();
                SwtScoutFileChooserField.this.m_contextMenu.getSwtMenu().setVisible(true);
            }
        });
        StyledText textField = this.getEnvironment().getFormToolkit().createStyledText((Composite)this.m_menuMarkerComposite, 4);
        textField.setMargins(2, 2, 2, 2);
        this.m_fileChooserButton = this.getEnvironment().getFormToolkit().createButton(container, "", 8);
        this.m_fileChooserButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                SwtScoutFileChooserField.this.handleSwtInputVerifier();
            }

            public void mouseUp(MouseEvent e) {
                if (e.button == 1) {
                    SwtScoutFileChooserField.this.handleSwtFileChooserAction();
                }
            }
        });
        this.m_fileChooserButton.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SwtScoutFileChooserField.this.getSwtField().setFocus();
            }
        });
        container.setTabList(new Control[]{this.m_menuMarkerComposite});
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)textField);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
        this.m_menuMarkerComposite.setLayoutData(LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
        this.m_fileChooserButton.setLayoutData((Object)LogicalGridDataBuilder.createButton1());
    }

    @Override
    protected void installContextMenu() {
        this.m_menuMarkerComposite.setMarkerVisible(((IFileChooserField)this.getScoutObject()).getContextMenu().isVisible());
        ((IFileChooserField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    final boolean markerVisible = ((IFileChooserField)SwtScoutFileChooserField.this.getScoutObject()).getContextMenu().isVisible();
                    SwtScoutFileChooserField.this.getEnvironment().invokeSwtLater(new Runnable(){

                        @Override
                        public void run() {
                            SwtScoutFileChooserField.this.m_menuMarkerComposite.setMarkerVisible(markerVisible);
                        }
                    });
                }
            }
        });
        this.m_contextMenu = new SwtScoutContextMenu(this.getSwtField().getShell(), ((IFileChooserField)this.getScoutObject()).getContextMenu(), this.getEnvironment());
        this.getSwtFileChooserButton().setMenu(this.m_contextMenu.getSwtMenu());
        SwtScoutContextMenu fieldMenu = new SwtScoutContextMenu(this.getSwtField().getShell(), ((IFileChooserField)this.getScoutObject()).getContextMenu(), this.getEnvironment(), ((IFileChooserField)this.getScoutObject()).isAutoAddDefaultMenus() ? new StyledTextAccess(this.getSwtField()) : null, ((IFileChooserField)this.getScoutObject()).isAutoAddDefaultMenus() ? this.getSwtField() : null);
        this.getSwtField().setMenu(fieldMenu.getSwtMenu());
    }

    @Override
    public Button getSwtFileChooserButton() {
        return this.m_fileChooserButton;
    }

    @Override
    public StyledText getSwtField() {
        return (StyledText)super.getSwtField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setFileIconIdFromScout(((IFileChooserField)this.getScoutObject()).getFileIconId());
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        if (s == null) {
            s = "";
        }
        this.getSwtField().setText(s);
        super.handleSwtFocusGained();
        this.getSwtField().setCaretOffset(0);
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        super.setEnabledFromScout(b);
        this.m_fileChooserButton.setEnabled(b);
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
        if (this.m_editableSupport == null) {
            this.m_editableSupport = new TextFieldEditableSupport(this.getSwtField());
        }
        this.m_editableSupport.setEditable(enabled);
    }

    protected void setFileIconIdFromScout(String s) {
        this.m_fileChooserButton.setImage(this.getEnvironment().getIcon(s));
    }

    @Override
    protected boolean handleSwtInputVerifier() {
        final String text = this.getSwtField().getText();
        if (CompareUtility.equals((Object)text, (Object)((IFileChooserField)this.getScoutObject()).getDisplayText()) && ((IFileChooserField)this.getScoutObject()).getErrorStatus() == null) {
            return true;
        }
        final Holder result = new Holder(Boolean.class, (Object)false);
        Runnable t = new Runnable(){

            @Override
            public void run() {
                boolean b = ((IFileChooserField)SwtScoutFileChooserField.this.getScoutObject()).getUIFacade().setTextFromUI(text);
                result.setValue((Object)b);
            }
        };
        JobEx job = this.getEnvironment().invokeScoutLater(t, 0L);
        try {
            job.join(2345L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getEnvironment().dispatchImmediateSwtJobs();
        return true;
    }

    @Override
    protected void handleSwtFocusGained() {
        super.handleSwtFocusGained();
        this.scheduleSelectAll();
    }

    @Override
    protected void handleSwtFocusLost() {
        this.getSwtField().setSelection(0, 0);
    }

    protected void scheduleSelectAll() {
        this.getEnvironment().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SwtScoutFileChooserField.this.getSwtField().isDisposed()) {
                    return;
                }
                SwtScoutFileChooserField.this.getSwtField().setSelection(0, SwtScoutFileChooserField.this.getSwtField().getText().length());
            }
        });
    }

    protected void handleSwtFileChooserAction() {
        if (((IFileChooserField)this.getScoutObject()).isVisible() && ((IFileChooserField)this.getScoutObject()).isEnabled()) {
            Runnable scoutJob = new Runnable(){

                @Override
                public void run() {
                    IFileChooser fc = ((IFileChooserField)SwtScoutFileChooserField.this.getScoutObject()).getFileChooser();
                    final List files = fc.startChooser();
                    Runnable swtJob = new Runnable(){

                        @Override
                        public void run() {
                            if (CollectionUtility.hasElements((Collection)files)) {
                                SwtScoutFileChooserField.this.getSwtField().setText(((File)CollectionUtility.firstElement((List)files)).getAbsolutePath());
                                SwtScoutFileChooserField.this.handleSwtInputVerifier();
                            }
                        }
                    };
                    if (SwtScoutFileChooserField.this.getEnvironment() != null) {
                        SwtScoutFileChooserField.this.getEnvironment().invokeSwtLater(swtJob);
                    }
                }
            };
            this.getEnvironment().invokeScoutLater(scoutJob, 0L);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("fileIconId")) {
            this.setFileIconIdFromScout((String)newValue);
        }
    }

    private class P_SwtFileChooserButtonListener
    extends SelectionAdapter {
        private P_SwtFileChooserButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SwtScoutFileChooserField.this.handleSwtFileChooserAction();
        }
    }
}

