/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.stringfield;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtContextMenuMarkerComposite;
import org.eclipse.scout.rt.ui.swt.action.menu.SwtScoutContextMenu;
import org.eclipse.scout.rt.ui.swt.action.menu.text.StyledTextAccess;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.ext.StyledTextEx;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.stringfield.ISwtScoutStringField;
import org.eclipse.scout.rt.ui.swt.form.fields.stringfield.SwtScoutStringFieldComposite;
import org.eclipse.scout.rt.ui.swt.internal.TextFieldEditableSupport;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class SwtScoutStringField
extends SwtScoutStringFieldComposite
implements ISwtScoutStringField {
    private MouseListener m_linkTrigger;
    private boolean m_linkDecoration;
    private SwtContextMenuMarkerComposite m_menuMarkerComposite;
    private SwtScoutContextMenu m_contextMenu;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.createContainer(parent);
        StatusLabelEx label = this.createLabel(container);
        this.m_menuMarkerComposite = new SwtContextMenuMarkerComposite(container, this.getEnvironment());
        this.getEnvironment().getFormToolkit().adapt((Composite)this.m_menuMarkerComposite);
        this.m_menuMarkerComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwtScoutStringField.this.getSwtField().setFocus();
                SwtScoutStringField.this.m_contextMenu.getSwtMenu().setVisible(true);
            }
        });
        int style = this.getSwtStyle((IStringField)this.getScoutObject());
        StyledText textField = this.getEnvironment().getFormToolkit().createStyledText((Composite)this.m_menuMarkerComposite, style);
        textField.setAlignment(SwtUtility.getHorizontalAlignment(((IStringField)this.getScoutObject()).getGridData().horizontalAlignment));
        textField.setMargins(2, 2, 2, 2);
        textField.setWrapIndent(textField.getIndent());
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)textField);
        this.addDefaultUiListeners(textField);
        this.getSwtContainer().setLayout((Layout)this.getContainerLayout());
        this.m_menuMarkerComposite.setLayoutData(LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData()));
    }

    @Override
    protected void installContextMenu() {
        this.m_menuMarkerComposite.setMarkerVisible(((IStringField)this.getScoutObject()).getContextMenu().isVisible());
        ((IStringField)this.getScoutObject()).getContextMenu().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("visible".equals(evt.getPropertyName())) {
                    final boolean markerVisible = ((IStringField)SwtScoutStringField.this.getScoutObject()).getContextMenu().isVisible();
                    SwtScoutStringField.this.getEnvironment().invokeSwtLater(new Runnable(){

                        @Override
                        public void run() {
                            SwtScoutStringField.this.m_menuMarkerComposite.setMarkerVisible(markerVisible);
                        }
                    });
                }
            }
        });
        this.m_contextMenu = new SwtScoutContextMenu(this.getSwtField().getShell(), ((IStringField)this.getScoutObject()).getContextMenu(), this.getEnvironment());
        SwtScoutContextMenu fieldMenu = new SwtScoutContextMenu(this.getSwtField().getShell(), ((IStringField)this.getScoutObject()).getContextMenu(), this.getEnvironment(), ((IStringField)this.getScoutObject()).isAutoAddDefaultMenus() ? new StyledTextAccess(this.getSwtField()) : null, ((IStringField)this.getScoutObject()).isAutoAddDefaultMenus() ? this.getSwtField() : null);
        this.getSwtField().setMenu(fieldMenu.getSwtMenu());
    }

    protected void addDefaultUiListeners(StyledText textField) {
        this.addModifyListenerForBasicField((Widget)textField);
        textField.addSelectionListener((SelectionListener)new SwtScoutStringFieldComposite.P_SwtTextSelectionListener(this));
        textField.addVerifyListener((VerifyListener)new SwtScoutStringFieldComposite.P_TextVerifyListener(this));
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IStringField f = (IStringField)this.getScoutObject();
        this.setFormatFromScout(f.getFormat());
        this.setMaxLengthFromScout(f.getMaxLength());
        this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        this.setDecorationLinkFromScout(f.isDecorationLink());
        this.setTextWrapFromScout(f.isWrapText());
        new SwtScoutStringFieldComposite.P_DndSupport(this, (IPropertyObserver)this.getScoutObject(), (IDNDSupport)this.getScoutObject(), (Control)this.getSwtField(), this.getEnvironment());
    }

    @Override
    public StyledTextEx getSwtField() {
        return (StyledTextEx)super.getSwtField();
    }

    protected void setDecorationLinkFromScout(boolean b) {
        if (this.m_linkDecoration != b) {
            this.m_linkDecoration = b;
            if (this.m_linkDecoration) {
                this.m_linkTrigger = new P_SwtLinkTrigger();
                this.getSwtField().addMouseListener(this.m_linkTrigger);
                this.getSwtField().setCursor(this.getSwtField().getDisplay().getSystemCursor(21));
                this.setForegroundFromScout(((IStringField)this.getScoutObject()).getForegroundColor());
            } else {
                this.getSwtField().removeMouseListener(this.m_linkTrigger);
                this.m_linkTrigger = null;
                this.getSwtField().setCursor(null);
                this.setForegroundFromScout(((IStringField)this.getScoutObject()).getForegroundColor());
            }
        }
    }

    @Override
    protected void setForegroundFromScout(String scoutColor) {
        if (scoutColor == null && this.m_linkDecoration) {
            scoutColor = "0000FF";
        }
        super.setForegroundFromScout(scoutColor);
    }

    @Override
    protected void setMaxLengthFromScout(int n) {
        this.getSwtField().setTextLimit(n);
    }

    @Override
    protected void setText(String text) {
        this.getSwtField().setText(text);
    }

    @Override
    protected int getCaretOffset() {
        return this.getSwtField().getCaretOffset();
    }

    @Override
    protected void setCaretOffset(int caretPosition) {
        this.getSwtField().setCaretOffset(caretPosition);
    }

    @Override
    protected void setSelection(int startIndex, int endIndex) {
        this.getSwtField().setSelection(startIndex, endIndex);
    }

    protected void setTextWrapFromScout(boolean booleanValue) {
        if (((IStringField)this.getScoutObject()).isMultilineText()) {
            this.getSwtField().setWordWrap(booleanValue);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("decorationLink")) {
            this.setDecorationLinkFromScout((Boolean)newValue);
        } else if (name.equals("wrapText")) {
            this.setTextWrapFromScout((Boolean)newValue);
        }
    }

    protected void handleSwtLinkTrigger() {
        final String text = this.getSwtField().getText();
        Runnable t = new Runnable(){

            @Override
            public void run() {
                ((IStringField)SwtScoutStringField.this.getScoutObject()).getUIFacade().fireLinkActionFromUI(text);
            }
        };
        this.getEnvironment().invokeScoutLater(t, 0L);
    }

    @Override
    protected String getText() {
        return this.getSwtField().getText();
    }

    @Override
    protected TextFieldEditableSupport createEditableSupport() {
        return new TextFieldEditableSupport(this.getSwtField());
    }

    @Override
    protected Point getSelection() {
        return this.getSwtField().getSelection();
    }

    private class P_SwtLinkTrigger
    extends MouseAdapter {
        private P_SwtLinkTrigger() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            SwtScoutStringField.this.handleSwtLinkTrigger();
        }
    }
}

