/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.stringfield;

import java.beans.PropertyChangeEvent;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.AbstractSwtScoutDndSupport;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutBasicFieldComposite;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public abstract class SwtScoutStringFieldComposite
extends SwtScoutBasicFieldComposite<IStringField> {
    public static final int DEFAULT_CASE = 0;
    public static final int UPPER_CASE = 1;
    public static final int LOWER_CASE = 2;
    private int m_characterType = -1;

    protected Composite createContainer(Composite parent) {
        return this.getEnvironment().getFormToolkit().createComposite(parent);
    }

    protected StatusLabelEx createLabel(Composite container) {
        return this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
    }

    protected void setFormatFromScout(String s) {
        this.m_characterType = "A".equals(s) ? 1 : ("a".equals(s) ? 2 : 0);
    }

    protected int getSwtStyle(IStringField field) {
        int style = 0;
        if (field.isInputMasked()) {
            style |= 0x400000;
        }
        style = field.isMultilineText() ? (style |= 0x202) : (style |= 4);
        if (field.isWrapText()) {
            style |= 0x40;
        }
        return style;
    }

    protected LogicalGridLayout getContainerLayout() {
        return new LogicalGridLayout(1, 0);
    }

    protected void setSelectionFromSwt(final int startIndex, final int endIndex) {
        if (this.getUpdateSwtFromScoutLock().isAcquired()) {
            return;
        }
        Runnable t = new Runnable(){

            @Override
            public void run() {
                try {
                    SwtScoutStringFieldComposite.this.addIgnoredScoutEvent(PropertyChangeEvent.class, "selectionStart");
                    SwtScoutStringFieldComposite.this.addIgnoredScoutEvent(PropertyChangeEvent.class, "selectionEnd");
                    ((IStringField)SwtScoutStringFieldComposite.this.getScoutObject()).getUIFacade().setSelectionFromUI(startIndex, endIndex);
                }
                finally {
                    SwtScoutStringFieldComposite.this.removeIgnoredScoutEvent(PropertyChangeEvent.class, "selectionStart");
                    SwtScoutStringFieldComposite.this.removeIgnoredScoutEvent(PropertyChangeEvent.class, "selectionEnd");
                }
            }
        };
        this.getEnvironment().invokeScoutLater(t, 0L);
    }

    protected abstract void setMaxLengthFromScout(int var1);

    @Override
    protected boolean filterKeyEvent(Event e) {
        if (((IStringField)this.getScoutObject()).isMultilineText() && (e.keyCode == 13 || e.keyCode == 0x1000050)) {
            return false;
        }
        return super.filterKeyEvent(e);
    }

    protected void setDoInsertFromScout(String s) {
        if (s != null && s.length() > 0) {
            int offset = this.getCaretOffset();
            int a = this.getSelection().x;
            int b = this.getSelection().y;
            String uiText = this.getText();
            StringBuilder builder = new StringBuilder(uiText);
            if (a >= 0 && b > a) {
                builder.replace(a, b, s);
            } else if (offset >= 0) {
                builder.insert(offset, s);
            } else {
                builder = null;
            }
            if (builder != null) {
                this.setText(builder.toString());
            }
        }
    }

    @Override
    protected void handleSwtFocusGained() {
        if (((IStringField)this.getScoutObject()).isSelectAllOnFocus()) {
            this.scheduleSelectAll();
        } else {
            this.restoreSelection();
        }
    }

    protected void setSelectionFromScout(int startIndex, int endIndex) {
        if (startIndex < 0) {
            startIndex = this.getSelection().x;
        }
        if (endIndex < 0) {
            endIndex = this.getSelection().y;
        }
        this.selectField(startIndex, endIndex);
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("maxLength")) {
            this.setMaxLengthFromScout(((Number)newValue).intValue());
        } else if (name.equals("insertText")) {
            this.setDoInsertFromScout((String)newValue);
        } else if (name.equals("selectionStart")) {
            IStringField f = (IStringField)this.getScoutObject();
            this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        } else if (name.equals("selectionEnd")) {
            IStringField f = (IStringField)this.getScoutObject();
            this.setSelectionFromScout(f.getSelectionStart(), f.getSelectionEnd());
        }
    }

    protected class P_DndSupport
    extends AbstractSwtScoutDndSupport {
        public P_DndSupport(IPropertyObserver scoutObject, IDNDSupport scoutDndSupportable, Control control, ISwtEnvironment environment) {
            super(scoutObject, scoutDndSupportable, control, environment);
        }

        @Override
        protected TransferObject handleSwtDragRequest() {
            final Holder result = new Holder(TransferObject.class, null);
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    TransferObject scoutTransferable = ((IStringField)SwtScoutStringFieldComposite.this.getScoutObject()).getUIFacade().fireDragRequestFromUI();
                    result.setValue((Object)scoutTransferable);
                }
            };
            JobEx job = SwtScoutStringFieldComposite.this.getEnvironment().invokeScoutLater(t, 2345L);
            try {
                job.join(2345L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return (TransferObject)result.getValue();
        }

        @Override
        protected void handleSwtDropAction(DropTargetEvent event, final TransferObject scoutTransferObject) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    if (((IStringField)SwtScoutStringFieldComposite.this.getScoutObject()).isEnabled()) {
                        ((IStringField)SwtScoutStringFieldComposite.this.getScoutObject()).getUIFacade().fireDropActionFromUi(scoutTransferObject);
                    }
                }
            };
            SwtScoutStringFieldComposite.this.getEnvironment().invokeScoutLater(job, 200L);
        }
    }

    protected class P_SwtTextSelectionListener
    extends SelectionAdapter {
        protected P_SwtTextSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SwtScoutStringFieldComposite.this.setSelectionFromSwt(e.x, e.y);
        }
    }

    protected class P_TextVerifyListener
    implements VerifyListener {
        protected P_TextVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            switch (SwtScoutStringFieldComposite.this.m_characterType) {
                case 1: {
                    e.text = e.text.toUpperCase();
                    break;
                }
                case 2: {
                    e.text = e.text.toLowerCase();
                }
            }
        }
    }
}

