/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.util.debug;

import java.lang.reflect.Method;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class LayoutWrapper
extends Layout {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LayoutWrapper.class);
    private Layout m_wrappedLayout;
    private final String name;

    public LayoutWrapper(String name, Layout wrappedLayout) {
        this.name = name;
        this.m_wrappedLayout = wrappedLayout;
    }

    protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
        try {
            Method m = this.m_wrappedLayout.getClass().getDeclaredMethod("computeSize", Composite.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            m.setAccessible(true);
            Object t = m.invoke((Object)this.m_wrappedLayout, composite, hint, hint2, flushCache);
            if (t instanceof Point) {
                Point p = (Point)t;
                System.out.println("wrappedLayout '" + this.name + "' computedSize: " + p.toString() + " HINTS:[" + hint + "," + hint2 + "]");
                return p;
            }
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
        }
        return new Point(1500, 20);
    }

    protected void layout(Composite composite, boolean flushCache) {
        try {
            Method m = this.m_wrappedLayout.getClass().getDeclaredMethod("layout", Composite.class, Boolean.TYPE);
            m.setAccessible(true);
            m.invoke((Object)this.m_wrappedLayout, composite, flushCache);
            System.out.println("layout done '" + this.name + "'");
            return;
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
            return;
        }
    }
}

