/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.desktop.tray;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.SwtMenuUtility;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.window.desktop.tray.ISwtScoutTray;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public class SwtScoutTray
extends SwtScoutComposite<IDesktop>
implements ISwtScoutTray {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutTray.class);
    private TrayItem m_trayItem;
    private Menu m_popupMenu;

    @Override
    protected void initializeSwt(Composite parent) {
        super.initializeSwt(parent);
        this.m_trayItem = this.createTrayItem();
        if (this.m_trayItem != null) {
            this.m_trayItem.addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent e) {
                    if (SwtScoutTray.this.m_popupMenu != null) {
                        SwtScoutTray.this.m_popupMenu.setVisible(true);
                    }
                }
            });
            this.m_popupMenu = this.createPopupMenu();
            this.updatePopupMenus();
        }
    }

    protected TrayItem createTrayItem() {
        Tray tray = this.getEnvironment().getDisplay().getSystemTray();
        if (tray != null) {
            TrayItem trayItem = new TrayItem(tray, 0);
            trayItem.setImage(Activator.getIcon("window"));
            return trayItem;
        }
        return null;
    }

    protected Menu createPopupMenu() {
        Shell shell = new Shell(this.getEnvironment().getDisplay());
        return new Menu((Decorations)shell, 8);
    }

    @Override
    public boolean isDisposed() {
        return this.m_trayItem == null || this.m_trayItem.isDisposed();
    }

    @Override
    public void disposeTray() {
        this.dispose();
        if (this.m_trayItem != null && !this.isDisposed()) {
            this.m_trayItem.dispose();
        }
        if (this.m_popupMenu != null && !this.m_popupMenu.isDisposed()) {
            this.m_popupMenu.dispose();
        }
    }

    protected void updatePopupMenus() {
        if (this.m_popupMenu == null) {
            return;
        }
        MenuItem[] menuItemArray = this.m_popupMenu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem mi = menuItemArray[n2];
            if (!mi.isDisposed()) {
                mi.dispose();
            }
            ++n2;
        }
        if (this.getScoutObject() != null) {
            final AtomicReference scoutMenusRef = new AtomicReference();
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    scoutMenusRef.set(((IDesktop)SwtScoutTray.this.getScoutObject()).getUIFacade().fireTrayPopupFromUI());
                }
            };
            try {
                this.getEnvironment().invokeScoutLater(t, 5678L).join(5678L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwtMenuUtility.fillMenu(this.m_popupMenu, (List)scoutMenusRef.get(), this.getEnvironment());
        }
    }

    @Override
    public TrayItem getSwtTrayItem() {
        return this.m_trayItem;
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        IDesktop desktop = (IDesktop)this.getScoutObject();
        this.setTooltipFromScout(desktop.getTitle());
    }

    protected void setTooltipFromScout(String tooltip) {
        if (this.m_trayItem != null) {
            this.m_trayItem.setToolTipText(tooltip);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("title".equals(name)) {
            this.setTooltipFromScout((String)newValue);
        }
    }
}

