/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.compatibility;

import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Version;

public final class PlatformVersionUtility {
    private static Version platformVersion = null;
    public static final String EMPTY_VERSION_STR = "0.0.0";
    public static final String ORG_ECLIPSE_PLATFORM = "org.eclipse.platform";

    public static boolean isLatest() {
        return PlatformVersionUtility.isLuna();
    }

    public static boolean isLuna() {
        return PlatformVersionUtility.isLuna(PlatformVersionUtility.getPlatformVersion());
    }

    public static boolean isLuna(Version v) {
        return v.getMajor() == 4 && v.getMinor() == 4;
    }

    public static boolean isKepler() {
        return PlatformVersionUtility.isKepler(PlatformVersionUtility.getPlatformVersion());
    }

    public static boolean isKepler(Version v) {
        return v.getMajor() == 4 && v.getMinor() == 3;
    }

    public static boolean isJunoOrLater() {
        return PlatformVersionUtility.isJunoOrLater(PlatformVersionUtility.getPlatformVersion());
    }

    public static boolean isJunoOrLater(Version v) {
        return v.getMajor() == 3 && v.getMinor() == 8 || v.getMajor() == 4 && v.getMinor() >= 2;
    }

    public static boolean isJuno() {
        return PlatformVersionUtility.isJuno(PlatformVersionUtility.getPlatformVersion());
    }

    public static boolean isJuno(Version v) {
        return v.getMajor() == 3 && v.getMinor() == 8 || v.getMajor() == 4 && v.getMinor() == 2;
    }

    public static boolean isE4() {
        return PlatformVersionUtility.isE4(PlatformVersionUtility.getPlatformVersion());
    }

    public static boolean isE4(Version v) {
        return v.getMajor() == 4;
    }

    public static boolean isIndigo() {
        return PlatformVersionUtility.isIndigo(PlatformVersionUtility.getPlatformVersion());
    }

    public static boolean isIndigo(Version v) {
        return v.getMajor() == 3 && v.getMinor() == 7;
    }

    public static boolean isHelios() {
        return PlatformVersionUtility.isHelios(PlatformVersionUtility.getPlatformVersion());
    }

    public static boolean isHelios(Version v) {
        return v.getMajor() == 3 && v.getMinor() == 6;
    }

    public static boolean isGalileo() {
        return PlatformVersionUtility.isGalileo(PlatformVersionUtility.getPlatformVersion());
    }

    public static boolean isGalileo(Version v) {
        return v.getMajor() == 3 && v.getMinor() == 5;
    }

    public static Version getPlatformVersion() {
        if (platformVersion == null) {
            Version v = Platform.getBundle((String)ORG_ECLIPSE_PLATFORM).getVersion();
            if (v.getMajor() == 3 && v.getMinor() == 3) {
                v = new Version(3, 5, 0);
            }
            platformVersion = v;
        }
        return platformVersion;
    }
}

