/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.compatibility;

import java.io.File;
import java.net.URI;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.sdk.compatibility.internal.ScoutCompatibilityActivator;
import org.eclipse.scout.sdk.compatibility.internal.service.ITargetPlatformCompatService;

public final class TargetPlatformUtility {
    private TargetPlatformUtility() {
    }

    public static IStatus resolveTargetPlatform(IFile targetFile, IProgressMonitor monitor) throws CoreException {
        return TargetPlatformUtility.resolveTargetPlatform(targetFile, false, monitor);
    }

    public static URI getCurrentTargetFile() throws CoreException {
        ITargetPlatformCompatService svc = TargetPlatformUtility.getService();
        return svc.getCurrentTargetFile();
    }

    public static IStatus resolveTargetPlatform(IFile targetFile, boolean loadPlatform, IProgressMonitor monitor) throws CoreException {
        ITargetPlatformCompatService svc = TargetPlatformUtility.getService();
        return svc.resolveTargetPlatform(targetFile, loadPlatform, monitor);
    }

    public static IStatus resolveTargetPlatform(Set<File> absolutePaths, String targetName, IProgressMonitor monitor) throws CoreException {
        return TargetPlatformUtility.resolveTargetPlatform(absolutePaths, targetName, false, monitor);
    }

    public static IStatus resolveTargetPlatform(Set<File> absolutePaths, String targetName, boolean loadPlatform, IProgressMonitor monitor) throws CoreException {
        ITargetPlatformCompatService svc = TargetPlatformUtility.getService();
        return svc.resolveTargetPlatform(absolutePaths, targetName, loadPlatform, monitor);
    }

    private static ITargetPlatformCompatService getService() {
        return ScoutCompatibilityActivator.getDefault().acquireCompatibilityService(ITargetPlatformCompatService.class);
    }

    public static void addInstallableUnitToTarget(IFile targetFile, String unitId, String version, String repository, IProgressMonitor monitor) throws CoreException {
        ITargetPlatformCompatService svc = TargetPlatformUtility.getService();
        svc.addInstallableUnitToTarget(targetFile, unitId, version, repository, monitor);
    }

    public static void addDirectoryToTarget(IFile targetFile, String[] dirs) throws CoreException {
        ITargetPlatformCompatService svc = TargetPlatformUtility.getService();
        svc.addDirectoryLocationToTarget(targetFile, dirs);
    }

    public static void removeInstallableUnitsFromTarget(IFile targetFile, String[] unitIds) throws CoreException {
        ITargetPlatformCompatService svc = TargetPlatformUtility.getService();
        svc.removeInstallableUnitsFromTarget(targetFile, unitIds);
    }
}

