/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.testing;

import java.io.File;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.compatibility.TargetPlatformUtility;
import org.eclipse.scout.sdk.testing.internal.SdkTestingApi;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;

public final class TestUtility {
    private TestUtility() {
    }

    public static void setAutoBuildWorkspace(boolean autoBuild) throws CoreException {
        JdtUtility.setWorkspaceAutoBuilding((boolean)autoBuild);
    }

    public static void showEgitMessageBoxes(boolean show) {
        try {
            ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.egit.ui");
            store.setValue("show_detached_head_warning", show);
            store.setValue("show_git_prefix_warning", show);
            store.setValue("show_home_drive_warning", show);
            store.setValue("show_initial_config_dialog", show);
            store.setValue("show_rebase_confirm", show);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadRunningOsgiAsTarget(String targetName, IProgressMonitor monitor) throws CoreException {
        Bundle[] bundles = SdkTestingApi.getContext().getBundles();
        HashSet<File> dirs = new HashSet<File>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BaseData bundleData;
            File file;
            AbstractBundle aBundle;
            Bundle bundle = bundleArray[n2];
            if (bundle instanceof AbstractBundle && (aBundle = (AbstractBundle)bundle).getBundleData() instanceof BaseData && (file = (bundleData = (BaseData)aBundle.getBundleData()).getBundleFile().getBaseFile()) != null && file.exists()) {
                dirs.add(file.getParentFile());
            }
            ++n2;
        }
        TargetPlatformUtility.resolveTargetPlatform(dirs, (String)targetName, (boolean)true, (IProgressMonitor)monitor);
    }

    @Deprecated
    public static void setAutoUpdateFormData(boolean autoBuild) {
        TestUtility.setAutoUpdateDto(autoBuild);
    }

    public static void setAutoUpdateDto(boolean autoUpdate) {
        ScoutSdkCore.getDtoAutoUpdateManager().setEnabled(autoUpdate);
    }
}

