/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.testing.compare.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.sdk.testing.compare.ICompareResult;

public class LineCompareResult
implements ICompareResult<String> {
    private List<ICompareResult.IDifference<String>> m_differences = new ArrayList<ICompareResult.IDifference<String>>();

    public void addDifference(ICompareResult.IDifference<String> diff) {
        this.m_differences.add(diff);
    }

    @Override
    public boolean isEqual() {
        return this.m_differences.isEmpty();
    }

    @Override
    public List<ICompareResult.IDifference<String>> getDifferences() {
        return this.m_differences;
    }

    @Override
    public ICompareResult.IDifference<String> getFirstDifference() {
        if (this.getDifferences().size() > 0) {
            return this.getDifferences().get(0);
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isEqual()) {
            builder.append("No differences detected.");
        } else {
            builder.append("Differences: ");
            builder.append("\n");
            Iterator<ICompareResult.IDifference<String>> diffIt = this.getDifferences().iterator();
            if (diffIt.hasNext()) {
                builder.append(diffIt.next().toString());
            }
            while (diffIt.hasNext()) {
                builder.append("\n");
                builder.append(diffIt.next().toString());
            }
        }
        return builder.toString();
    }

    public static class LineDifference
    implements ICompareResult.IDifference<String> {
        private final String m_line01;
        private final String m_line02;
        private final int m_lineNr;

        public LineDifference(int lineNr, String line01, String line02) {
            this.m_lineNr = lineNr;
            this.m_line01 = line01;
            this.m_line02 = line02;
        }

        @Override
        public String getValue01() {
            return this.m_line01;
        }

        @Override
        public String getValue02() {
            return this.m_line02;
        }

        public int getLineNr() {
            return this.m_lineNr;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Diff (line:" + this.getLineNr() + "):\nline01: ").append(this.getValue01()).append("\nline02: ").append(this.getValue02());
            return builder.toString();
        }
    }
}

