/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.SimpleProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsProposalDescriptionProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.nls.NlsTextSelectionHandler;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureSubTypeProposalProvider;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeComparators;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.widgets.Composite;

public class FieldToolkit {
    public StyledTextField createStyledTextField(Composite parent, String label) {
        return new StyledTextField(parent, label);
    }

    public StyledTextField createStyledTextField(Composite parent, String label, int labelPercentage) {
        return new StyledTextField(parent, label, labelPercentage);
    }

    public ProposalTextField createProposalField(Composite parent, String label) {
        return this.createProposalField(parent, label, 1);
    }

    public ProposalTextField createProposalField(Composite parent, String label, int style) {
        return this.createProposalField(parent, label, style, 20);
    }

    public ProposalTextField createProposalField(Composite parent, String label, int style, int labelPercentage) {
        if (label == null) {
            label = "";
        }
        ProposalTextField field = new ProposalTextField(parent, style, labelPercentage);
        field.setLabelText(label);
        return field;
    }

    public ProposalTextField createNlsProposalTextField(Composite parent, INlsProject nlsProject, String label) {
        return this.createNlsProposalTextField(parent, nlsProject, label, 20);
    }

    public ProposalTextField createNlsProposalTextField(Composite parent, INlsProject nlsProject, String label, int labelPercentage) {
        ProposalTextField field = this.createProposalField(parent, label, 1, labelPercentage);
        NlsTextLabelProvider labelProvider = new NlsTextLabelProvider(nlsProject);
        field.setLabelProvider((IBaseLabelProvider)labelProvider);
        field.setContentProvider(new NlsTextContentProvider(labelProvider));
        field.setSelectionHandler(new NlsTextSelectionHandler(nlsProject));
        field.setProposalDescriptionProvider(new NlsProposalDescriptionProvider());
        return field;
    }

    public ProposalTextField createSignatureProposalField(Composite parent, String label, IScoutBundle bundle) {
        return this.createSignatureProposalField(parent, label, bundle, null);
    }

    public ProposalTextField createSignatureProposalField(Composite parent, String label, IScoutBundle bundle, Set<String> mostlyUsed) {
        return this.createSignatureProposalField(parent, label, bundle, mostlyUsed, 20);
    }

    public ProposalTextField createSignatureProposalField(Composite parent, String label, IScoutBundle bundle, Set<String> mostlyUsed, int labelPercentage) {
        ProposalTextField field = this.createProposalField(parent, label, 1, labelPercentage);
        SignatureLabelProvider labelProvider = new SignatureLabelProvider();
        field.setLabelProvider((IBaseLabelProvider)labelProvider);
        IJavaSearchScope jSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{ScoutUtility.getJavaProject((IScoutBundle)bundle)});
        SignatureProposalProvider proposalProvider = new SignatureProposalProvider(jSearchScope, labelProvider, mostlyUsed, false);
        field.setContentProvider(proposalProvider);
        return field;
    }

    public ProposalTextField createSignatureSubTypeProposalField(Composite parent, String label, String baseTypeSignature, IJavaProject project, int labelPercentage) {
        SignatureSubTypeProposalProvider proposalProvider = new SignatureSubTypeProposalProvider(baseTypeSignature, project);
        ProposalTextField field = this.createProposalField(parent, label, 1, labelPercentage);
        field.setContentProvider(proposalProvider);
        field.setLabelProvider((IBaseLabelProvider)proposalProvider.getLabelProvider());
        return field;
    }

    public ProposalTextField createSiblingProposalField(Composite parent, IType declaringType, IType siblingDeclaringType, int labelPercentage) {
        ITypeHierarchy localHierarchy = TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{declaringType});
        return this.createSiblingProposalField(parent, declaringType, siblingDeclaringType, localHierarchy, labelPercentage);
    }

    public ProposalTextField createSiblingProposalField(Composite parent, IType declaringType, IType siblingDeclaringType) {
        return this.createSiblingProposalField(parent, declaringType, siblingDeclaringType, 20);
    }

    public ProposalTextField createSiblingProposalField(Composite parent, IType declaringType, IType siblingDeclaringType, ITypeHierarchy hierarchy) {
        return this.createSiblingProposalField(parent, declaringType, siblingDeclaringType, hierarchy, 20);
    }

    public ProposalTextField createSiblingProposalField(Composite parent, IType declaringType, IType siblingDeclaringType, ITypeHierarchy hierarchy, int labelPercentage) {
        ITypeFilter filter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getClassFilter(), TypeFilters.getSubtypeFilter((IType)siblingDeclaringType, (ITypeHierarchy)hierarchy)});
        IType[] innerTypes = TypeUtility.getInnerTypes((IType)declaringType, (ITypeFilter)filter, (Comparator)ScoutTypeComparators.getOrderAnnotationComparator());
        ArrayList<SiblingProposal> siblingList = new ArrayList<SiblingProposal>();
        IType[] iTypeArray = innerTypes;
        int n = innerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            siblingList.add(new SiblingProposal((IJavaElement)t));
            ++n2;
        }
        siblingList.add(SiblingProposal.SIBLING_END);
        ProposalTextField field = this.createProposalField(parent, Texts.get((String)"Sibling"), 1, labelPercentage);
        field.setEnabled(siblingList.size() > 1);
        field.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider());
        field.setContentProvider(new SimpleProposalProvider(siblingList.toArray(new SiblingProposal[siblingList.size()])));
        return field;
    }

    public EntityTextField createEntityTextField(Composite parent, String label, IScoutBundle b) {
        return this.createEntityTextField(parent, label, b, 20);
    }

    public EntityTextField createEntityTextField(Composite parent, String label, IScoutBundle p, int labelPercentage) {
        EntityTextField text = new EntityTextField(parent, label, labelPercentage, p);
        return text;
    }

    public ProposalTextField createFormFieldSiblingProposalField(Composite parent, IType declaringType) {
        return this.createFormFieldSiblingProposalField(parent, declaringType, 20);
    }

    public ProposalTextField createFormFieldSiblingProposalField(Composite parent, IType declaringType, int labelPercentage) {
        ITypeHierarchy localHierarchy = TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{declaringType});
        ProposalTextField field = this.createSiblingProposalField(parent, declaringType, TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField"), localHierarchy, labelPercentage);
        SiblingProposal selectedProposal = SiblingProposal.SIBLING_END;
        IType firstButton = ScoutTypeUtility.getFistProcessButton((IType)declaringType, (ITypeHierarchy)localHierarchy);
        if (firstButton != null) {
            selectedProposal = new SiblingProposal((IJavaElement)firstButton);
        }
        field.acceptProposal(selectedProposal);
        return field;
    }

    public ProposalTextField createJavaElementProposalField(Composite parent, String label, AbstractJavaElementContentProvider contentProvider) {
        return this.createJavaElementProposalField(parent, label, contentProvider, 20);
    }

    public ProposalTextField createJavaElementProposalField(Composite parent, String label, AbstractJavaElementContentProvider contentProvider, int labelPercentage) {
        ProposalTextField field = this.createProposalField(parent, label, 1, labelPercentage);
        if (contentProvider != null) {
            field.setLabelProvider((IBaseLabelProvider)contentProvider.getLabelProvider());
            field.setContentProvider(contentProvider);
        }
        return field;
    }
}

