/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields;

import org.eclipse.scout.sdk.ui.util.StyledTextEx;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class TextField
extends Composite {
    private StyledTextEx m_text;
    private Label m_label;
    private Color m_backupTextBackground;
    private final int m_labelPercentage;
    public static final int DEFAULT_LABEL_PERCENTAGE = 20;

    public TextField(Composite parent) {
        this(parent, "");
    }

    public TextField(Composite parent, int labelPercentage) {
        this(parent, "", labelPercentage);
    }

    public TextField(Composite parent, String labelName) {
        this(parent, labelName, 20);
    }

    public TextField(Composite parent, String labelName, int labelPercentage) {
        super(parent, 0);
        this.m_labelPercentage = labelPercentage;
        this.createContent(this);
        this.setLabelText(labelName);
    }

    protected void createContent(Composite parent) {
        this.m_label = new Label(parent, 0);
        this.m_label.setAlignment(131072);
        this.m_text = new StyledTextEx(parent, 2052);
        parent.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(this.getLabelPercentage(), 0);
        labelData.bottom = new FormAttachment(100, 0);
        this.m_label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)this.m_label, 5);
        textData.right = new FormAttachment(100, 0);
        textData.bottom = new FormAttachment(100, 0);
        this.m_text.setLayoutData(textData);
    }

    public void addFocusListener(FocusListener listener) {
        this.m_text.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.m_text.removeFocusListener(listener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.m_text.addVerifyListener(verifyListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.m_text.removeVerifyListener(verifyListener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.m_text.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.m_text.removeModifyListener(listener);
    }

    public void setLabelText(String text) {
        this.m_label.setText(text);
    }

    public String getLabelText() {
        return this.m_label.getText();
    }

    public void setToolTipText(String string) {
        this.m_label.setToolTipText(string);
        this.m_text.setToolTipText(string);
        super.setToolTipText(string);
    }

    public String getToolTipText() {
        return super.getToolTipText();
    }

    public Menu getMenu() {
        return this.m_text.getMenu();
    }

    public void setMenu(Menu menu) {
        this.m_text.setMenu(menu);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.m_text.setText(text);
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void setEditable(boolean editable) {
        this.m_text.setEditable(editable);
    }

    public boolean getEditable() {
        return this.m_text.getEditable();
    }

    public boolean isEditable() {
        return this.m_text.getEditable();
    }

    public boolean setFocus() {
        return this.m_text.setFocus();
    }

    public StyledTextEx getTextComponent() {
        return this.m_text;
    }

    protected Label getLabelComponent() {
        return this.m_label;
    }

    public Point getSelection() {
        return this.m_text.getSelection();
    }

    public void setSelection(int start) {
        this.m_text.setSelection(start);
    }

    public void setSelection(Point point) {
        this.m_text.setSelection(point);
    }

    public boolean getEnabled() {
        if (this.m_text == null) {
            return super.getEnabled();
        }
        return this.m_text.getEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (this.m_backupTextBackground == null) {
            this.m_backupTextBackground = this.m_text.getBackground();
        }
        this.m_text.setEnabled(enabled);
        if (enabled) {
            this.m_text.setBackground(this.m_backupTextBackground);
        } else {
            this.m_text.setBackground(this.getDisplay().getSystemColor(19));
        }
    }

    public int getLabelPercentage() {
        return this.m_labelPercentage;
    }
}

