/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import java.util.EventListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.fields.TextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalDescriptionProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalPopupListener;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalSelectionHandler;
import org.eclipse.scout.sdk.ui.fields.proposal.ISeparatorProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalPopup;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalPopupEvent;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.StyledTextEx;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ProposalTextField
extends TextField {
    public static final int STYLE_DEFAULT = 1;
    public static final int STYLE_INITIAL_SHOW_POPUP = 2;
    public static final int STYLE_NO_LABEL = 1024;
    private IProposalSelectionHandler m_selectionHandler;
    private Button m_popupButton;
    private ProposalPopup m_popup;
    private P_ProposalFieldListener m_proposalFieldListener;
    private IProposalPopupListener m_popupListener;
    private Object m_selectedProposal = null;
    private Object m_input;
    private final EventListenerList m_eventListeners = new EventListenerList();
    private final OptimisticLock m_updateLock = new OptimisticLock();
    private final OptimisticLock m_focusLock = new OptimisticLock();
    private final int m_style;

    public ProposalTextField(Composite parent) {
        this(parent, 1);
    }

    public ProposalTextField(Composite parent, int style) {
        this(parent, style, 20);
    }

    public ProposalTextField(Composite parent, int style, int labelPercentage) {
        super(parent, labelPercentage);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProposalTextField.this.m_popup.dispose();
            }
        });
        this.m_style = style;
        this.init();
    }

    public void setInput(Object input) {
        this.m_input = input;
        ProposalPopup.SearchPatternInput searchPatternInput = new ProposalPopup.SearchPatternInput(input, this.getText());
        this.m_popup.setInput(searchPatternInput);
    }

    public Object getInput() {
        return this.m_input;
    }

    public void setContentProvider(IContentProvider provider) {
        if (!CompareUtility.equals((Object)provider, (Object)this.m_popup.getContentProvider())) {
            this.m_popup.setContentProvider(provider);
            this.acceptProposal(null);
        }
    }

    public IContentProvider getContentProvider() {
        return this.m_popup.getContentProvider();
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.m_popup.setLabelProvider(labelProvider);
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.m_popup.getLabelProvider();
    }

    public void setSelectionHandler(IProposalSelectionHandler selectionHandler) {
        this.m_selectionHandler = selectionHandler;
    }

    public IProposalSelectionHandler getSelectionHandler() {
        return this.m_selectionHandler;
    }

    private void attachProposalListener(StyledText textComponent) {
        if (this.m_proposalFieldListener == null) {
            this.m_proposalFieldListener = new P_ProposalFieldListener();
            textComponent.addListener(1, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(2, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(24, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(16, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(15, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(31, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(4, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(25, (Listener)this.m_proposalFieldListener);
        }
    }

    private void init() {
        Label label = this.getLabelComponent();
        StyledTextEx text = this.getTextComponent();
        FormData labelData = (FormData)label.getLayoutData();
        FormData textData = (FormData)text.getLayoutData();
        if ((this.m_style & 0x400) != 0) {
            label.setVisible(false);
            labelData.right = new FormAttachment(0, 0);
            textData.left = new FormAttachment(0, 0);
        }
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        Label label = this.getLabelComponent();
        StyledTextEx text = this.getTextComponent();
        this.m_popupButton = new Button(parent, 0x800008);
        this.m_popupButton.setImage(ScoutSdkUi.getImage("down.gif"));
        this.m_popupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ProposalTextField.this.m_updateLock.acquire()) {
                        if (ProposalTextField.this.m_popup.isVisible()) {
                            ProposalTextField.this.closePopup();
                        } else {
                            ProposalTextField.this.getTextComponent().setSelection(0);
                            ProposalTextField.this.getTextComponent().setFocus();
                            ProposalTextField.this.updateProposals();
                        }
                    }
                }
                finally {
                    ProposalTextField.this.m_updateLock.release();
                }
            }
        });
        parent.setTabList(new Control[]{text});
        this.m_popup = new ProposalPopup((Control)this.getTextComponent());
        this.m_popupListener = new P_PopupListener();
        this.m_popup.addPopupListener(this.m_popupListener);
        this.attachProposalListener(this.getTextComponent());
        parent.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(this.getLabelPercentage(), 0);
        labelData.bottom = new FormAttachment(100, 0);
        label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)label, 5);
        textData.right = new FormAttachment((Control)this.m_popupButton, -2);
        textData.bottom = new FormAttachment(100, 0);
        text.setLayoutData(textData);
        FormData buttonData = new FormData(22, 22);
        buttonData.top = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.m_popupButton.setLayoutData((Object)buttonData);
    }

    public void addProposalAdapterListener(IProposalAdapterListener listener) {
        this.m_eventListeners.add(IProposalAdapterListener.class, (EventListener)listener);
    }

    public void removeProposalAdapterListener(IProposalAdapterListener listener) {
        this.m_eventListeners.remove(IProposalAdapterListener.class, (EventListener)listener);
    }

    public int getStyle() {
        return this.m_style;
    }

    protected void notifyAcceptProposal(Object proposal) {
        ContentProposalEvent event = new ContentProposalEvent((Object)this);
        event.proposal = proposal;
        IProposalAdapterListener[] iProposalAdapterListenerArray = (IProposalAdapterListener[])this.m_eventListeners.getListeners(IProposalAdapterListener.class);
        int n = iProposalAdapterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProposalAdapterListener l = iProposalAdapterListenerArray[n2];
            l.proposalAccepted(event);
            ++n2;
        }
    }

    public synchronized void acceptProposal(Object proposal) {
        try {
            if (this.m_updateLock.acquire()) {
                String text = proposal != null ? this.m_popup.getText(proposal) : "";
                if (this.getTextComponent() != null) {
                    this.getTextComponent().setText(text);
                    if (this.getLabelProvider() instanceof IContentProposalLabelProvider) {
                        this.getTextComponent().setSelection(((IContentProposalLabelProvider)this.getLabelProvider()).getCursorPosition(proposal));
                    } else {
                        this.getTextComponent().setSelection(text.length());
                    }
                }
            }
        }
        finally {
            this.m_updateLock.release();
        }
        if (!CompareUtility.equals((Object)this.m_selectedProposal, (Object)proposal)) {
            this.m_selectedProposal = proposal;
            this.notifyAcceptProposal(this.m_selectedProposal);
        }
        this.closePopup();
    }

    private synchronized void acceptProposalInternal(Object proposal) {
        if (this.getSelectionHandler() != null) {
            this.getSelectionHandler().handleProposalAccepted(proposal, this.m_popup.getInput().getPattern(), this);
        } else if (!(proposal instanceof ISeparatorProposal)) {
            this.acceptProposal(proposal);
        }
    }

    public void setProposalDescriptionProvider(IProposalDescriptionProvider proposalDescriptionProvider) {
        this.m_popup.setProposalDescriptionProvider(proposalDescriptionProvider);
    }

    public IProposalDescriptionProvider getProposalDescriptionProvider() {
        return this.m_popup.getProposalDescriptionProvider();
    }

    @Override
    public void setText(String text) {
        try {
            if (this.m_updateLock.acquire()) {
                if (text == null) {
                    text = "";
                }
                super.setText(text);
            }
        }
        finally {
            this.m_updateLock.release();
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            this.m_popupButton.setEnabled(editable);
        }
    }

    @Override
    public boolean getEditable() {
        boolean editable = super.getEditable();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            editable = editable && this.m_popupButton.getEnabled();
        }
        return editable;
    }

    @Override
    public boolean isEditable() {
        boolean editable = super.isEditable();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            editable = editable && this.m_popupButton.getEnabled();
        }
        return editable;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            this.m_popupButton.setEnabled(enabled);
        }
    }

    @Override
    public boolean getEnabled() {
        boolean enabled = super.getEnabled();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            enabled = enabled && this.m_popupButton.getEnabled();
        }
        return enabled;
    }

    public boolean isEnabled() {
        boolean enabled = super.isEnabled();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            enabled = enabled && this.m_popupButton.getEnabled();
        }
        return enabled;
    }

    protected synchronized void closePopup() {
        if (this.m_popup.getShell() != null && !this.m_popup.getShell().isDisposed()) {
            this.m_popup.close();
        }
    }

    private synchronized void updateProposals() {
        String pattern = this.getText();
        int index = this.getSelection().x;
        if (index >= 0 && index < pattern.length()) {
            pattern = pattern.substring(0, index);
        }
        this.m_popup.updatePattern(pattern, this.getInput());
        if (!this.m_popup.isVisible()) {
            this.m_popup.open();
        }
    }

    private synchronized void textModified() {
        String text = this.getText();
        int cursorPosition = this.getSelection().x;
        if (cursorPosition > 0 && this.m_selectedProposal != null && this.m_popup.getText(this.m_selectedProposal).equals(text.substring(0, cursorPosition))) {
            return;
        }
        this.updateProposals();
    }

    private boolean isProposalFieldFocusOwner() {
        if (this.m_popup != null && this.m_popup.getShell() != null && !this.m_popup.getShell().isDisposed()) {
            if (this.m_popup.isFocusOwner()) {
                return true;
            }
            Shell[] shells = this.m_popup.getShell().getShells();
            if (shells != null && shells.length > 0) {
                return true;
            }
        }
        if (this.getTextComponent() != null && !this.getTextComponent().isDisposed() && this.getTextComponent().isFocusControl()) {
            return true;
        }
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            return this.m_popupButton.isFocusControl();
        }
        return false;
    }

    public synchronized Object getSelectedProposal() {
        return this.m_selectedProposal;
    }

    private class P_PopupListener
    implements IProposalPopupListener {
        private P_PopupListener() {
        }

        @Override
        public void popupChanged(ProposalPopupEvent event) {
            switch (event.getType()) {
                case 2: {
                    try {
                        ProposalTextField.this.m_focusLock.acquire();
                        ProposalTextField.this.acceptProposalInternal(event.getData("selectedProposal"));
                        Control[] siblings = ProposalTextField.this.getParent().getChildren();
                        if (siblings[siblings.length - 1] == ProposalTextField.this) break;
                        ProposalTextField.this.getTextComponent().traverse(16);
                        break;
                    }
                    finally {
                        ProposalTextField.this.m_focusLock.release();
                    }
                }
                case 16: {
                    ProposalTextField.this.updateProposals();
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
    }

    private class P_ProposalFieldListener
    implements Listener {
        private P_ProposalFieldListener() {
        }

        public void handleEvent(Event event) {
            block1 : switch (event.type) {
                case 24: {
                    try {
                        if (!ProposalTextField.this.m_updateLock.acquire()) break;
                        ProposalTextField.this.textModified();
                        break;
                    }
                    finally {
                        ProposalTextField.this.m_updateLock.release();
                    }
                }
                case 25: {
                    if (!"\t".equals(event.text)) break;
                    event.doit = false;
                    break;
                }
                case 2: {
                    switch (event.keyCode) {
                        case 27: {
                            ProposalTextField.this.closePopup();
                            event.doit = false;
                            break block1;
                        }
                        case 0x1000002: {
                            if (!ProposalTextField.this.m_popup.isVisible()) {
                                ProposalTextField.this.updateProposals();
                                break block1;
                            }
                            ProposalTextField.this.m_popup.setFocus();
                            break block1;
                        }
                        case 0x1000003: 
                        case 0x1000004: {
                            ProposalTextField.this.textModified();
                            break block1;
                        }
                    }
                    break;
                }
                case 16: {
                    ProposalTextField.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ProposalTextField.this.m_popupButton != null && !ProposalTextField.this.m_popupButton.isDisposed() && CompareUtility.equals((Object)ProposalTextField.this.getDisplay().getFocusControl(), (Object)ProposalTextField.this.m_popupButton)) {
                                return;
                            }
                            if (!ProposalTextField.this.isProposalFieldFocusOwner() && !ProposalTextField.this.isDisposed()) {
                                String text = ProposalTextField.this.getText();
                                String input = "";
                                if (ProposalTextField.this.m_selectedProposal != null) {
                                    input = ProposalTextField.this.m_popup.getText(ProposalTextField.this.m_selectedProposal);
                                }
                                if (!StringUtility.equalsIgnoreCase((String)text, (String)input)) {
                                    ProposalTextField.this.acceptProposalInternal(null);
                                }
                                ProposalTextField.this.closePopup();
                            }
                        }
                    });
                    break;
                }
                case 15: {
                    if ((ProposalTextField.this.m_style & 2) == 0) break;
                    ProposalTextField.this.updateProposals();
                    break;
                }
                case 4: {
                    if (ProposalTextField.this.getText().length() <= 0) break;
                    ProposalTextField.this.textModified();
                    break;
                }
                case 31: {
                    switch (event.keyCode) {
                        case 27: {
                            if (!ProposalTextField.this.m_popup.isVisible()) break block1;
                            event.doit = false;
                            break block1;
                        }
                        case 13: {
                            if (!ProposalTextField.this.m_popup.isVisible()) break block1;
                            ProposalTextField.this.acceptProposalInternal(ProposalTextField.this.m_popup.getSelectedProposal());
                            event.doit = false;
                            break block1;
                        }
                        case 9: 
                        case 10: {
                            if (!ProposalTextField.this.m_popup.isVisible()) break block1;
                            event.doit = false;
                            ProposalTextField.this.m_popup.setFocus();
                            break block1;
                        }
                    }
                    break;
                }
            }
        }
    }
}

