/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.extensions.classidgenerators.ClassIdGenerators;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.operation.util.IOrganizeImportService;
import org.eclipse.scout.sdk.service.IMessageBoxService;
import org.eclipse.scout.sdk.sourcebuilder.comment.IJavaElementCommentBuilderService;
import org.eclipse.scout.sdk.ui.IScoutConstants;
import org.eclipse.scout.sdk.ui.internal.ImageRegistry;
import org.eclipse.scout.sdk.ui.internal.SdkIcons;
import org.eclipse.scout.sdk.ui.internal.service.SwtMessageBoxService;
import org.eclipse.scout.sdk.ui.services.AstFlattenerProviderService;
import org.eclipse.scout.sdk.ui.services.JavaElementCommentBuilderService;
import org.eclipse.scout.sdk.ui.services.OrganizeImportService;
import org.eclipse.scout.sdk.ui.view.outline.IScoutExplorerPart;
import org.eclipse.scout.sdk.util.log.SdkLogManager;
import org.eclipse.scout.sdk.util.method.ISimpleNameAstFlattenerProviderService;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ScoutSdkUi
extends AbstractUIPlugin
implements SdkIcons {
    public static final String PLUGIN_ID = "org.eclipse.scout.sdk.ui";
    public static final String COLOR_INACTIVE_FOREGROUND = "inactiveForeground";
    public static final String FONT_SYSTEM_BOLD = "fontSystemBold";
    public static final String FONT_SYSTEM_TITLE = "fontSystemTitle";
    private static final String IMAGE_PATH = "resources/icons/";
    private static ScoutSdkUi plugin;
    private static SdkLogManager logManager;
    private ColorRegistry m_colorRegistry;
    private FontRegistry m_fontRegistry;
    private ServiceRegistration<IOrganizeImportService> m_organizeImportServiceRegistration;
    private ServiceRegistration<IMessageBoxService> m_messageBoxServiceRegistration;
    private IPropertyChangeListener m_preferencesPropertyListener;
    private ServiceRegistration<IJavaElementCommentBuilderService> m_javaElementCommentBuilderService;
    private ServiceRegistration<ISimpleNameAstFlattenerProviderService> m_astFlattenerProviderService;
    private IWorkbenchListener m_shutdownListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        logManager = new SdkLogManager((Plugin)this);
        if (this.m_organizeImportServiceRegistration == null) {
            this.m_organizeImportServiceRegistration = context.registerService(IOrganizeImportService.class, (Object)new OrganizeImportService(), null);
        }
        if (this.m_messageBoxServiceRegistration == null) {
            this.m_messageBoxServiceRegistration = context.registerService(IMessageBoxService.class, (Object)new SwtMessageBoxService(), null);
        }
        if (this.m_javaElementCommentBuilderService == null) {
            this.m_javaElementCommentBuilderService = context.registerService(IJavaElementCommentBuilderService.class, (Object)new JavaElementCommentBuilderService(), null);
        }
        if (this.m_astFlattenerProviderService == null) {
            this.m_astFlattenerProviderService = context.registerService(ISimpleNameAstFlattenerProviderService.class, (Object)new AstFlattenerProviderService(), null);
        }
        if (this.m_preferencesPropertyListener == null) {
            this.m_preferencesPropertyListener = new P_PreferenceStorePropertyListener();
        }
        this.getPreferenceStore().addPropertyChangeListener(this.m_preferencesPropertyListener);
        this.getPreferenceStore().setDefault("org.eclipse.scout.sdk.propAutoUpdate", true);
        ScoutSdkCore.getDtoAutoUpdateManager().setEnabled(this.getPreferenceStore().getBoolean("org.eclipse.scout.sdk.propAutoUpdate"));
        this.getPreferenceStore().setDefault("org.eclipse.scout.sdk.propDefaultTargetPackageConfigEnabled", false);
        DefaultTargetPackage.setIsPackageConfigurationEnabled((!this.getPreferenceStore().getBoolean("org.eclipse.scout.sdk.propDefaultTargetPackageConfigEnabled") ? 1 : 0) != 0);
        this.getPreferenceStore().setDefault("org.eclipse.scout.sdk.propAutomaticallyCreateClassIdAnnotation", false);
        ClassIdGenerators.setAutomaticallyCreateClassIdAnnotation((boolean)this.getPreferenceStore().getBoolean("org.eclipse.scout.sdk.propAutomaticallyCreateClassIdAnnotation"));
        this.m_shutdownListener = new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                try {
                    new P_AutoUpdateOperationsShutdownJob().schedule();
                }
                catch (Exception e) {
                    ScoutSdkUi.logError(e);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        };
        PlatformUI.getWorkbench().addWorkbenchListener(this.m_shutdownListener);
    }

    public void stop(BundleContext context) throws Exception {
        PlatformUI.getWorkbench().removeWorkbenchListener(this.m_shutdownListener);
        if (this.m_preferencesPropertyListener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.m_preferencesPropertyListener);
            this.m_preferencesPropertyListener = null;
        }
        logManager = null;
        plugin = null;
        super.stop(context);
        if (this.m_organizeImportServiceRegistration != null) {
            this.m_organizeImportServiceRegistration.unregister();
            this.m_organizeImportServiceRegistration = null;
        }
        if (this.m_javaElementCommentBuilderService != null) {
            this.m_javaElementCommentBuilderService.unregister();
            this.m_javaElementCommentBuilderService = null;
        }
        if (this.m_messageBoxServiceRegistration != null) {
            this.m_messageBoxServiceRegistration.unregister();
            this.m_messageBoxServiceRegistration = null;
        }
        if (this.m_astFlattenerProviderService != null) {
            this.m_astFlattenerProviderService.unregister();
            this.m_astFlattenerProviderService = null;
        }
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        return this.getDialogSettingsSection(name, true);
    }

    public IDialogSettings getDialogSettingsSection(String name, boolean createIfNotExist) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public static void logInfo(Throwable t) {
        logManager.logInfo(t);
    }

    public static void logInfo(String message) {
        logManager.logInfo(message);
    }

    public static void logInfo(String message, Throwable t) {
        logManager.logInfo(message, t);
    }

    public static void logWarning(String message) {
        logManager.logWarning(message);
    }

    public static void logWarning(Throwable t) {
        logManager.logWarning(t);
    }

    public static void logWarning(String message, Throwable t) {
        logManager.logWarning(message, t);
    }

    public static void logError(Throwable t) {
        logManager.logError(t);
    }

    public static void logError(String message) {
        logManager.logError(message);
    }

    public static void logError(String message, Throwable t) {
        logManager.logError(message, t);
    }

    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static IWorkbenchWindow getWorkbenchWindow() {
        return ScoutSdkUi.getDefault().getWorkbenchWindowImpl();
    }

    public IWorkbenchWindow getWorkbenchWindowImpl() {
        IWorkbenchWindow activeWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            return activeWorkbenchWindow;
        }
        IWorkbenchWindow[] workbenchWindows = this.getWorkbench().getWorkbenchWindows();
        if (workbenchWindows.length > 0) {
            return workbenchWindows[0];
        }
        return null;
    }

    public static Shell getShell() {
        return ScoutSdkUi.getDefault().getShellImpl();
    }

    private Shell getShellImpl() {
        IWorkbenchWindow workbenchWindow = ScoutSdkUi.getWorkbenchWindow();
        if (workbenchWindow != null) {
            return workbenchWindow.getShell();
        }
        return null;
    }

    public static IScoutExplorerPart getExplorer(boolean createIfNotOpen) {
        return ScoutSdkUi.getDefault().getExplorerImpl(createIfNotOpen);
    }

    private IScoutExplorerPart getExplorerImpl(boolean createIfNotOpen) {
        IWorkbenchPage activePage = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IScoutExplorerPart part = null;
        if (activePage != null) {
            IViewPart view = activePage.findView(IScoutConstants.SCOUT_EXPLORER_VIEW);
            if (view == null && createIfNotOpen) {
                try {
                    view = activePage.showView(IScoutConstants.SCOUT_EXPLORER_VIEW);
                    part = (IScoutExplorerPart)view;
                }
                catch (PartInitException e) {
                    ScoutSdkUi.logWarning("could not open view '" + IScoutConstants.SCOUT_EXPLORER_VIEW + "'.", e);
                }
            } else {
                part = (IScoutExplorerPart)view;
            }
        }
        return part;
    }

    public static ScoutSdkUi getDefault() {
        return plugin;
    }

    protected ColorRegistry createColorRegistry() {
        if (Display.getCurrent() != null) {
            return new ColorRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ColorRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    public ColorRegistry getColorRegistry() {
        if (this.m_colorRegistry == null) {
            this.m_colorRegistry = this.createColorRegistry();
            this.initializeColorRegistry(this.m_colorRegistry);
        }
        return this.m_colorRegistry;
    }

    protected void initializeColorRegistry(ColorRegistry colorRegistry) {
        colorRegistry.put(COLOR_INACTIVE_FOREGROUND, new RGB(178, 178, 178));
    }

    public static Color getColor(String colorId) {
        return ScoutSdkUi.getDefault().getColorRegistry().get(colorId);
    }

    public FontRegistry getFontRegistry() {
        if (this.m_fontRegistry == null) {
            this.m_fontRegistry = new FontRegistry(ScoutSdkUi.getDisplay());
            FontData[] systemFontData = ScoutSdkUi.getDisplay().getSystemFont().getFontData();
            FontData[] systemBoldData = new FontData[systemFontData.length];
            int i = 0;
            while (i < systemFontData.length) {
                systemBoldData[i] = new FontData(systemFontData[i].getName(), systemFontData[i].getHeight(), 1);
                ++i;
            }
            this.m_fontRegistry.put(FONT_SYSTEM_BOLD, systemBoldData);
            FontData[] systemTitleData = new FontData[systemFontData.length];
            int i2 = 0;
            while (i2 < systemFontData.length) {
                systemTitleData[i2] = new FontData(systemFontData[i2].getName(), 12, 0);
                ++i2;
            }
            this.m_fontRegistry.put(FONT_SYSTEM_TITLE, systemTitleData);
        }
        return this.m_fontRegistry;
    }

    public static Font getFont(String fontId) {
        return ScoutSdkUi.getDefault().getFontRegistry().get(fontId);
    }

    protected ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    protected void initializeImageRegistry(org.eclipse.jface.resource.ImageRegistry reg) {
        reg.put("output_yes_disabled", ImageDescriptor.createWithFlags((ImageDescriptor)ScoutSdkUi.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"resources/icons/output_yes.gif"), (int)1));
        reg.put("output_no_disabled", ImageDescriptor.createWithFlags((ImageDescriptor)ScoutSdkUi.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"resources/icons/output_no.gif"), (int)1));
        reg.put("web_disabled", ImageDescriptor.createWithFlags((ImageDescriptor)ScoutSdkUi.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"resources/icons/web.gif"), (int)1));
    }

    public ImageRegistry getImageRegistry() {
        return (ImageRegistry)super.getImageRegistry();
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        return ScoutSdkUi.getDefault().getImageImpl(imageDescriptor);
    }

    private Image getImageImpl(ImageDescriptor imageDescriptor) {
        return this.getImageRegistry().get(imageDescriptor);
    }

    public static Image getImage(String name) {
        return ScoutSdkUi.getDefault().getImageImpl(name);
    }

    private Image getImageImpl(String name) {
        Image image = this.getImageRegistry().get(name);
        if (image == null) {
            this.loadImage(name);
            image = this.getImageRegistry().get(name);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return ScoutSdkUi.getDefault().getImageDescriptorImpl(name);
    }

    public static ImageDescriptor getImageDescriptor(String imageName, String decorationImageName, int quadrant) {
        ImageDescriptor baseIcon = ScoutSdkUi.getImageDescriptor(imageName);
        return ScoutSdkUi.getImageDescriptor(baseIcon, decorationImageName, quadrant);
    }

    public static ImageDescriptor getImageDescriptor(ImageDescriptor baseIcon, String decorationImageName, int quadrant) {
        Image baseImage = ScoutSdkUi.getImage(baseIcon);
        ImageDescriptor decorationIcon = ScoutSdkUi.getImageDescriptor(decorationImageName);
        DecorationOverlayIcon decoratedIcon = new DecorationOverlayIcon(baseImage, decorationIcon, quadrant);
        return decoratedIcon;
    }

    private ImageDescriptor getImageDescriptorImpl(String name) {
        ImageDescriptor imageDesc = this.getImageRegistry().getDescriptor(name);
        if (imageDesc == null) {
            this.loadImage(name);
            imageDesc = this.getImageRegistry().getDescriptor(name);
        }
        return imageDesc;
    }

    private void loadImage(String name) {
        ImageDescriptor desc = null;
        if (name.startsWith(IMAGE_PATH)) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)name);
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name));
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".gif"));
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".png"));
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".jpg"));
        }
        if (desc == null) {
            ScoutSdkUi.logWarning("could not find image for plugin: 'org.eclipse.scout.sdk.ui' under: 'resources/icons/" + name + "'.");
        } else {
            this.getImageRegistry().put(name, desc);
        }
    }

    public static Image getImage(IJavaElement element) {
        Image img = null;
        try {
            switch (element.getElementType()) {
                case 7: {
                    if (((IType)element).isInterface()) {
                        img = ScoutSdkUi.getImage("innerinterface_obj.gif");
                        break;
                    }
                    img = ScoutSdkUi.getImage("class_obj.gif");
                    break;
                }
                case 9: {
                    img = ScoutSdkUi.getImage("public_co.gif");
                    break;
                }
                case 8: {
                    img = ScoutSdkUi.getImage("field_private_obj.gif");
                    break;
                }
                default: {
                    img = ScoutSdkUi.getImage("default.gif");
                    break;
                }
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logWarning(e);
        }
        return img;
    }

    public static void showJavaElementInEditor(IJavaElement e, boolean createNew) {
        ScoutSdkUi.getDefault().showJavaElementInEditorImpl(e, createNew);
    }

    private void showJavaElementInEditorImpl(IJavaElement e, boolean createNew) {
        try {
            IEditorPart editor = null;
            if (createNew) {
                editor = JavaUI.openInEditor((IJavaElement)e);
            } else {
                editor = EditorUtility.isOpenInEditor((Object)e);
                if (editor != null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)editor);
                }
            }
            if (editor != null) {
                ITextEditor textEditor;
                IRegion reg;
                JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)e);
                if (editor instanceof ITextEditor && (reg = (textEditor = (ITextEditor)editor).getHighlightRange()) != null) {
                    textEditor.setHighlightRange(reg.getOffset(), reg.getLength(), true);
                }
            }
        }
        catch (Exception ex) {
            ScoutSdkUi.logWarning(ex);
        }
    }

    private static final class P_AutoUpdateOperationsShutdownJob
    extends Job {
        private P_AutoUpdateOperationsShutdownJob() {
            super("Waiting until all derived resources have been updated...");
            this.setUser(true);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        protected IStatus run(IProgressMonitor monitor) {
            Job[] dtoUpdateJobs = null;
            while (!monitor.isCanceled()) {
                dtoUpdateJobs = P_AutoUpdateOperationsShutdownJob.getJobManager().find((Object)"AUTO_UPDATE_JOB_FAMILY");
                if (dtoUpdateJobs.length < 1) {
                    return Status.OK_STATUS;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (dtoUpdateJobs != null && dtoUpdateJobs.length > 0) {
                Job[] jobArray = dtoUpdateJobs;
                int n = dtoUpdateJobs.length;
                int n2 = 0;
                while (n2 < n) {
                    Job j = jobArray[n2];
                    j.cancel();
                    ++n2;
                }
            }
            return Status.CANCEL_STATUS;
        }
    }

    private class P_PreferenceStorePropertyListener
    implements IPropertyChangeListener {
        private P_PreferenceStorePropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Boolean automaticallyCreate;
            if ("org.eclipse.scout.sdk.propAutoUpdate".equals(event.getProperty())) {
                Boolean autoUpdate = (Boolean)event.getNewValue();
                if (autoUpdate != null) {
                    ScoutSdkCore.getDtoAutoUpdateManager().setEnabled(autoUpdate.booleanValue());
                }
            } else if ("org.eclipse.scout.sdk.propDefaultTargetPackageConfigEnabled".equals(event.getProperty())) {
                Boolean useLegacy = (Boolean)event.getNewValue();
                if (useLegacy != null) {
                    DefaultTargetPackage.setIsPackageConfigurationEnabled((useLegacy == false ? 1 : 0) != 0);
                }
            } else if ("org.eclipse.scout.sdk.propAutomaticallyCreateClassIdAnnotation".equals(event.getProperty()) && (automaticallyCreate = (Boolean)event.getNewValue()) != null) {
                ClassIdGenerators.setAutomaticallyCreateClassIdAnnotation((boolean)automaticallyCreate);
            }
        }
    }
}

