/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.codecompletion;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.codecompletion.AbstractSdkProposal;
import org.eclipse.scout.sdk.ui.operation.sourceedit.SourceEditOperation;
import org.eclipse.scout.sdk.ui.wizard.ScoutWizardDialog;
import org.eclipse.scout.sdk.ui.wizard.code.CodeNewWizard;
import org.eclipse.scout.sdk.util.IRegEx;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CodeNewProposal
extends AbstractSdkProposal {
    private IType m_declaringType;

    CodeNewProposal(IType declaringType) {
        this.m_declaringType = declaringType;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    public String getDisplayString() {
        return Texts.get((String)"Action_newTypeX", (String[])new String[]{"Code"});
    }

    public Image getImage() {
        return ScoutSdkUi.getImage("code_add.png");
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        CodeNewWizard wizard = new CodeNewWizard();
        String codeName = null;
        try {
            IDocument document = viewer.getDocument();
            Point wordRange = this.findTriggerWordRange(document, offset);
            if (wordRange != null) {
                codeName = document.get(wordRange.x, wordRange.y - wordRange.x);
                SourceEditOperation removeProposalTextOp = new SourceEditOperation((TextEdit)new ReplaceEdit(wordRange.x, wordRange.y - wordRange.x, ""), viewer.getDocument(), ScoutSdkUi.getDisplay());
                wizard.addAdditionalPerformFinishOperation(removeProposalTextOp, -10.0);
            }
        }
        catch (BadLocationException e) {
            ScoutSdkUi.logWarning(e);
        }
        wizard.initWizard(this.getDeclaringType());
        if (codeName != null && IRegEx.JAVAFIELD.matcher(codeName).matches()) {
            wizard.getCodeNewWizardPage().setTypeName(codeName.trim());
        }
        try {
            IJavaElement sibling = this.findSibling(this.getDeclaringType(), offset, TypeFilters.getSubtypeFilter((IType)TypeUtility.getType((String)"org.eclipse.scout.rt.shared.services.common.code.ICode"), (ITypeHierarchy)TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{this.getDeclaringType()})));
            if (sibling != null) {
                wizard.getCodeNewWizardPage().setSibling(new SiblingProposal(sibling));
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logWarning("could not find sibling.", e);
        }
        ScoutWizardDialog wizardDialog = new ScoutWizardDialog(wizard);
        wizardDialog.open();
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return true;
    }
}

