/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.technology;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.dialog.CheckableTreeSelectionDialog;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyHandler;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyResource;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.technology.ITechnologyListener;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class Technology
implements Comparable<Technology> {
    private static final String TREE_TYPE_BUNDLE = "bundle";
    private static final String TREE_TYPE_RESOURCE = "resource";
    private final String m_id;
    private final String m_name;
    private final String m_category;
    private final ArrayList<IScoutTechnologyHandler> m_handlers = new ArrayList();
    private final EventListenerList m_eventListeners = new EventListenerList();

    public Technology(String id, String name, String category) {
        this.m_id = id;
        this.m_name = name;
        this.m_category = category;
    }

    public void addSelectionChangedListener(ITechnologyListener listener) {
        this.m_eventListeners.add(ITechnologyListener.class, (EventListener)listener);
    }

    public void removeSelectionChangedListener(ITechnologyListener listener) {
        this.m_eventListeners.remove(ITechnologyListener.class, (EventListener)listener);
    }

    private void fireSelectionChanged(boolean newSelection) {
        ITechnologyListener[] iTechnologyListenerArray = (ITechnologyListener[])this.m_eventListeners.getListeners(ITechnologyListener.class);
        int n = iTechnologyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITechnologyListener l = iTechnologyListenerArray[n2];
            try {
                l.selectionChangeCompleted(newSelection);
            }
            catch (Exception e) {
                ScoutSdkUi.logError("error during listener notification.", e);
            }
            ++n2;
        }
    }

    public boolean setSelection(IScoutBundle project, boolean selected) throws CoreException {
        HashSet<IScoutTechnologyResource> allResources = new HashSet<IScoutTechnologyResource>();
        for (IScoutTechnologyHandler handler : this.getHandlers(project)) {
            List<IScoutTechnologyResource> resources = handler.getModifactionResourceCandidates(project);
            if (resources.size() <= 0) continue;
            for (IScoutTechnologyResource res : resources) {
                res.setHandler(handler);
                allResources.add(res);
            }
        }
        ITreeNode changesTree = this.getModificationResourcesTree(allResources.toArray(new IScoutTechnologyResource[allResources.size()]));
        final CheckableTreeSelectionDialog dialog = new CheckableTreeSelectionDialog(Display.getDefault().getActiveShell(), changesTree, Texts.get((String)"ChangeTechnology"), Texts.get((String)"TechnologyResourcesToModifyDesc"));
        dialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("checkedNodes".equals(evt.getPropertyName())) {
                    boolean complete = false;
                    if (evt.getNewValue() instanceof ITreeNode[]) {
                        ITreeNode[] checkedNodes = (ITreeNode[])evt.getNewValue();
                        complete = checkedNodes != null && checkedNodes.length > 0;
                    }
                    dialog.setComplete(complete);
                }
            }
        });
        dialog.setCheckedNodes(this.getDefaultSelectedNodes(changesTree));
        if (dialog.open() == 0) {
            ITreeNode[] selectedNodes = dialog.getCheckedNodes();
            if (selectedNodes != null && selectedNodes.length > 0) {
                OperationJob job = new OperationJob(new IOperation[]{new P_ChangeSelectionOperation(selectedNodes, selected)});
                job.schedule();
            }
            return true;
        }
        return false;
    }

    private ITreeNode[] getDefaultSelectedNodes(ITreeNode root) {
        HashSet<ITreeNode> ret = new HashSet<ITreeNode>();
        this.collectDefaultSelection(root, ret);
        return ret.toArray(new ITreeNode[ret.size()]);
    }

    private void collectDefaultSelection(ITreeNode node, Set<ITreeNode> collector) {
        IScoutTechnologyResource res;
        if (node.isVisible() && node.isCheckable() && node.getData() instanceof IScoutTechnologyResource && (res = (IScoutTechnologyResource)node.getData()).getDefaultSelection()) {
            collector.add(node);
        }
        for (ITreeNode child : node.getChildren()) {
            this.collectDefaultSelection(child, collector);
        }
    }

    private ITreeNode getModificationResourcesTree(IScoutTechnologyResource[] resources) {
        HashMap<String, ArrayList<IScoutTechnologyResource>> mapping = new HashMap<String, ArrayList<IScoutTechnologyResource>>();
        IScoutTechnologyResource[] iScoutTechnologyResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutTechnologyResource res = iScoutTechnologyResourceArray[n2];
            ArrayList<IScoutTechnologyResource> list = (ArrayList<IScoutTechnologyResource>)mapping.get(res.getResource().getProject().getName());
            if (list == null) {
                list = new ArrayList<IScoutTechnologyResource>();
                mapping.put(res.getResource().getProject().getName(), list);
            }
            list.add(res);
            ++n2;
        }
        TreeNode rootNode = new TreeNode("root", "root");
        rootNode.setVisible(false);
        for (Map.Entry bundle : mapping.entrySet()) {
            if (((ArrayList)bundle.getValue()).size() <= 0) continue;
            ImageDescriptor bundleImage = ((IScoutTechnologyResource)((ArrayList)bundle.getValue()).get(0)).getBundleImage();
            ITreeNode bundleNode = TreeUtility.createNode(rootNode, TREE_TYPE_BUNDLE, (String)bundle.getKey(), bundleImage, 0, null, true, false);
            for (IScoutTechnologyResource res : (ArrayList)bundle.getValue()) {
                if (!res.getResource().exists()) continue;
                IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)res.getResource().getAdapter(IWorkbenchAdapter.class);
                ImageDescriptor imageDescriptor = null;
                if (wbAdapter != null) {
                    imageDescriptor = wbAdapter.getImageDescriptor((Object)res.getResource());
                }
                TreeUtility.createNode(bundleNode, TREE_TYPE_RESOURCE, res.getResource().getName(), imageDescriptor, 0, res, false, true);
            }
        }
        return rootNode;
    }

    private List<IScoutTechnologyHandler> getHandlers(IScoutBundle project) {
        ArrayList<IScoutTechnologyHandler> ret = new ArrayList<IScoutTechnologyHandler>(this.m_handlers.size());
        for (IScoutTechnologyHandler h : this.m_handlers) {
            if (!h.isActive(project)) continue;
            ret.add(h);
        }
        return ret;
    }

    public boolean isActive(IScoutBundle project) {
        return this.getHandlers(project).size() > 0;
    }

    public TriState getSelection(IScoutBundle project) throws CoreException {
        List<IScoutTechnologyHandler> handlers = this.getHandlers(project);
        if (handlers.size() == 0) {
            throw new InvalidParameterException("At least one handler must be defined for a technology");
        }
        TriState ret = handlers.get(0).getSelection(project);
        int i = 1;
        while (i < handlers.size()) {
            TriState selection = handlers.get(i).getSelection(project);
            if (selection != null) {
                if (ret == null) {
                    ret = selection;
                } else if (ret != selection) {
                    return TriState.UNDEFINED;
                }
            }
            ++i;
        }
        if (ret == null) {
            return TriState.UNDEFINED;
        }
        return ret;
    }

    public String getName() {
        return this.m_name;
    }

    public String getId() {
        return this.m_id;
    }

    public String getCategory() {
        return this.m_category;
    }

    public void addAllHandlers(Collection<IScoutTechnologyHandler> c) {
        if (c == null || c.size() == 0) {
            return;
        }
        this.m_handlers.addAll(c);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Technology)) {
            return false;
        }
        Technology other = (Technology)obj;
        return this.m_id.equals(other.m_id) && this.m_category.equals(other.m_category) && this.m_name.equals(other.m_name);
    }

    public int hashCode() {
        int hash = this.m_id.hashCode();
        hash ^= this.m_category.hashCode();
        return hash ^= this.m_name.hashCode();
    }

    @Override
    public int compareTo(Technology o) {
        int ret = this.m_category.compareTo(o.m_category);
        if (ret == 0) {
            ret = this.m_name.compareTo(o.m_name);
            if (ret == 0) {
                return this.m_id.compareTo(o.m_id);
            }
            return ret;
        }
        return ret;
    }

    private class P_ChangeSelectionOperation
    implements IOperation {
        private final ITreeNode[] m_selectedNodes;
        private final boolean m_newSelection;
        private boolean success;

        private P_ChangeSelectionOperation(ITreeNode[] selectedNodes, boolean newSelection) {
            this.m_selectedNodes = selectedNodes;
            this.m_newSelection = newSelection;
            this.success = false;
        }

        /*
         * Exception decompiling
         */
        public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public String getOperationName() {
            return "Changing Technology Selection '" + Technology.this.getName() + "'...";
        }

        public void validate() throws IllegalArgumentException {
        }
    }
}

