/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.ui.actions.CollapseAllAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.LRUCache;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.AbstractFilterMenuContributionItem;
import org.eclipse.scout.sdk.ui.action.LinkWithEditorAction;
import org.eclipse.scout.sdk.ui.action.ScoutBundlePresentationActionGroup;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.dialog.workingset.ConfigureScoutWorkingSetsDialog;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerSettingsSupport;
import org.eclipse.scout.sdk.ui.internal.view.outline.clipboard.ExplorerCopyAndPasteSupport;
import org.eclipse.scout.sdk.ui.internal.view.outline.dnd.ExplorerDndSupport;
import org.eclipse.scout.sdk.ui.internal.view.outline.job.FilterOutlineJob;
import org.eclipse.scout.sdk.ui.internal.view.outline.job.LoadInitialOutlineJob;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.library.LibrariesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.AbstractBundleNodeTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.BundleNodeGroupTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ProjectsTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutWorkingSetTablePage;
import org.eclipse.scout.sdk.ui.view.outline.DirtyUpdateManager;
import org.eclipse.scout.sdk.ui.view.outline.IContentProviderListener;
import org.eclipse.scout.sdk.ui.view.outline.IScoutExplorerPart;
import org.eclipse.scout.sdk.ui.view.outline.ViewContentProvider;
import org.eclipse.scout.sdk.ui.view.outline.ViewLabelProvider;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.INodeVisitor;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPageFilter;
import org.eclipse.scout.sdk.workspace.IScoutWorkspaceListener;
import org.eclipse.scout.sdk.workspace.ScoutWorkspaceEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;

public class ScoutExplorerPart
extends ViewPart
implements IScoutExplorerPart {
    public static final int IS_LINKING_ENABLED_PROPERTY = 1;
    private String LINKING_ENABLED = "OutlineView.LINKING_ENABLED";
    private TreeViewer m_viewer;
    private ViewContentProvider m_viewContentProvider;
    private IScoutWorkspaceListener m_workspaceListener;
    private final DirtyUpdateManager m_dirtyManager;
    private final HashSet<IContributionItem> m_debugMenus;
    private final P_ReloadNodeJob m_reloadJob;
    private final LRUCache<String, IPageFilter> m_pageFilterCache;
    private Object m_pageFilterCacheLock = new Object();
    private P_OutlineSelectionProvider m_outlineSelectionProvider;
    private boolean m_linkingEnabled;
    private LinkWithEditorAction m_linkWithEditorAction;

    public ScoutExplorerPart() {
        this.m_pageFilterCache = new LRUCache(1000, -1L);
        this.m_reloadJob = new P_ReloadNodeJob();
        this.m_dirtyManager = new DirtyUpdateManager(this);
        this.m_debugMenus = new HashSet();
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this.m_viewer;
    }

    @Override
    public ViewContentProvider getViewContentProvider() {
        return this.m_viewContentProvider;
    }

    public void createPartControl(Composite parent) {
        Tree tree = new Tree(parent, 770);
        this.m_viewer = new TreeViewer(tree);
        this.m_viewer.addFilter((ViewerFilter)new P_PageFilter());
        this.m_outlineSelectionProvider = new P_OutlineSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.m_outlineSelectionProvider);
        this.m_viewer.setUseHashlookup(true);
        this.m_viewContentProvider = new ViewContentProvider();
        this.m_viewContentProvider.addContentProviderListener(new IContentProviderListener(){

            @Override
            public void handleChildrenLoaded(IPage page) {
                ScoutExplorerPart.this.m_viewer.refresh((Object)page);
            }
        });
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(parent, this));
        this.m_viewer.setContentProvider((IContentProvider)this.m_viewContentProvider);
        this.m_viewer.setSorter(null);
        this.m_viewer.setInput((Object)new InvisibleRootNode(this));
        this.createToolbar();
        this.hookDragAndDrop(this.m_viewer);
        this.hookContextMenu();
        this.hookSelectionAction();
        this.hookDoubleClickAction();
        this.hookKeyActions();
        this.hookViewSiteMenu();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)tree, "org.eclipse.scout.sdk.ui.doc.outline");
        IContextService serivce = (IContextService)this.getSite().getService(IContextService.class);
        serivce.activateContext("org.eclipse.scout.sdk.explorer.context");
        this.m_workspaceListener = new IScoutWorkspaceListener(){

            public void workspaceChanged(ScoutWorkspaceEvent event) {
                switch (event.getType()) {
                    case 10: {
                        new LoadInitialOutlineJob(ScoutExplorerPart.this).schedule();
                    }
                }
            }
        };
        ScoutSdkCore.getScoutWorkspace().addWorkspaceListener(this.m_workspaceListener);
    }

    @Override
    public void expandAndSelectProjectLevel() {
        IPage root = this.getRootPage();
        if (root == null) {
            return;
        }
        try {
            this.m_viewContentProvider.setLoadSync(true);
            final Holder firstBundleGroup = new Holder(IPage.class, null);
            final ArrayList expandedPages = new ArrayList();
            INodeVisitor visitor = new INodeVisitor(){

                @Override
                public int visit(IPage page) {
                    if (page instanceof InvisibleRootNode) {
                        return 1;
                    }
                    if (page instanceof ProjectsTablePage) {
                        expandedPages.add(page);
                        return 1;
                    }
                    if (page instanceof BundleNodeGroupTablePage) {
                        if (page.getParent() instanceof ProjectsTablePage || page.getParent().getScoutBundle().isBinary()) {
                            expandedPages.add(page);
                        }
                        if (!page.getScoutBundle().isBinary() && firstBundleGroup.getValue() == null) {
                            firstBundleGroup.setValue((Object)page);
                        }
                        return 1;
                    }
                    if (page instanceof AbstractBundleNodeTablePage) {
                        if (page.getScoutBundle() != null) {
                            if (!page.getScoutBundle().isBinary() && !ScoutExplorerSettingsSupport.BundlePresentation.Flat.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation()) && !ScoutExplorerSettingsSupport.BundlePresentation.FlatGroups.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation()) || page.getScoutBundle().isBinary() && ScoutExplorerSettingsSupport.BundlePresentation.Hierarchical.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
                                expandedPages.add(page);
                            }
                            if (page.getScoutBundle().isBinary()) {
                                return 1;
                            }
                        }
                        return 3;
                    }
                    if (page instanceof ScoutWorkingSetTablePage) {
                        expandedPages.add(page);
                        return 3;
                    }
                    return 3;
                }
            };
            root.accept(visitor);
            if (expandedPages.size() > 0) {
                this.m_viewer.setExpandedElements((Object[])expandedPages.toArray(new IPage[expandedPages.size()]));
                if (firstBundleGroup.getValue() == null) {
                    this.m_viewer.setSelection((ISelection)new StructuredSelection(expandedPages.get(0)));
                } else {
                    this.m_viewer.setSelection((ISelection)new StructuredSelection(firstBundleGroup.getValue()));
                }
            }
        }
        finally {
            this.m_viewContentProvider.setLoadSync(false);
        }
    }

    @Override
    public IPage getRootPage() {
        return (IPage)this.getTreeViewer().getInput();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.setLinkingEnabled(false);
    }

    public void saveState(IMemento memento) {
        memento.putInteger(this.LINKING_ENABLED, this.m_linkingEnabled ? 1 : 0);
        super.saveState(memento);
    }

    public void dispose() {
        if (this.m_linkWithEditorAction != null) {
            this.m_linkWithEditorAction.dispose();
        }
        ScoutSdkCore.getScoutWorkspace().removeWorkspaceListener(this.m_workspaceListener);
        super.dispose();
    }

    public void setLinkingEnabled(boolean linkingEnabled) {
        this.m_linkingEnabled = linkingEnabled;
        this.firePropertyChange(1);
    }

    public boolean isLinkingEnabled() {
        return this.m_linkingEnabled;
    }

    @Override
    public void markStructureDirty(IPage newPage) {
        this.m_dirtyManager.notifyStructureDirty(newPage);
    }

    @Override
    public void markFilterChanged(IPage page) {
        new FilterOutlineJob(this, page).schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPageFilter getPageFilter(IPage page) {
        String key = this.getPageNodePath(page);
        Object object = this.m_pageFilterCacheLock;
        synchronized (object) {
            return (IPageFilter)this.m_pageFilterCache.get((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPageFilter(IPage page, IPageFilter filter) {
        String key = this.getPageNodePath(page);
        Object object = this.m_pageFilterCacheLock;
        synchronized (object) {
            IPageFilter oldFilter = (IPageFilter)this.m_pageFilterCache.get((Object)key);
            if (!CompareUtility.equals((Object)oldFilter, (Object)filter)) {
                this.m_pageFilterCache.put((Object)key, (Object)filter);
            }
            this.m_reloadJob.reloadDelayed(page);
        }
    }

    private String getPageNodePath(IPage page) {
        StringBuilder b = new StringBuilder();
        IPage tmp = page;
        while (tmp != null) {
            b.insert(0, "/" + tmp.getName());
            tmp = tmp.getParent();
        }
        return b.toString();
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.m_linkWithEditorAction = new LinkWithEditorAction(this);
        this.m_linkWithEditorAction.updateLinkingEnabled(this.isLinkingEnabled());
        mgr.add((IAction)this.m_linkWithEditorAction);
        mgr.add((IAction)new CollapseAllAction(this.getTreeViewer()));
    }

    private void hookViewSiteMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add((IAction)this.m_linkWithEditorAction);
        mgr.add((IAction)new CollapseAllAction(this.getTreeViewer()));
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)new Action(String.valueOf(Texts.get((String)"ConfigureScoutWorkingSets")) + "...", ScoutSdkUi.getImageDescriptor("scoutWorkingSet.png")){

            public void run() {
                ConfigureScoutWorkingSetsDialog d = new ConfigureScoutWorkingSetsDialog(ScoutExplorerPart.this.getSite().getShell());
                d.open();
            }
        });
        mgr.add((IContributionItem)new Separator());
        MenuManager bundleTypes = new MenuManager(Texts.get((String)"BundleTypes"));
        ScoutBundleUiExtension[] scoutBundleUiExtensionArray = ScoutBundleExtensionPoint.getExtensions();
        int n = scoutBundleUiExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutBundleUiExtension e = scoutBundleUiExtensionArray[n2];
            final String bundleType = e.getBundleType();
            bundleTypes.add((IContributionItem)new AbstractFilterMenuContributionItem(e.getBundleName(), !ScoutExplorerSettingsSupport.get().isBundleTypeHidden(bundleType)){

                @Override
                protected void run(boolean selected) {
                    if (selected) {
                        ScoutExplorerSettingsSupport.get().removeHiddenBundleType(bundleType);
                    } else {
                        ScoutExplorerSettingsSupport.get().addHiddenBundleType(bundleType);
                    }
                }
            });
            ++n2;
        }
        mgr.add((IContributionItem)bundleTypes);
        mgr.add((IContributionItem)new AbstractFilterMenuContributionItem(Texts.get((String)"ShowFragments"), ScoutExplorerSettingsSupport.get().isShowFragments()){

            @Override
            protected void run(boolean selected) {
                ScoutExplorerSettingsSupport.get().setShowFragments(selected);
            }
        });
        mgr.add((IContributionItem)new AbstractFilterMenuContributionItem(Texts.get((String)"ShowExternalBundles"), ScoutExplorerSettingsSupport.get().isShowBinaryBundles()){

            @Override
            protected void run(boolean selected) {
                ScoutExplorerSettingsSupport.get().setShowBinaryBundles(selected);
            }
        });
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new ScoutBundlePresentationActionGroup());
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.m_viewer.getControl());
        this.m_viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_viewer);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ScoutExplorerPart.this.fillContextMenu(manager);
            }
        });
    }

    private void fillContextMenu(IMenuManager manager) {
        Object firstElement;
        IStructuredSelection selection;
        if (this.m_debugMenus != null) {
            for (IContributionItem a : this.m_debugMenus) {
                manager.remove(a);
            }
            this.m_debugMenus.clear();
        }
        if (this.m_viewer.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)this.m_viewer.getSelection()).size() == 1 && (firstElement = selection.getFirstElement()) instanceof AbstractPage) {
            ArrayList<Action> debugActions = new ArrayList<Action>();
            AbstractPage page = (AbstractPage)firstElement;
            page.addDebugMenus(debugActions);
            if (debugActions.size() > 0) {
                Separator sep = new Separator();
                this.m_debugMenus.add((IContributionItem)sep);
                manager.add((IContributionItem)sep);
                for (Action a : debugActions) {
                    ActionContributionItem item = new ActionContributionItem((IAction)a);
                    manager.add((IContributionItem)item);
                    this.m_debugMenus.add((IContributionItem)item);
                }
            }
        }
    }

    private void hookSelectionAction() {
        this.m_viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ScoutExplorerPart.this.handleNodeSelection((StructuredSelection)e.getSelection());
            }
        });
    }

    private void hookDragAndDrop(TreeViewer viewer) {
        new ExplorerDndSupport(viewer);
    }

    private void hookKeyActions() {
        this.m_viewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(final KeyEvent e) {
                Object elem;
                List list;
                ISelection sel = ScoutExplorerPart.this.m_viewer.getSelection();
                if (sel instanceof StructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (elem = list.get(0)) instanceof IPage) {
                    final IPage page = (IPage)elem;
                    ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (e.keyCode == 0x100000E) {
                                page.refresh(e.stateMask == 131072);
                            } else if (e.keyCode == 118 && e.stateMask == 262144) {
                                ExplorerCopyAndPasteSupport.performPaste(ScoutExplorerPart.this.m_viewer, page);
                            } else if (e.keyCode == 99 && e.stateMask == 262144) {
                                ExplorerCopyAndPasteSupport.performCopy(ScoutExplorerPart.this.m_viewer, page);
                            }
                        }
                    });
                }
            }
        });
    }

    private void hookDoubleClickAction() {
        this.m_viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ScoutExplorerPart.this.handleNodeAction((IStructuredSelection)((StructuredSelection)e.getSelection()));
            }
        });
    }

    private void handleNodeSelection(StructuredSelection selection) {
        for (Object o : selection) {
            if (!(o instanceof AbstractPage)) continue;
            ((AbstractPage)o).handleSelectionDelegate();
        }
    }

    private void handleNodeAction(IStructuredSelection selection) {
        Object firstElement;
        if (selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof AbstractPage && !((AbstractPage)firstElement).handleDoubleClickedDelegate()) {
            this.m_viewer.setExpandedState(firstElement, !this.m_viewer.getExpandedState(firstElement));
        }
    }

    @Override
    public void setSelection(IStructuredSelection selection) {
        this.getTreeViewer().setSelection((ISelection)selection);
    }

    @Override
    public IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getTreeViewer().getSelection();
    }

    public void setFocus() {
        this.m_viewer.getControl().setFocus();
    }

    public static final class InvisibleRootNode
    extends AbstractPage {
        private final ScoutExplorerPart m_explorerPart;

        public InvisibleRootNode(ScoutExplorerPart explorerPart) {
            this.m_explorerPart = explorerPart;
            this.loadChildren();
        }

        @Override
        public boolean isInitiallyLoaded() {
            return true;
        }

        @Override
        public String getPageId() {
            return "org.eclipse.scout.sdk.page.InvisibleRootNode";
        }

        @Override
        protected void loadChildrenImpl() {
            new ProjectsTablePage(this);
            new LibrariesTablePage(this);
        }

        @Override
        public ScoutExplorerPart getOutlineView() {
            return this.m_explorerPart;
        }
    }

    private class P_OutlineSelectionProvider
    implements ISelectionProvider,
    ISelectionChangedListener {
        private final List<ISelectionChangedListener> m_selectionListeners;
        private final OptimisticLock m_selectionLock = new OptimisticLock();

        public P_OutlineSelectionProvider() {
            this.m_selectionListeners = Collections.synchronizedList(new ArrayList());
            ScoutExplorerPart.this.m_viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.m_selectionListeners.add(listener);
        }

        public ISelection getSelection() {
            return ScoutExplorerPart.this.m_viewer.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.m_selectionListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            if (CompareUtility.notEquals((Object)ScoutExplorerPart.this.getTreeViewer().getSelection(), (Object)selection)) {
                try {
                    if (this.m_selectionLock.acquire()) {
                        ScoutExplorerPart.this.m_viewer.setSelection(selection, true);
                        this.setSelectionWithoutLock(selection);
                    }
                }
                finally {
                    this.m_selectionLock.release();
                }
            }
        }

        private void setSelectionWithoutLock(ISelection selection) {
            ISelectionChangedListener[] iSelectionChangedListenerArray = this.m_selectionListeners.toArray(new ISelectionChangedListener[this.m_selectionListeners.size()]);
            int n = iSelectionChangedListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISelectionChangedListener l = iSelectionChangedListenerArray[n2];
                l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                ++n2;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (ScoutExplorerPart.this.m_viewer.getData("selectionPreventer") != null) {
                return;
            }
            try {
                if (this.m_selectionLock.acquire()) {
                    this.setSelectionWithoutLock(event.getSelection());
                }
            }
            finally {
                this.m_selectionLock.release();
            }
        }
    }

    private class P_PageFilter
    extends ViewerFilter {
        private P_PageFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
            if (parent instanceof IPage) {
                IPage parentPage = (IPage)parent;
                IPageFilter filter = null;
                Object object = ScoutExplorerPart.this.m_pageFilterCacheLock;
                synchronized (object) {
                    filter = (IPageFilter)ScoutExplorerPart.this.m_pageFilterCache.get((Object)ScoutExplorerPart.this.getPageNodePath(parentPage));
                }
                if (filter != null) {
                    int size = elements.length;
                    ArrayList<Object> out = new ArrayList<Object>(size);
                    int i = 0;
                    while (i < size) {
                        if (elements[i] instanceof IPage) {
                            IPage element = (IPage)elements[i];
                            if (filter.accept(element)) {
                                out.add(element);
                            }
                        } else {
                            out.add(elements[i]);
                        }
                        ++i;
                    }
                    return out.toArray(new Object[out.size()]);
                }
            }
            return elements;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return false;
        }
    }

    private class P_ReloadNodeJob
    extends Job {
        private Object lock;
        private IPage m_page;

        public P_ReloadNodeJob() {
            super("reload node");
            this.lock = new Object();
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reloadDelayed(IPage page) {
            Object object = this.lock;
            synchronized (object) {
                this.cancel();
                this.m_page = page;
                this.schedule(300L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Object object = this.lock;
            synchronized (object) {
                ScoutExplorerPart.this.getTreeViewer().getTree().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (P_ReloadNodeJob.this.m_page != null) {
                            ScoutExplorerPart.this.getTreeViewer().refresh((Object)P_ReloadNodeJob.this.m_page);
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

