/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.dnd;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.scout.sdk.ui.extensions.IDragSourceDelegator;
import org.eclipse.scout.sdk.ui.extensions.IDropTargetDelegator;
import org.eclipse.scout.sdk.ui.internal.extensions.DndExtensionPoint;
import org.eclipse.scout.sdk.ui.view.outline.OutlineDropTargetEvent;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class ExplorerDndSupport {
    private final TreeViewer m_outlineTree;

    public ExplorerDndSupport(TreeViewer outlineTree) {
        this.m_outlineTree = outlineTree;
        int ops = 3;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        outlineTree.addDragSupport(ops, transfers, (DragSourceListener)new P_DragSourceAdapter());
        P_DropTargetAdapter adapter = new P_DropTargetAdapter((Viewer)outlineTree);
        adapter.setExpandEnabled(false);
        outlineTree.addDropSupport(ops, transfers, (DropTargetListener)adapter);
    }

    public TreeViewer getOutlineViewer() {
        return this.m_outlineTree;
    }

    private class P_DragSourceAdapter
    extends DragSourceAdapter {
        private IDragSourceDelegator m_currentDragDelegator;

        private P_DragSourceAdapter() {
        }

        public void dragStart(DragSourceEvent event) {
            IDragSourceDelegator[] iDragSourceDelegatorArray = DndExtensionPoint.getDragSourceDelegators();
            int n = iDragSourceDelegatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDragSourceDelegator del = iDragSourceDelegatorArray[n2];
                if (del.acceptDrag(event, ExplorerDndSupport.this.getOutlineViewer())) {
                    this.m_currentDragDelegator = del;
                    return;
                }
                ++n2;
            }
            event.doit = false;
        }

        public void dragSetData(DragSourceEvent event) {
            if (this.m_currentDragDelegator != null) {
                this.m_currentDragDelegator.dragSetData(event, ExplorerDndSupport.this.getOutlineViewer());
            }
        }

        public void dragFinished(DragSourceEvent event) {
            if (this.m_currentDragDelegator != null) {
                this.m_currentDragDelegator.dragFinished(event, ExplorerDndSupport.this.getOutlineViewer());
                this.m_currentDragDelegator = null;
            }
        }
    }

    private class P_DropTargetAdapter
    extends ViewerDropAdapter {
        private IDropTargetDelegator m_currentDropDelegator;

        protected P_DropTargetAdapter(Viewer viewer) {
            super(viewer);
        }

        public void dragOver(DropTargetEvent event) {
            super.dragOver(event);
            if (this.m_currentDropDelegator != null && this.m_currentDropDelegator.expand(this.createDropTargetEvent())) {
                event.feedback |= 0x10;
            }
        }

        public boolean validateDrop(Object target, int operation, TransferData transferData) {
            OutlineDropTargetEvent event = this.createDropTargetEvent();
            event.setTransferData(transferData);
            IDropTargetDelegator[] iDropTargetDelegatorArray = DndExtensionPoint.getDropTargetDelegators();
            int n = iDropTargetDelegatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDropTargetDelegator del = iDropTargetDelegatorArray[n2];
                if (del.validateDrop(event)) {
                    this.m_currentDropDelegator = del;
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public boolean performDrop(Object data) {
            boolean retVal = false;
            if (this.m_currentDropDelegator != null) {
                OutlineDropTargetEvent event = this.createDropTargetEvent();
                event.setTransferObject(data);
                retVal = this.m_currentDropDelegator.performDrop(event);
                this.m_currentDropDelegator = null;
            }
            return retVal;
        }

        private OutlineDropTargetEvent createDropTargetEvent() {
            OutlineDropTargetEvent event = new OutlineDropTargetEvent();
            event.widget = this.getViewer().getControl();
            event.display = this.getViewer().getControl().getDisplay();
            event.setCurrentLocation(this.getCurrentLocation());
            event.setCurrentTarget(this.getCurrentTarget());
            event.setOperation(this.getCurrentOperation());
            event.setSelectedObject(this.getSelectedObject());
            return event;
        }
    }
}

