/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNode;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public abstract class AbstractBundleNodeTablePage
extends AbstractPage {
    private final ScoutBundleNode m_bundle;

    public AbstractBundleNodeTablePage(IPage parentPage, ScoutBundleNode bundle) {
        this.m_bundle = bundle;
        this.setParent(parentPage);
        this.setName(this.m_bundle.getSymbolicName());
        ImageDescriptor icon = this.m_bundle.getUiExtension().getIcon();
        if (bundle.getScoutBundle().isBinary()) {
            icon = ScoutSdkUi.getImageDescriptor(icon, "binary_decoration.png", 2);
        }
        this.setImageDescriptor(icon);
    }

    @Override
    public boolean handleDoubleClickedDelegate() {
        ManifestEditor.openPluginEditor((String)this.m_bundle.getSymbolicName());
        return true;
    }

    @Override
    public final int getOrder() {
        return this.m_bundle.getUiExtension().getOrderNumber();
    }

    @Override
    public final boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public void loadChildrenImpl() {
        for (ScoutBundleNode b : this.m_bundle.getChildBundles()) {
            b.createBundlePage(this);
        }
    }

    @Override
    public final boolean isFolder() {
        return true;
    }

    @Override
    public final IScoutBundle getScoutBundle() {
        return this.m_bundle.getScoutBundle();
    }
}

