/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.multi;

import java.text.DecimalFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.multi.AbstractMultiValuePresenter;
import org.eclipse.scout.sdk.ui.view.properties.presenter.util.MethodBean;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethod;
import org.eclipse.scout.sdk.workspace.type.config.ConfigurationMethodSet;
import org.eclipse.scout.sdk.workspace.type.config.PropertyMethodSourceUtility;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.LongPropertySourceParser;
import org.eclipse.swt.widgets.Composite;

public class MultiLongPresenter
extends AbstractMultiValuePresenter<Long> {
    public MultiLongPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, "[-+0-9\\'Eeinf]*");
    }

    @Override
    protected void init(ConfigurationMethodSet methodSet) throws CoreException {
        super.init(methodSet);
        MethodBean<T>[] methodBeans = this.getMethodBeans();
        long[] ar = new long[methodBeans.length];
        int i = 0;
        while (i < methodBeans.length) {
            ar[i] = (Long)methodBeans[i].getCurrentSourceValue();
            ++i;
        }
        if (!this.allEqual(ar)) {
            this.getTextComponent().setText("###");
        } else {
            this.getTextComponent().setText(this.formatDisplayValue(ar[0]));
        }
    }

    @Override
    protected int getTextAlignment() {
        return 131072;
    }

    @Override
    protected String formatSourceValue(Long value) throws CoreException {
        if (value == Long.MAX_VALUE) {
            return "Long.MAX_VALUE";
        }
        if (value == Long.MIN_VALUE) {
            return "Long.MIN_VALUE";
        }
        return DecimalFormat.getNumberInstance().format(value);
    }

    @Override
    protected String formatDisplayValue(Long value) throws CoreException {
        if (value == Long.MAX_VALUE) {
            return "inf";
        }
        if (value == Long.MIN_VALUE) {
            return "-inf";
        }
        return DecimalFormat.getNumberInstance().format(value);
    }

    @Override
    protected Long parseSourceInput(String input, ConfigurationMethod method) throws CoreException {
        Long d = PropertyMethodSourceUtility.parseReturnParameterLong((String)input, (IMethod)method.peekMethod(), (ITypeHierarchy)method.getSuperTypeHierarchy());
        return d;
    }

    @Override
    protected Long parseDisplayInput(String input) throws CoreException {
        Long d = PropertyMethodSourceUtility.parseReturnParameterLong((String)input);
        return d;
    }

    @Override
    protected synchronized void storeMethods(MethodBean<Long>[] beans, Long value) {
        ArrayList list = new ArrayList();
        MethodBean<Long>[] methodBeanArray = beans;
        int n = beans.length;
        int n2 = 0;
        while (n2 < n) {
            MethodBean<Long> bean = methodBeanArray[n2];
            ConfigurationMethod method = bean.getMethod();
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(ScoutTypeUtility.getConfigurationMethod((IType)method.getType(), (String)method.getMethodName()), (IPropertySourceParser)new LongPropertySourceParser());
            updateOp.setValue((Object)value);
            ++n2;
        }
        new OperationJob(list).schedule();
    }

    private boolean allEqual(long[] ar) {
        if (ar.length > 0) {
            long ref = ar[0];
            long[] lArray = ar;
            int n = ar.length;
            int n2 = 0;
            while (n2 < n) {
                long b = lArray[n2];
                if (b != ref) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }
}

