/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.newproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.table.FilteredTable;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.project.template.ProjectTemplateExtension;
import org.eclipse.scout.sdk.ui.internal.extensions.project.template.ProjectTemplateExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.wizard.newproject.ScoutProjectNewWizard;
import org.eclipse.scout.sdk.ui.wizard.project.AbstractProjectNewWizardPage;
import org.eclipse.scout.sdk.util.PropertyMap;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ScoutProjectTemplateWizardPage
extends AbstractProjectNewWizardPage {
    private FilteredTable m_table;
    private Label m_descriptionLabel;
    private P_ContentProvider m_provider;
    private ProjectTemplateExtension m_selectedTemplate;
    private ProjectTemplateExtension[] m_extensions;

    public ScoutProjectTemplateWizardPage() {
        super(ScoutProjectTemplateWizardPage.class.getName());
        this.setTitle(Texts.get((String)"ScoutApplicationTemplates"));
        this.m_extensions = ProjectTemplateExtensionPoint.getExtensions();
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_table = new FilteredTable(parent, 68100);
        this.m_table.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectTemplateExtension selectedItem = null;
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    selectedItem = (ProjectTemplateExtension)selection.getFirstElement();
                }
                ScoutProjectTemplateWizardPage.this.handleSelection(selectedItem);
                ScoutProjectTemplateWizardPage.this.pingStateChanging();
            }
        });
        this.m_provider = new P_ContentProvider();
        this.m_table.getViewer().setLabelProvider((IBaseLabelProvider)this.m_provider);
        this.m_table.getViewer().setContentProvider((IContentProvider)this.m_provider);
        this.m_table.getViewer().setInput((Object)this.m_provider);
        this.m_descriptionLabel = new Label(parent, 80);
        this.reloadTemplates();
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_table.setLayoutData(new GridData(1808));
        this.m_descriptionLabel.setLayoutData((Object)new GridData(768));
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        super.validatePage(multiStatus);
        multiStatus.add(this.getTemplateStatus());
    }

    protected IStatus getTemplateStatus() {
        if (this.m_selectedTemplate != null) {
            return this.m_selectedTemplate.getTemplate().getStatus();
        }
        return Status.OK_STATUS;
    }

    @Override
    public void putProperties(PropertyMap properties) {
        if (this.m_selectedTemplate != null) {
            properties.setProperty("TEMPLATE_NAME", (Object)this.m_selectedTemplate.getTemplate().getId());
        }
    }

    public void performHelp() {
        ResourceUtility.showUrlInBrowser((String)"https://wiki.eclipse.org/Scout/HowTo/4.0/Create_a_new_project#Step_2");
    }

    public ScoutProjectNewWizard getWizard() {
        return (ScoutProjectNewWizard)super.getWizard();
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        this.getWizard().getProjectWizardPage().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selectedBundles")) {
                    ScoutProjectTemplateWizardPage.this.reloadTemplates();
                }
            }
        });
    }

    private void reloadTemplates() {
        if (this.m_table != null && !this.m_table.isDisposed()) {
            P_ContentProvider contentProvider = (P_ContentProvider)this.m_table.getViewer().getContentProvider();
            ProjectTemplateExtension extToSelect = contentProvider.revalidate();
            this.m_table.refresh(false);
            this.m_selectedTemplate = null;
            if (extToSelect != null) {
                this.m_table.getViewer().setSelection((ISelection)new StructuredSelection((Object)extToSelect));
            } else {
                this.m_table.getViewer().setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    private void handleSelection(ProjectTemplateExtension selectedItem) {
        this.m_selectedTemplate = selectedItem;
        if (this.m_descriptionLabel != null) {
            String description = null;
            if (this.m_selectedTemplate != null) {
                description = this.m_selectedTemplate.getTemplate().getDescription();
            }
            if (description == null) {
                description = "";
            }
            this.m_descriptionLabel.setText(description);
        }
    }

    private class P_ContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private ArrayList<ProjectTemplateExtension> m_activeExtensions = new ArrayList();

        private P_ContentProvider() {
        }

        public ProjectTemplateExtension revalidate() {
            this.m_activeExtensions.clear();
            ProjectTemplateExtension firstExt = null;
            ProjectTemplateExtension[] projectTemplateExtensionArray = ScoutProjectTemplateWizardPage.this.m_extensions;
            int n = projectTemplateExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectTemplateExtension ext = projectTemplateExtensionArray[n2];
                if (ext.getTemplate().isApplicable(ScoutProjectTemplateWizardPage.this.getWizard())) {
                    this.m_activeExtensions.add(ext);
                    if (firstExt == null) {
                        firstExt = ext;
                    }
                }
                ++n2;
            }
            return firstExt;
        }

        public Object[] getElements(Object inputElement) {
            return this.m_activeExtensions.toArray(new ProjectTemplateExtension[this.m_activeExtensions.size()]);
        }

        public String getColumnText(Object element, int columnIndex) {
            ProjectTemplateExtension extension = (ProjectTemplateExtension)element;
            return extension.getTemplate().getText();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ProjectTemplateExtension extension = (ProjectTemplateExtension)element;
            Image img = ScoutSdkUi.getImage(extension.getIconPath());
            return img;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

