/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.jdt.compile.ScoutSeverityManager;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class UiUtility {
    public static void showJavaElementInEditor(IJavaElement e, boolean createNew) {
        try {
            IEditorPart editor = null;
            if (createNew) {
                editor = JavaUI.openInEditor((IJavaElement)e);
            } else {
                editor = EditorUtility.isOpenInEditor((Object)e);
                if (editor != null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)editor);
                }
            }
            if (editor != null) {
                ITextEditor textEditor;
                IRegion reg;
                JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)e);
                if (editor instanceof ITextEditor && (reg = (textEditor = (ITextEditor)editor).getHighlightRange()) != null) {
                    textEditor.setHighlightRange(reg.getOffset(), reg.getLength(), true);
                }
            }
        }
        catch (Exception ex) {
            ScoutSdkUi.logWarning(ex);
        }
    }

    public static Point getTextBounds(String text, Font f, Drawable context) {
        GC gc = new GC(context);
        gc.setFont(f);
        return gc.stringExtent(text);
    }

    public static String getTextForBounds(String origText, Font f, Drawable context, int bounds) {
        return UiUtility.getTextForBounds(origText, f, context, bounds, "\u2026");
    }

    public static String getTextForBounds(String origText, Font f, Drawable context, int bounds, String ellipsis) {
        if (bounds <= 0) {
            return origText;
        }
        String cleanedEllipsis = null;
        cleanedEllipsis = StringUtility.hasText((String)ellipsis) ? ellipsis : "";
        StringBuilder sb = new StringBuilder(origText);
        GC gc = new GC(context);
        gc.setFont(f);
        Point p = gc.stringExtent(sb.toString());
        while (p.x > bounds && sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            p = gc.stringExtent(String.valueOf(sb.toString()) + cleanedEllipsis);
        }
        String ret = sb.toString();
        if (ret.equals(origText)) {
            return origText;
        }
        return String.valueOf(sb.toString()) + cleanedEllipsis;
    }

    public static String getPackageSuffix(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        return UiUtility.getPackageSuffix(UiUtility.adapt(selection.getFirstElement(), IJavaElement.class));
    }

    public static String getPackageSuffix(IJavaElement element) {
        IPackageFragment targetPackage;
        if (TypeUtility.exists((IJavaElement)element) && TypeUtility.exists((IJavaElement)(targetPackage = (IPackageFragment)element.getAncestor(4)))) {
            String pck = targetPackage.getElementName();
            IScoutBundle declaringBundle = ScoutTypeUtility.getScoutBundle((IJavaElement)targetPackage);
            if (declaringBundle != null && pck.startsWith(declaringBundle.getSymbolicName()) && pck.length() > declaringBundle.getSymbolicName().length()) {
                return pck.substring(declaringBundle.getSymbolicName().length() + 1);
            }
        }
        return null;
    }

    public static boolean closeEditors(String editorId, Set<IFile> files) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = w.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                boolean success;
                IWorkbenchPage p = iWorkbenchPageArray[n4];
                IEditorReference[] editorReferences = p.getEditorReferences();
                ArrayList<IEditorReference> partsToSave = new ArrayList<IEditorReference>(editorReferences.length);
                IEditorReference[] iEditorReferenceArray = editorReferences;
                int n5 = editorReferences.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference r = iEditorReferenceArray[n6];
                    if ((editorId == null || editorId.equals(r.getId())) && (files == null || files.isEmpty() || UiUtility.isEditorInputInFiles(r, files))) {
                        partsToSave.add(r);
                    }
                    ++n6;
                }
                if (!partsToSave.isEmpty() && !(success = p.closeEditors(partsToSave.toArray(new IEditorReference[partsToSave.size()]), true))) {
                    return false;
                }
                ++n4;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEditorInputInFiles(IEditorReference ref, Set<IFile> files) {
        try {
            IFile f;
            IEditorInput editorInput = ref.getEditorInput();
            if (!(editorInput instanceof IURIEditorInput)) return false;
            IURIEditorInput input = (IURIEditorInput)editorInput;
            URI uriToSearch = input.getURI();
            Iterator<IFile> iterator = files.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!URIUtil.sameURI((URI)uriToSearch, (URI)(f = iterator.next()).getLocationURI()));
            return true;
        }
        catch (PartInitException e) {
            ScoutSdkUi.logError("Unable to get file input of editor.", e);
        }
        return false;
    }

    public static IScoutBundle getScoutBundleFromSelection(IStructuredSelection selection, IScoutBundle priorityBundle, IScoutBundleFilter filter) {
        IScoutBundle[] bundles;
        IScoutBundle b;
        if (priorityBundle != null) {
            return priorityBundle;
        }
        if (selection != null && (b = UiUtility.adapt(selection.getFirstElement(), IScoutBundle.class)) != null) {
            IScoutBundle candidate;
            if (filter.accept(b)) {
                return b;
            }
            IScoutBundle parentShared = b.getParentBundle(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), b, true);
            if (parentShared != null ? (candidate = parentShared.getChildBundle(ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getWorkspaceBundlesFilter(), filter}), b, true)) != null : (candidate = b.getChildBundle(ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getWorkspaceBundlesFilter(), filter}), b, false)) != null) {
                return candidate;
            }
        }
        IScoutBundle[] iScoutBundleArray = bundles = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getFilteredRootBundlesFilter((IScoutBundleFilter)ScoutBundleFilters.getWorkspaceBundlesFilter()));
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            IScoutBundle root = iScoutBundleArray[n2];
            IScoutBundle candidate = root.getChildBundle(filter, true);
            if (candidate != null) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    public static <T> T adapt(Object element, Class<T> targetClass) {
        if (element == null || targetClass == null) {
            return null;
        }
        if (targetClass.isInstance(element)) {
            return (T)element;
        }
        if (element instanceof IPage) {
            AbstractScoutTypePage astp;
            IType t;
            IPage page = (IPage)element;
            IScoutBundle sb = page.getScoutBundle();
            if (sb != null) {
                element = sb;
            }
            if (page instanceof AbstractScoutTypePage && TypeUtility.exists((IJavaElement)(t = (astp = (AbstractScoutTypePage)page).getType()))) {
                element = t;
            }
        }
        if (element instanceof IAdaptable) {
            IAdaptable ad = (IAdaptable)element;
            Object result = ad.getAdapter(targetClass);
            if (result == null) {
                IJavaElement je;
                IResource r = (IResource)ad.getAdapter(IResource.class);
                if (!ResourceUtility.exists((IResource)r) && TypeUtility.exists((IJavaElement)(je = (IJavaElement)ad.getAdapter(IJavaElement.class)))) {
                    r = je.getResource();
                }
                if (ResourceUtility.exists((IResource)r)) {
                    result = r.getAdapter(targetClass);
                }
            }
            return (T)result;
        }
        return null;
    }

    public static ImageDescriptor getTypeImageDescriptor(IType type) {
        return UiUtility.getTypeImageDescriptor(type, true);
    }

    public static ImageDescriptor getTypeImageDescriptor(IType type, boolean showSeverity) {
        int flags = -1;
        try {
            flags = type.getFlags();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        boolean isInterface = Flags.isInterface((int)flags);
        boolean isInner = TypeUtility.exists((IJavaElement)type.getDeclaringType());
        int severity = 0;
        if (showSeverity) {
            ScoutSeverityManager.getInstance().getSeverityOf((Object)type);
        }
        ImageDescriptor desc = JavaElementImageProvider.getTypeImageDescriptor((boolean)isInner, (boolean)isInterface, (int)flags, (boolean)false);
        int adornmentFlags = 0;
        if (Flags.isFinal((int)flags)) {
            adornmentFlags |= 2;
        }
        if (Flags.isAbstract((int)flags) && !isInterface) {
            adornmentFlags |= 1;
        }
        if (Flags.isStatic((int)flags)) {
            adornmentFlags |= 8;
        }
        if (Flags.isDeprecated((int)flags)) {
            adornmentFlags |= 0x400;
        }
        if (severity == 2) {
            adornmentFlags |= 0x40;
        } else if (severity == 1) {
            adornmentFlags |= 0x20;
        }
        return new JavaElementImageDescriptor(desc, adornmentFlags, JavaElementImageProvider.BIG_SIZE);
    }
}

