/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.outline.pages;

import java.util.regex.Pattern;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPageFilter;

public class PageFilter
implements IPageFilter {
    private String m_filterExpression;
    private boolean m_regExFilter;
    private Pattern m_patternInternal;

    public PageFilter() {
        this.createPattern();
    }

    @Override
    public String getFilterExpression() {
        return this.m_filterExpression;
    }

    public void setFilterExpression(String s) {
        if (s != null && s.trim().length() == 0) {
            s = null;
        }
        this.m_filterExpression = s;
        this.createPattern();
    }

    public boolean isRegExFilter() {
        return this.m_regExFilter;
    }

    public void setRegExFilter(boolean b) {
        this.m_regExFilter = b;
        this.createPattern();
    }

    private void createPattern() {
        String regex = this.getFilterExpression();
        if (regex != null) {
            regex = regex.toLowerCase();
            try {
                if (!this.isRegExFilter()) {
                    if (!regex.endsWith("*")) {
                        regex = String.valueOf(regex) + "*";
                    }
                    regex = regex.replaceAll("\\?", ".").replaceAll("\\*", ".*");
                }
                if (!regex.endsWith("$")) {
                    regex = String.valueOf(regex) + ".*$";
                }
                this.m_patternInternal = Pattern.compile(regex);
            }
            catch (Exception e) {
                this.m_patternInternal = null;
            }
        } else {
            this.m_patternInternal = Pattern.compile(".*");
        }
    }

    @Override
    public boolean isEmpty() {
        return this.m_filterExpression == null;
    }

    @Override
    public boolean accept(IPage page) {
        return this.m_patternInternal == null || this.m_patternInternal.matcher(page.getName().toLowerCase()).matches();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PageFilter) {
            PageFilter other = (PageFilter)obj;
            return this.m_regExFilter == other.m_regExFilter && CompareUtility.equals((Object)this.m_filterExpression, (Object)other.m_filterExpression);
        }
        return false;
    }

    public int hashCode() {
        return 1;
    }
}

