/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.beanproperty;

import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IBeanPropertyNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureLabelProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureProposalProvider;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.IRegEx;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.IMethodFilter;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.MethodFilters;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BeanPropertyNewWizardPage
extends AbstractWorkspaceWizardPage {
    private String m_beanName;
    private String m_beanSignature;
    private StyledTextField m_beanNameField;
    private ProposalTextField m_beanTypeField;
    private IBeanPropertyNewOperation m_operation;
    private Set<String> m_notAllowedNames;
    private final IJavaSearchScope m_searchScope;
    private final IType m_declaringType;
    private IType[] m_allValueFields;

    public BeanPropertyNewWizardPage(IJavaSearchScope searchScope, IType declaringType) {
        super(BeanPropertyNewWizardPage.class.getName());
        this.m_searchScope = searchScope;
        this.m_declaringType = declaringType;
        this.setTitle(Texts.get((String)"NewPropertyBean"));
        this.setDescription(Texts.get((String)"NewPropertyBeanDesc"));
        ITypeHierarchy typeHierarchy = TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{this.m_declaringType});
        this.m_allValueFields = ScoutTypeUtility.getAllTypes((ICompilationUnit)this.m_declaringType.getCompilationUnit(), (ITypeFilter)TypeFilters.getSubtypeFilter((IType)TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IValueField"), (ITypeHierarchy)typeHierarchy));
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_beanNameField = new StyledTextField(parent, Texts.get((String)"Dialog_rename_oldNameLabel"));
        this.m_beanNameField.setText(this.getBeanName());
        this.m_beanNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BeanPropertyNewWizardPage.this.m_beanName = BeanPropertyNewWizardPage.this.m_beanNameField.getText();
                BeanPropertyNewWizardPage.this.pingStateChanging();
            }
        });
        SignatureLabelProvider labelProvider = new SignatureLabelProvider();
        SignatureProposalProvider contentProvider = new SignatureProposalProvider(this.m_searchScope, labelProvider, SignatureProposalProvider.DEFAULT_MOST_USED, true);
        contentProvider.setPrimitivSignatures(SignatureProposalProvider.DEFAULT_PRIMITIV_SIGNATURES);
        this.m_beanTypeField = this.getFieldToolkit().createProposalField(parent, Texts.get((String)"Dialog_propertyBean_typeLabel"));
        this.m_beanTypeField.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.m_beanTypeField.setContentProvider(contentProvider);
        this.m_beanTypeField.acceptProposal(this.getBeanSignature());
        this.m_beanTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    BeanPropertyNewWizardPage.this.setStateChanging(true);
                    BeanPropertyNewWizardPage.this.m_beanSignature = (String)event.proposal;
                }
                finally {
                    BeanPropertyNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_beanNameField.setLayoutData(new GridData(768));
        this.m_beanTypeField.setLayoutData(new GridData(768));
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getPropertyNameStatus());
        multiStatus.add(this.getPropertyTypeStatus());
    }

    private IStatus getPropertyNameStatus() {
        String propertyName = this.getBeanName();
        if (propertyName == null || propertyName.length() == 0) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_className"));
        }
        String name = NamingUtility.ensureStartWithUpperCase((String)this.getBeanName());
        if (this.m_notAllowedNames != null && (this.m_notAllowedNames.contains("get" + name) || this.m_notAllowedNames.contains("set" + name) || this.m_notAllowedNames.contains("is" + name))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        IType[] iTypeArray = this.m_allValueFields;
        int n = this.m_allValueFields.length;
        int n2 = 0;
        while (n2 < n) {
            IType valueField = iTypeArray[n2];
            String fieldName = ScoutUtility.removeFieldSuffix((String)valueField.getElementName());
            if (name.equals(fieldName)) {
                return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
            }
            ++n2;
        }
        if (TypeUtility.getMethods((IType)this.m_declaringType, (IMethodFilter)MethodFilters.getNameRegexFilter((Pattern)Pattern.compile("^(get|set|is)" + name))).length > 0) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        if (IRegEx.WELLFORMED_PROPERTY.matcher(propertyName).matches()) {
            return Status.OK_STATUS;
        }
        if (IRegEx.JAVAFIELD.matcher(propertyName).matches()) {
            return new Status(2, "org.eclipse.scout.sdk.ui", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_invalidFieldX", (String[])new String[]{propertyName}));
    }

    private IStatus getPropertyTypeStatus() {
        String signature = this.getBeanSignature();
        if (signature == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_beanTypeNull"));
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager manager) throws CoreException {
        this.m_operation.setBeanName(this.getBeanName());
        this.m_operation.setBeanTypeSignature(this.getBeanSignature());
        this.m_operation.setMethodFlags(1);
        this.m_operation.run(monitor, manager);
        return true;
    }

    public Set<String> getNotAllowedNames() {
        return this.m_notAllowedNames;
    }

    public void setNotAllowedNames(Set<String> notAllowedNames) {
        this.m_notAllowedNames = notAllowedNames;
    }

    public IBeanPropertyNewOperation getOperation() {
        return this.m_operation;
    }

    public void setOperation(IBeanPropertyNewOperation operation) {
        this.m_operation = operation;
    }

    public String getBeanName() {
        return this.m_beanName;
    }

    public void setBeanName(String beanName) {
        try {
            this.setStateChanging(true);
            this.m_beanName = beanName;
            if (this.isControlCreated()) {
                this.m_beanNameField.setText(beanName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getBeanSignature() {
        return this.m_beanSignature;
    }

    public void setBeanSignature(String beanSignature) {
        try {
            this.setStateChanging(true);
            this.m_beanSignature = beanSignature;
            if (this.isControlCreated()) {
                this.m_beanTypeField.acceptProposal(beanSignature);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }
}

