/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.handler;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.FormHandlerNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.form.handler.FormHandlerNewWizardPage1;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FormHandlerNewWizardPage2
extends AbstractWorkspaceWizardPage {
    private String m_typeName;
    private StyledTextField m_typeNameField;
    private final IType m_declaringType;
    private IType m_createdFormHandler;

    public FormHandlerNewWizardPage2(IType declaringType) {
        super(FormHandlerNewWizardPage2.class.getName());
        this.setTitle(Texts.get((String)"NewFormHandler"));
        this.setDescription(Texts.get((String)"CreateANewCalendarFormHandler"));
        this.m_declaringType = declaringType;
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("Handler");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormHandlerNewWizardPage2.this.m_typeName = FormHandlerNewWizardPage2.this.m_typeNameField.getText();
                FormHandlerNewWizardPage2.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        FormHandlerNewOperation operation = new FormHandlerNewOperation(this.getTypeName(), this.m_declaringType, true);
        FormHandlerNewWizardPage1 previousPage = (FormHandlerNewWizardPage1)this.getWizard().getPreviousPage((IWizardPage)this);
        if (previousPage.getSelectedSuperType() != null) {
            operation.setSuperTypeSignature(SignatureCache.createTypeSignature((String)previousPage.getSelectedSuperType().getFullyQualifiedName()));
        }
        IStructuredType structuredType = ScoutTypeUtility.createStructuredForm((IType)this.m_declaringType);
        operation.setSibling(structuredType.getSiblingTypeFormHandler(this.getTypeName()));
        operation.run(monitor, workingCopyManager);
        this.m_createdFormHandler = operation.getCreatedType();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"Handler");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        if (TypeUtility.exists((IJavaElement)this.getDeclaringType().getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        return javaFieldNameStatus;
    }

    public IType getCreatedFormHandler() {
        return this.m_createdFormHandler;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }
}

